# 機能設計書 56-llvm-config

## 概要

本ドキュメントは、LLVMプロジェクトにおけるllvm-configツールの機能設計を記述する。llvm-configは、LLVMプロジェクトの設定情報（インストールパス、コンパイルフラグ、ライブラリ情報等）を出力するツールであり、外部プロジェクトがLLVMを利用する際のビルド設定に使用される。

### 本機能の処理概要

llvm-configは、LLVMプロジェクトのビルド設定情報をクエリするためのコマンドラインツールである。configureスクリプトやビルドシステムから呼び出され、LLVMを使用するプログラムをコンパイルするために必要なフラグ、パス、ライブラリ情報を提供する。

**業務上の目的・背景**：LLVMを利用する外部プロジェクト（コンパイラ、解析ツール等）をビルドする際、正しいインクルードパス、ライブラリパス、リンクフラグが必要となる。llvm-configは、これらの情報を一元的に提供することで、ビルドシステムの構成を簡素化し、異なるLLVMバージョンやインストール構成への対応を容易にする。

**機能の利用シーン**：
- Makefileやconfigureスクリプトでのビルド設定取得
- CMakeの外部プロジェクトでのLLVM検出
- LLVMベースのツール開発環境構築
- インストール済みLLVMの情報確認

**主要な処理内容**：
1. 実行環境の検出（開発ツリー内/インストール済み）
2. コンポーネント依存関係の解決
3. 要求された設定情報の出力
4. プラットフォーム固有の設定対応

**関連システム・外部連携**：
- ビルドシステム（Make, CMake, Autoconf等）
- LLVMライブラリ群

**権限による制御**：本ツールはファイルシステムへの読み取りアクセスのみを必要とする。

## 関連画面

本ツールはCLI（コマンドラインインターフェース）ツールであり、GUI画面は存在しない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | 設定オプションの指定、結果の標準出力への表示 |

## 機能種別

設定情報クエリ / ビルド支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --version | bool | No | LLVMバージョンを表示 | - |
| --prefix | bool | No | インストールプレフィックスを表示 | - |
| --bindir | bool | No | 実行ファイルディレクトリを表示 | - |
| --includedir | bool | No | ヘッダファイルディレクトリを表示 | - |
| --libdir | bool | No | ライブラリディレクトリを表示 | - |
| --cmakedir | bool | No | CMakeモジュールディレクトリを表示 | - |
| --cppflags | bool | No | Cプリプロセッサフラグを表示 | - |
| --cflags | bool | No | Cコンパイラフラグを表示 | - |
| --cxxflags | bool | No | C++コンパイラフラグを表示 | - |
| --ldflags | bool | No | リンカフラグを表示 | - |
| --system-libs | bool | No | システムライブラリを表示 | - |
| --libs | bool | No | 必要なライブラリを表示 | - |
| --libnames | bool | No | ライブラリファイル名を表示 | - |
| --libfiles | bool | No | ライブラリフルパスを表示 | - |
| --components | bool | No | 利用可能なコンポーネント一覧を表示 | - |
| --targets-built | bool | No | ビルド済みターゲット一覧を表示 | - |
| --host-target | bool | No | ホストターゲットトリプルを表示 | - |
| --build-mode | bool | No | ビルドモード（Debug/Release等）を表示 | - |
| --assertion-mode | bool | No | アサーションモード（ON/OFF）を表示 | - |
| --build-system | bool | No | ビルドシステム（cmake/gn）を表示 | - |
| --has-rtti | bool | No | RTTI有効/無効を表示 | - |
| --shared-mode | bool | No | 共有/静的ライブラリモードを表示 | - |
| --obj-root | bool | No | オブジェクトルートを表示 | - |
| --link-shared | bool | No | 共有ライブラリでリンク | - |
| --link-static | bool | No | 静的ライブラリでリンク | - |
| --ignore-libllvm | bool | No | libLLVMを無視してコンポーネント個別リンク | - |
| --quote-paths | bool | No | パスを引用符でクォート | - |
| --help | bool | No | ヘルプを表示 | - |
| components | list<string> | No | 情報を取得するコンポーネント名 | 有効なコンポーネント名 |

### 入力データソース

- ビルド時に生成された設定ファイル（BuildVariables.inc, LibraryDependencies.inc）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ConfigInfo | text | 要求された設定情報 |

### 出力先

- 標準出力

## 処理フロー

### 処理シーケンス

```
1. 実行環境検出
   └─ 開発ツリー内かインストール済みかを判定
2. ディレクトリパス計算
   └─ 環境に応じたパスを設定
3. リンクモード決定
   └─ 共有/静的ライブラリモードを決定
4. コマンドライン引数処理
   └─ 各オプションに応じて情報を出力
5. コンポーネント依存解決
   └─ 必要なライブラリを依存順にリスト化
6. 結果出力
   └─ 標準出力への表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[実行パス取得]
    B --> C{開発ツリー内?}
    C -->|Yes| D[開発ツリーパス設定]
    C -->|No| E[インストールパス設定]
    D --> F[プラットフォーム検出]
    E --> F
    F --> G[リンクモード決定]
    G --> H[引数ループ開始]
    H --> I{オプション判定}
    I -->|--version| J[バージョン出力]
    I -->|--prefix| K[プレフィックス出力]
    I -->|--libs| L[ライブラリ計算・出力]
    I -->|その他| M[対応情報出力]
    J --> N{次の引数あり?}
    K --> N
    L --> N
    M --> N
    N -->|Yes| H
    N -->|No| O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 環境自動検出 | 開発ツリー/インストール環境を自動判定 | 常時 |
| BR-02 | コンポーネント依存解決 | トポロジカルソートで依存ライブラリを順序付け | --libs/--libnames/--libfiles時 |
| BR-03 | リンクモード自動選択 | 共有ライブラリ優先、なければ静的 | --link-*未指定時 |
| BR-04 | プラットフォーム対応 | Windows/macOS/Linux向けパス形式対応 | 常時 |
| BR-05 | 大文字小文字無視 | コンポーネント名は大文字小文字を区別しない | コンポーネント指定時 |

### 計算ロジック

- コンポーネント依存関係はLibraryDependencies.incから読み込み
- visitComponent関数で再帰的に依存を解決
- リバースして依存順（リンカ順）に並べ替え

## データベース操作仕様

本ツールはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 入力エラー | 不明なコンポーネント名を指定 | 有効なコンポーネント名を使用 |
| 1 | 設定エラー | --link-sharedだが共有ライブラリが存在しない | --link-staticを使用 |

### リトライ仕様

リトライ処理は実装されていない（単発クエリツール）。

## トランザクション仕様

該当なし（読み取り専用処理）。

## パフォーマンス要件

即座に応答することが期待される（ビルドシステムから頻繁に呼び出される）。

## セキュリティ考慮事項

- ファイル読み取り権限のみを必要とする
- ビルド設定情報を出力するため、セキュリティ上の機密情報は含まない

## 備考

- LLVMのMakefileビルドとCMakeビルドの両方に対応
- CMakeプロジェクトでは直接CMakeモジュールを使用することも可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定情報の格納に使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BuildVariables.inc.in | `llvm/tools/llvm-config/BuildVariables.inc.in` | ビルド変数のテンプレート |

**読解のコツ**: BuildVariables.incはビルド時にCMakeによって生成され、LLVM_VERSION、パス、フラグ等を定義する。

#### Step 2: エントリーポイントを理解する

処理の起点となるmain関数を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-config.cpp | `llvm/tools/llvm-config/llvm-config.cpp` | main関数と引数処理ループ |

**主要処理フロー**:
1. **281-292行目**: 変数初期化
2. **293-324行目**: 開発ツリー/インストール環境の判定
3. **326-377行目**: ディレクトリパスの計算
4. **386-424行目**: プラットフォーム別拡張子設定
5. **426-452行目**: リンクモードの決定
6. **533-639行目**: 引数ループ（各オプションの処理）
7. **649-770行目**: --libs等の処理とコンポーネント解決

#### Step 3: コンポーネント依存解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-config.cpp | `llvm/tools/llvm-config/llvm-config.cpp` | visitComponent関数（81-155行目） |
| 3-2 | llvm-config.cpp | `llvm/tools/llvm-config/llvm-config.cpp` | computeLibsForComponents関数（165-201行目） |

**主要処理フロー**:
- **81-155行目**: visitComponent - 再帰的依存解決
- **165-201行目**: computeLibsForComponents - コンポーネントリストからライブラリリスト生成
- **198行目**: std::reverse - リンカ順に並べ替え

### プログラム呼び出し階層図

```
main()
    │
    ├─ getExecutablePath()
    │      └─ sys::fs::getMainExecutable()
    │
    ├─ 環境検出
    │      └─ sys::fs::equivalent()
    │
    ├─ 引数ループ
    │      ├─ --version, --prefix, ... 単純出力
    │      │
    │      ├─ --libs, --libnames, --libfiles
    │      │      └─ computeLibsForComponents()
    │      │             └─ visitComponent() [再帰]
    │      │
    │      └─ --system-libs
    │
    └─ 結果出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

コマンドライン  ───▶ main()
引数                   │
                       ├─ 環境検出
                       │
BuildVariables.inc ───▶ ビルド変数参照
LibraryDependencies.inc
                       │
                       ├─ オプション判定
                       │
                       ├─ computeLibsForComponents()
                       │      └─ visitComponent()
                       │
                       ▼
                  設定情報  ───▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-config.cpp | `llvm/tools/llvm-config/llvm-config.cpp` | ソース | メインエントリーポイント |
| CMakeLists.txt | `llvm/tools/llvm-config/CMakeLists.txt` | ビルド設定 | ビルド構成の定義 |
| BuildVariables.inc.in | `llvm/tools/llvm-config/BuildVariables.inc.in` | テンプレート | ビルド変数定義テンプレート |
| LibraryDependencies.inc | (生成ファイル) | 設定 | コンポーネント依存関係 |
| ExtensionDependencies.inc | (生成ファイル) | 設定 | 拡張機能依存関係 |
