# 機能設計書 57-llvm-cxxfilt

## 概要

本ドキュメントは、LLVMプロジェクトにおけるllvm-cxxfiltツールの機能設計を記述する。llvm-cxxfiltは、C++のマングル名（name mangling）をデマングルして人間が読める形式に変換するツールである。

### 本機能の処理概要

llvm-cxxfiltは、C++コンパイラがシンボル名に対して行うマングリング（名前修飾）を解除し、元の関数名やクラス名を復元するコマンドラインツールである。GNU c++filtと互換性があり、Itanium C++ ABI（GCC/Clang）のマングル名を主にサポートする。

**業務上の目的・背景**：C++コンパイラは、オーバーロードや名前空間を区別するために関数名をマングル（修飾）する。デバッグやバイナリ解析時、マングル名は非常に読みにくいため、元の名前に戻す（デマングル）必要がある。llvm-cxxfiltはこの変換を自動化し、開発者の生産性を向上させる。

**機能の利用シーン**：
- nmやobjdumpの出力のシンボル名解読
- スタックトレースの解析
- リンカエラーメッセージの解読
- バイナリ解析・リバースエンジニアリング

**主要な処理内容**：
1. マングル名の入力（引数または標準入力）
2. マングル名の識別とデマングル処理
3. デマングル結果の出力

**関連システム・外部連携**：
- LLVMのDemangle ライブラリとの連携
- パイプラインでnm、objdump等と連携

**権限による制御**：本ツールはファイルシステムへのアクセスを必要としない（標準入出力のみ）。

## 関連画面

本ツールはCLI（コマンドラインインターフェース）ツールであり、GUI画面は存在しない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | マングル名の入力、デマングル結果の表示 |

## 機能種別

文字列変換 / デマングル処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| mangled | list<string> | No | デマングルするシンボル名（複数可） | - |
| -_ / --strip-underscore | bool | No | 先頭のアンダースコアを削除 | - |
| -n / --no-strip-underscore | bool | No | アンダースコアを保持 | - |
| -p / --no-params | bool | No | 関数パラメータを省略 | - |
| -q / --quote | bool | No | デマングル結果を引用符で囲む | - |
| -t / --types | bool | No | 型もデマングル | - |
| --help | bool | No | ヘルプを表示 | - |
| --version | bool | No | バージョンを表示 | - |

### 入力データソース

- コマンドライン引数
- 標準入力（シンボル名未指定時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DemangledName | text | デマングルされたシンボル名 |

### 出力先

- 標準出力

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数パース
   └─ オプションとシンボル名を取得
2. 入力ソース判定
   ├─ 引数あり: 各引数をデマングル
   └─ 引数なし: 標準入力から行単位で読み込み
3. 各シンボルのデマングル
   ├─ アンダースコア処理（オプションに応じて）
   ├─ nonMicrosoftDemangle()試行
   ├─ itaniumDemangle()試行
   └─ import thunk対応
4. 結果出力
   └─ クォート処理（オプションに応じて）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数パース]
    B --> C{シンボル指定あり?}
    C -->|Yes| D[各シンボルをdemangleLine]
    C -->|No| E[標準入力から読み込み]
    E --> F[行ごとにdemangleLine]
    D --> G[demangle関数呼び出し]
    F --> G
    G --> H{--strip-underscore?}
    H -->|Yes| I[先頭_を削除]
    H -->|No| J[そのまま]
    I --> K[nonMicrosoftDemangle試行]
    J --> K
    K --> L{成功?}
    L -->|Yes| M[結果出力]
    L -->|No| N[itaniumDemangle試行]
    N --> O{成功?}
    O -->|Yes| M
    O -->|No| P[元の名前をそのまま出力]
    M --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 行分割 | 標準入力の場合、マングル名以外の文字で区切って処理 | 標準入力時 |
| BR-02 | import thunk | `__imp_`プレフィックスを「import thunk for」として処理 | シンボルが__imp_で始まる場合 |
| BR-03 | クォート | --quoteでデマングル結果を""で囲む | --quoteオプション指定時 |
| BR-04 | パラメータ省略 | --no-paramsで関数パラメータを出力しない | --no-paramsオプション指定時 |
| BR-05 | 有効文字判定 | 英数字、.、$、_ がマングル名の有効文字 | 行分割時 |

### 計算ロジック

デマングルアルゴリズム：
1. nonMicrosoftDemangle() - 非Microsoft形式（Itanium ABI等）を試行
2. itaniumDemangle() - Itanium C++ ABIのデマングル
3. 失敗時は元の文字列をそのまま返す

## データベース操作仕様

本ツールはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 入力エラー | 不正なオプション | ヘルプを参照 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

即座に応答することが期待される（パイプラインで使用されることが多い）。

## セキュリティ考慮事項

- ファイルシステムへのアクセスなし
- メモリ安全性はDemangleライブラリに依存

## 備考

- GNU c++filtと互換性がある
- Itanium C++ ABIが主なサポート対象

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

デマングル処理に使用されるオプション構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Opts.td | `llvm/tools/llvm-cxxfilt/Opts.td` | オプション定義（TableGen形式） |

**読解のコツ**: Opts.tdはTableGen形式でオプションを定義し、Opts.incが自動生成される。

#### Step 2: エントリーポイントを理解する

処理の起点となるmain関数を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-cxxfilt.cpp | `llvm/tools/llvm-cxxfilt/llvm-cxxfilt.cpp` | llvm_cxxfilt_main関数 |

**主要処理フロー**:
1. **160-166行目**: 引数パース
2. **167-179行目**: ヘルプ/バージョン表示
3. **181-188行目**: オプション取得（StripUnderscore, ParseParams, Quote, Types）
4. **190-196行目**: シンボル処理（引数または標準入力）

#### Step 3: デマングル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-cxxfilt.cpp | `llvm/tools/llvm-cxxfilt/llvm-cxxfilt.cpp` | demangle関数（78-107行目） |
| 3-2 | llvm-cxxfilt.cpp | `llvm/tools/llvm-cxxfilt/llvm-cxxfilt.cpp` | demangleLine関数（146-158行目） |

**主要処理フロー**:
- **78-85行目**: アンダースコア処理
- **88-90行目**: nonMicrosoftDemangle試行
- **95-101行目**: itaniumDemangleとimport thunk処理
- **146-158行目**: 行分割とデマングル呼び出し

#### Step 4: 文字列分割処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llvm-cxxfilt.cpp | `llvm/tools/llvm-cxxfilt/llvm-cxxfilt.cpp` | SplitStringDelims関数（112-133行目） |
| 4-2 | llvm-cxxfilt.cpp | `llvm/tools/llvm-cxxfilt/llvm-cxxfilt.cpp` | IsLegalItaniumChar関数（137-141行目） |

### プログラム呼び出し階層図

```
llvm_cxxfilt_main()
    │
    ├─ CxxfiltOptTable::parseArgs()
    │
    ├─ [シンボル指定あり]
    │      └─ demangleLine() [x N]
    │             └─ demangle()
    │
    └─ [シンボル指定なし]
           └─ std::getline() ループ
                  └─ demangleLine()
                         ├─ SplitStringDelims()
                         │      └─ IsLegalItaniumChar()
                         │
                         └─ demangle()
                                ├─ nonMicrosoftDemangle()
                                └─ itaniumDemangle()
```

### データフロー図

```
[入力]               [処理]                    [出力]

コマンドライン  ───▶ parseArgs()
引数                   │
        または         │
標準入力        ───▶ std::getline()
                       │
                       ▼
                  demangleLine()
                       │
                       ├─ SplitStringDelims()
                       │
                       └─ demangle()
                              │
                              ├─ nonMicrosoftDemangle()
                              │
                              └─ itaniumDemangle()
                                     │
                                     ▼
                              デマングル結果 ───▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-cxxfilt.cpp | `llvm/tools/llvm-cxxfilt/llvm-cxxfilt.cpp` | ソース | メインエントリーポイント |
| Opts.td | `llvm/tools/llvm-cxxfilt/Opts.td` | TableGen | オプション定義 |
| CMakeLists.txt | `llvm/tools/llvm-cxxfilt/CMakeLists.txt` | ビルド設定 | ビルド構成の定義 |
| Demangle.h | `llvm/include/llvm/Demangle/Demangle.h` | ヘッダー | デマングルAPI定義 |
