# 機能設計書 6-Flang

## 概要

本ドキュメントは、Flang（Fortranフロントエンドコンパイラ）の機能設計を記述する。FlangはLLVMプロジェクトのFortran言語向けフロントエンドコンパイラであり、最新のFortran標準をサポートする。

### 本機能の処理概要

Flangは、Fortranソースコードを解析し、LLVM中間表現（IR）を生成する。Clangのドライバインフラストラクチャを活用して、プリプロセス、コンパイル、アセンブル、リンクの各フェーズを統合的に制御する。

**業務上の目的・背景**：Fortran言語向けの高性能でモダンなLLVMベースのコンパイラを提供する。科学計算や高性能計算（HPC）分野で広く使用されるFortranコードを、LLVMの最適化インフラストラクチャを活用してコンパイルすることで、高い実行性能を実現する。

**機能の利用シーン**：
- Fortranソースコードのコンパイル
- 科学計算・数値計算プログラムの構築
- HPC（高性能計算）アプリケーションの開発
- レガシーFortranコードの近代化
- OpenMP並列化コードのコンパイル

**主要な処理内容**：
1. ソースファイルのプリプロセス処理
2. 字句解析と構文解析（パースツリー生成）
3. 意味解析と型チェック
4. FIR（Fortran中間表現）の生成
5. LLVM IR生成（コード生成）
6. ドライバによるコンパイルパイプライン制御

**関連システム・外部連携**：
- LLVM Coreとの連携（コード生成、最適化）
- Clangドライバインフラストラクチャの活用
- LLDリンカとの連携
- MLIRとの連携（FIR dialect）

**権限による制御**：特になし（コマンドラインツールとして実行）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | FlangはCLIツールであり、GUI画面は持たない |

## 機能種別

コンパイラフロントエンド / ドライバ / コード生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ソースファイル | string | Yes | 入力ソースファイル | .f/.f90/.f95等 |
| -o | string | No | 出力ファイル名 | 有効なパス |
| -c | flag | No | コンパイルのみ（リンクなし） | true/false |
| -S | flag | No | アセンブリ出力 | true/false |
| -E | flag | No | プリプロセスのみ | true/false |
| -O | char | No | 最適化レベル | 0, 1, 2, 3, s, z |
| -std | string | No | Fortran標準 | f2018等 |
| -target | string | No | ターゲットトリプル | 有効なトリプル |
| -I | string | No | インクルードパス | 有効なディレクトリ |
| -D | string | No | マクロ定義 | 有効な識別子 |
| -fopenmp | flag | No | OpenMP有効化 | true/false |

### 入力データソース

- Fortranソースファイル（.f, .f90, .f95, .f03, .f08, .f18）
- 固定形式ソース（.f, .for）
- 自由形式ソース（.f90以降）
- Fortranモジュールファイル（.mod）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | .o | コンパイル済みオブジェクト |
| 実行ファイル | - | リンク済み実行ファイル |
| アセンブリ | .s | アセンブリ出力 |
| プリプロセス出力 | .i | プリプロセス結果 |
| LLVM IR | .ll/.bc | 中間表現 |
| モジュールファイル | .mod | Fortranモジュール情報 |
| 診断メッセージ | text | エラー/警告 |

### 出力先

- ファイル（-oオプションで指定）
- 標準出力（プリプロセス等）
- 標準エラー（診断メッセージ）

## 処理フロー

### 処理シーケンス

```
1. ドライバ初期化
   └─ コマンドライン解析、ターゲット検出
2. コンパイルアクション構築
   └─ フェーズ（プリプロセス/コンパイル/アセンブル/リンク）決定
3. fc1フロントエンド実行
   └─ プリプロセス → 構文解析 → 意味解析 → FIR生成 → LLVM IR生成
4. アセンブル（必要な場合）
   └─ アセンブリからオブジェクト生成
5. リンク（必要な場合）
   └─ オブジェクトファイルのリンク
6. 結果出力
   └─ 生成物の出力と診断メッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ドライバ初期化]
    B --> C[コマンドライン解析]
    C --> D{-fc1モード?}
    D -->|Yes| E[fc1_main実行]
    D -->|No| F[Compilation構築]
    E --> G[フロントエンド処理]
    F --> H[ジョブ生成]
    H --> I[ExecuteCompilation]
    G --> J{出力フェーズ}
    I --> J
    J -->|-E| K[プリプロセス出力]
    J -->|-S| L[アセンブリ出力]
    J -->|-c| M[オブジェクト出力]
    J -->|リンク| N[実行ファイル出力]
    K --> O[終了]
    L --> O
    M --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 言語推定 | 拡張子からソース形式を自動判定 | 明示指定なし時 |
| BR-002 | ターゲット推定 | ホストシステムがデフォルトターゲット | -target未指定時 |
| BR-003 | fc1インプロセス | fc1をインプロセスまたはサブプロセスで実行 | ドライバ判断 |
| BR-004 | 出力名決定 | 入力ファイル名から出力名を決定 | -o未指定時 |
| BR-005 | 固定/自由形式 | 拡張子で固定形式(.f)または自由形式(.f90)を判定 | 明示指定なし時 |

### 計算ロジック

- ヘッダ検索パス解決：システムパス、-I指定、モジュール検索
- モジュール依存解決：USE文による依存関係処理
- 配列次元計算：Fortranの配列仕様処理

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | Flangはデータベースを使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------
| 1 | 構文エラー | 不正なFortranコード | ソースを修正 |
| 1 | リンクエラー | シンボル未解決 | ライブラリを追加 |
| 1 | ファイルエラー | ファイルが存在しない | パスを確認 |
| 70 | 内部エラー | コンパイラのバグ | バグ報告 |
| 1 | モジュールエラー | .modファイル不在 | モジュールをコンパイル |

### リトライ仕様

リトライは行わない。エラー発生時は終了コードで通知。

## トランザクション仕様

Flangはデータベーストランザクションを使用しない。

## パフォーマンス要件

- 大規模Fortranプロジェクトの効率的なコンパイル
- モジュールファイルによるインクリメンタルコンパイル
- OpenMP並列化サポート

## セキュリティ考慮事項

- 入力ファイルの検証
- ランタイムバウンドチェックオプション（-fcheck=bounds）

## 備考

FlangはMLIRベースのFIR（Fortran Intermediate Representation）を使用し、モダンなコンパイラアーキテクチャを採用している。Clangのドライバインフラストラクチャを再利用することで、堅牢なコンパイル制御を実現している。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ドライバを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | driver.cpp | `flang/tools/flang-driver/driver.cpp` | ドライバエントリーポイント |

**主要処理フロー**:
1. **86-89行目**: main関数 - メインエントリー、InitLLVM初期化
2. **92-93行目**: getTargetAndModeFromProgramName - ターゲットモード取得
3. **100-113行目**: -fc1モードの分岐判定
4. **110-112行目**: executeFC1Tool呼び出し（fc1モード時）
5. **137-141行目**: clang::driver::Driver生成とターゲット設定
6. **145-146行目**: BuildCompilation - コンパイルジョブ構築
7. **175行目**: ExecuteCompilation - コンパイル実行

#### Step 2: fc1フロントエンドの分岐処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | driver.cpp | `flang/tools/flang-driver/driver.cpp` | fc1ツール実行 |

**主要処理フロー（executeFC1Tool関数）**:
- **64-74行目**: executeFC1Tool関数 - fc1_mainへの分岐
- **66-67行目**: "-fc1"引数チェックとfc1_main呼び出し

#### Step 3: レスポンスファイル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | driver.cpp | `flang/tools/flang-driver/driver.cpp` | レスポンスファイル展開 |

**主要処理フロー**:
- **76-84行目**: ExpandResponseFiles関数
- **98行目**: レスポンスファイル展開呼び出し

### プログラム呼び出し階層図

```
main (driver.cpp:86)
    │
    ├─ InitLLVM
    ├─ getTargetAndModeFromProgramName
    ├─ getExecutablePath
    ├─ ExpandResponseFiles
    │
    ├─ [-fc1] executeFC1Tool (driver.cpp:64)
    │      └─ fc1_main (fc1_main.cpp)
    │             └─ CompilerInvocation
    │             └─ ExecuteCompilerInvocation
    │                    ├─ FrontendAction
    │                    └─ CodeGen
    │
    └─ [driver] Driver::BuildCompilation (driver.cpp:146)
           ├─ setTargetAndMode
           ├─ setPreferredLinker
           └─ Driver::ExecuteCompilation (driver.cpp:175)
                  └─ Command実行（fc1呼び出し）
```

### データフロー図

```
ソースファイル(.f90)
        │
        v
+------------------+
|    ドライバ      | ← コマンドライン引数
|  (driver.cpp)    |
+------------------+
        │
        ├─[fc1モード]──────────────────┐
        │                              │
        v                              v
+------------------+          +------------------+
| Clang Driver     |          |    fc1_main      |
| BuildCompilation |          |   フロントエンド   |
+------------------+          +------------------+
        │                              │
        v                              v
+------------------+          +------------------+
| ExecuteCompilation|         |   パース/解析     |
| (fc1サブプロセス) |          |    FIR生成       |
+------------------+          +------------------+
        │                              │
        └────────────┬─────────────────┘
                     v
              +-------------+
              |  LLVM IR    |
              +-------------+
                     │
                     v
              +-------------+
              |   出力      |
              | (.o/.s/exe) |
              +-------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| driver.cpp | `flang/tools/flang-driver/driver.cpp` | ソース | ドライバエントリー |
| fc1_main.cpp | `flang/tools/flang-driver/fc1_main.cpp` | ソース | fc1エントリー |
| CompilerInvocation.cpp | `flang/lib/Frontend/CompilerInvocation.cpp` | ソース | コンパイラ設定 |
| FrontendAction.cpp | `flang/lib/Frontend/FrontendAction.cpp` | ソース | フロントエンド処理 |
| TextDiagnosticPrinter.cpp | `flang/lib/Frontend/TextDiagnosticPrinter.cpp` | ソース | 診断メッセージ出力 |
| Driver.h | `clang/include/clang/Driver/Driver.h` | ヘッダ | Clangドライバ（共用） |
