# 機能設計書 64-obj2yaml

## 概要

本ドキュメントは、LLVM obj2yaml ツールの機能設計について記載する。obj2yamlは、各種オブジェクトファイルをYAML形式に変換するツールである。

### 本機能の処理概要

obj2yamlは、ELF、COFF、Mach-O、Wasm、XCOFFなど多様なバイナリフォーマットのオブジェクトファイルを読み込み、その構造と内容をYAML形式でダンプするツールである。テスト用ファイルの作成やオブジェクトファイルの構造調査に活用される。

**業務上の目的・背景**：コンパイラやリンカのテストにおいて、特定の構造を持つオブジェクトファイルが必要になることがある。obj2yamlを使用することで、既存のオブジェクトファイルをYAML形式でダンプし、編集してからyaml2objで再生成することが可能となる。また、オブジェクトファイルの構造を人間が読める形式で調査できる。

**機能の利用シーン**：
- オブジェクトファイルの構造調査・学習
- テスト用オブジェクトファイルのYAML記述作成
- バイナリフォーマット間の変換プロセスにおける中間表現生成
- コンパイラ/リンカの出力検証

**主要な処理内容**：
1. 入力ファイルのマジックナンバー判定によるフォーマット識別
2. フォーマットに応じた専用変換関数の呼び出し
3. オブジェクトファイル構造のYAML形式への変換
4. 結果の標準出力または指定ファイルへの出力

**関連システム・外部連携**：LLVM Object ライブラリ、ObjectYAML ライブラリ

**権限による制御**：特になし（ファイルシステムへのアクセス権限のみ必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIツール | 主機能 | コマンドラインインターフェースによる操作 |

## 機能種別

ファイル変換処理 / データダンプ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 入力ファイル | string | No | オブジェクトファイルパス（省略時は標準入力） | ファイルが存在すること |
| -o | string | No | 出力ファイルパス（省略時は標準出力） | - |
| --raw-segment | enum | No | Mach-O: 指定セグメントを生データとしてダンプ | data/linkedit |

### 入力データソース

- ファイルシステム上のオブジェクトファイル（ELF、COFF、Mach-O、Wasm、XCOFF、Archive、DXContainer、MinidumpOffload）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| YAMLダンプ | YAML | オブジェクトファイルの構造をYAML形式で表現 |

### 出力先

- 標準出力（-o未指定時）
- 指定ファイル（-oオプション指定時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ 入力ファイル、出力ファイルオプションの解析

2. 入力ファイルの読み込み
   └─ MemoryBuffer::getFileOrSTDINで読み込み

3. マジックナンバー判定
   └─ identify_magic()でフォーマット識別

4. フォーマット別処理
   └─ archive: archive2yaml()
   └─ dxcontainer: dxcontainer2yaml()
   └─ offload: offload2yaml()
   └─ その他: createBinary()でバイナリオブジェクト作成後分岐
       ├─ MachO: macho2yaml()
       ├─ COFF: coff2yaml()
       ├─ ELF: elf2yaml()
       ├─ Wasm: wasm2yaml()
       ├─ XCOFF: xcoff2yaml()
       └─ Minidump: minidump2yaml()

5. YAML出力
   └─ 標準出力またはファイルへ書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[ファイル読み込み]
    C --> D[identify_magic]
    D --> E{フォーマット?}
    E -->|archive| F[archive2yaml]
    E -->|dxcontainer| G[dxcontainer2yaml]
    E -->|offload| H[offload2yaml]
    E -->|その他| I[createBinary]
    I --> J{バイナリ種別?}
    J -->|MachO| K[macho2yaml]
    J -->|COFF| L[coff2yaml]
    J -->|ELF| M[elf2yaml]
    J -->|Wasm| N[wasm2yaml]
    J -->|XCOFF| O[xcoff2yaml]
    J -->|Minidump| P[minidump2yaml]
    F --> Q[出力]
    G --> Q
    H --> Q
    K --> Q
    L --> Q
    M --> Q
    N --> Q
    O --> Q
    P --> Q
    Q --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-64-1 | 自動フォーマット検出 | マジックナンバーにより入力ファイルのフォーマットを自動判定 | 常時 |
| BR-64-2 | 標準入力対応 | 入力ファイル未指定時は標準入力から読み込み | 入力ファイル未指定時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（データベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル読み込みエラー | 入力ファイルが読み込めない | エラーメッセージを表示し終了 |
| - | 出力ファイルエラー | 出力ファイルを開けない | エラーメッセージを表示し終了 |
| - | 未対応フォーマット | サポートしていないフォーマット | llvm_unreachableで終了 |

### リトライ仕様

なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に定義なし

## セキュリティ考慮事項

- 入力ファイルへの読み取りアクセス権限が必要
- 出力ファイルへの書き込みアクセス権限が必要

## 備考

- yaml2objツールと対になるツールであり、obj2yaml → yaml2objの往復変換が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | obj2yaml.cpp | `llvm/tools/obj2yaml/obj2yaml.cpp` | main関数とdumpInput関数 |

**主要処理フロー**:
1. **101-123行目**: main関数、引数解析と出力ファイルオープン
2. **54-89行目**: dumpInput関数、フォーマット判定と処理分岐
3. **38-52行目**: dumpObject関数、ObjectFile種別に応じた変換

#### Step 2: 各フォーマット変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | elf2yaml.cpp | `llvm/tools/obj2yaml/elf2yaml.cpp` | ELF形式の変換 |
| 2-2 | coff2yaml.cpp | `llvm/tools/obj2yaml/coff2yaml.cpp` | COFF形式の変換 |
| 2-3 | macho2yaml.cpp | `llvm/tools/obj2yaml/macho2yaml.cpp` | Mach-O形式の変換 |

### プログラム呼び出し階層図

```
main()
    │
    ├─ cl::ParseCommandLineOptions()
    │
    └─ dumpInput()
           │
           ├─ identify_magic()
           │
           ├─ archive2yaml() [archive]
           ├─ dxcontainer2yaml() [dxcontainer]
           ├─ offload2yaml() [offload]
           │
           └─ createBinary()
                  │
                  ├─ dumpObject()
                  │      ├─ coff2yaml()
                  │      ├─ xcoff2yaml()
                  │      ├─ elf2yaml()
                  │      └─ wasm2yaml()
                  │
                  ├─ macho2yaml() [MachO/Universal]
                  └─ minidump2yaml() [Minidump]
```

### データフロー図

```
[入力]                   [処理]                     [出力]

オブジェクトファイル
       │
       ▼
MemoryBuffer::getFileOrSTDIN()
       │
       ▼
identify_magic()
       │
       ▼
フォーマット別変換関数
       │
       ▼
YAML出力 ─────────────────────────▶ 標準出力/ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| obj2yaml.cpp | `llvm/tools/obj2yaml/obj2yaml.cpp` | ソース | メインプログラム |
| obj2yaml.h | `llvm/tools/obj2yaml/obj2yaml.h` | ヘッダ | 変換関数宣言 |
| elf2yaml.cpp | `llvm/tools/obj2yaml/elf2yaml.cpp` | ソース | ELF変換 |
| coff2yaml.cpp | `llvm/tools/obj2yaml/coff2yaml.cpp` | ソース | COFF変換 |
| macho2yaml.cpp | `llvm/tools/obj2yaml/macho2yaml.cpp` | ソース | Mach-O変換 |
| wasm2yaml.cpp | `llvm/tools/obj2yaml/wasm2yaml.cpp` | ソース | Wasm変換 |
| xcoff2yaml.cpp | `llvm/tools/obj2yaml/xcoff2yaml.cpp` | ソース | XCOFF変換 |
| archive2yaml.cpp | `llvm/tools/obj2yaml/archive2yaml.cpp` | ソース | Archive変換 |
| minidump2yaml.cpp | `llvm/tools/obj2yaml/minidump2yaml.cpp` | ソース | Minidump変換 |
| dxcontainer2yaml.cpp | `llvm/tools/obj2yaml/dxcontainer2yaml.cpp` | ソース | DXContainer変換 |
| dwarf2yaml.cpp | `llvm/tools/obj2yaml/dwarf2yaml.cpp` | ソース | DWARF情報変換 |
| offload2yaml.cpp | `llvm/tools/obj2yaml/offload2yaml.cpp` | ソース | Offload変換 |
| CMakeLists.txt | `llvm/tools/obj2yaml/CMakeLists.txt` | ビルド | ビルド設定 |
