# 機能設計書 65-yaml2obj

## 概要

本ドキュメントは、LLVM yaml2obj ツールの機能設計について記載する。yaml2objは、YAMLファイルからバイナリオブジェクトファイルを生成するツールである。

### 本機能の処理概要

yaml2objは、YAML形式で記述されたオブジェクトファイルの構造定義を読み込み、ELF、COFF、Mach-O、Wasmなどのバイナリオブジェクトファイルを生成するツールである。テスト用のオブジェクトファイル作成に特化している。

**業務上の目的・背景**：コンパイラやリンカ、デバッガなどのツール開発において、特定の構造を持つテスト用オブジェクトファイルが必要になる。yaml2objを使用することで、YAML形式で人間が読み書きしやすい形式でオブジェクトファイルの構造を定義し、バイナリファイルを生成できる。LLVMプロジェクトのテストインフラストラクチャで広く活用されている。

**機能の利用シーン**：
- LLVMツールのテストケース作成
- 特定の構造を持つオブジェクトファイルの生成
- バイナリフォーマットの学習・実験
- デバッガやプロファイラのテスト用入力ファイル生成

**主要な処理内容**：
1. YAMLファイルの読み込みとプリプロセス（マクロ展開）
2. YAML構造の解析とオブジェクトファイル種別の判定
3. 種別に応じたバイナリ生成処理
4. 結果の標準出力または指定ファイルへの出力

**関連システム・外部連携**：LLVM ObjectYAML ライブラリ

**権限による制御**：特になし（ファイルシステムへのアクセス権限のみ必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIツール | 主機能 | コマンドラインインターフェースによる操作 |

## 機能種別

ファイル生成処理 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 入力ファイル | string | No | YAMLファイルパス（省略時は標準入力） | ファイルが存在すること |
| -o | string | No | 出力ファイルパス（省略時は標準出力） | - |
| -D | string | No | マクロ定義（形式: マクロ名=値）、複数指定可 | マクロ名が空でないこと |
| -E | flag | No | プリプロセスのみ実行（バイナリ生成せず） | - |
| --docnum | uint | No | 複数ドキュメントYAML時の対象ドキュメント番号（デフォルト: 1） | 正の整数 |
| --max-size | uint64 | No | 最大出力サイズ（バイト、デフォルト: 10MB、0=無制限）[ELFのみ] | - |

### 入力データソース

- ファイルシステム上のYAMLファイル
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | バイナリ | YAMLから生成されたオブジェクトファイル |
| プリプロセス結果 | テキスト | -Eオプション時のマクロ展開後YAML |

### 出力先

- 標準出力（-o未指定時）
- 指定ファイル（-oオプション指定時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ 入力ファイル、出力ファイル、マクロ定義等の解析

2. 入力ファイルの読み込み
   └─ MemoryBuffer::getFileOrSTDINで読み込み

3. プリプロセス処理
   └─ [[マクロ名]]形式のマクロ展開
   └─ [[マクロ名=デフォルト値]]形式のデフォルト値対応

4. -Eオプション時
   └─ プリプロセス結果を出力して終了

5. YAML解析とバイナリ生成
   └─ yaml::Input でYAML解析
   └─ convertYAML()でバイナリ生成

6. 出力
   └─ 標準出力またはファイルへ書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[ファイル読み込み]
    C --> D[プリプロセス]
    D --> E{-Eオプション?}
    E -->|Yes| F[プリプロセス結果出力]
    F --> G[終了]
    E -->|No| H[yaml::Input解析]
    H --> I[convertYAML]
    I --> J[出力]
    J --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-1 | マクロ構文 | [[マクロ名]]または[[マクロ名=デフォルト値]]形式 | -Dオプションまたはデフォルト値使用時 |
| BR-65-2 | 標準入力対応 | 入力ファイル未指定時は標準入力から読み込み | 入力ファイル未指定時 |
| BR-65-3 | 最大サイズ制限 | ELF出力時、デフォルトで10MBの制限あり | ELF生成時 |
| BR-65-4 | ドキュメント番号 | 複数ドキュメントYAMLの場合、--docnumで対象を指定 | 複数ドキュメントYAML時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（データベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル読み込みエラー | 入力ファイルが読み込めない | エラーメッセージを表示し終了 |
| - | 出力ファイルエラー | 出力ファイルを開けない | エラーメッセージを表示し終了 |
| - | マクロ定義エラー | -Dオプションの形式が不正 | エラーメッセージを表示し終了 |
| - | マクロ再定義エラー | 同じマクロが複数回定義 | エラーメッセージを表示し終了 |
| - | YAML解析エラー | YAMLの形式が不正 | エラーメッセージを表示し終了 |
| - | 変換エラー | バイナリ生成に失敗 | エラーメッセージを表示し終了 |

### リトライ仕様

なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に定義なし

## セキュリティ考慮事項

- 入力ファイルへの読み取りアクセス権限が必要
- 出力ファイルへの書き込みアクセス権限が必要

## 備考

- obj2yamlツールと対になるツールであり、obj2yaml → yaml2objの往復変換が可能
- LLVMテストで広く使用されており、テストケースのYAMLファイルが多数存在

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | yaml2obj.cpp | `llvm/tools/yaml2obj/yaml2obj.cpp` | main関数とプリプロセス処理 |

**主要処理フロー**:
1. **113-118行目**: main関数、引数解析
2. **126-138行目**: 出力ファイルオープンと入力ファイル読み込み
3. **140-143行目**: preprocess関数呼び出し
4. **145-152行目**: -Eオプション時の分岐とconvertYAML呼び出し

#### Step 2: プリプロセス処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | yaml2obj.cpp | `llvm/tools/yaml2obj/yaml2obj.cpp` | preprocess関数（63-111行目） |

**主要処理フロー**:
- **65-77行目**: -Dオプションのマクロ定義解析とDefinesマップ構築
- **79-111行目**: [[マクロ]]パターンの検出と置換処理

### プログラム呼び出し階層図

```
main()
    │
    ├─ cl::ParseCommandLineOptions()
    │
    ├─ MemoryBuffer::getFileOrSTDIN()
    │
    ├─ preprocess()
    │      └─ [[マクロ]]パターンの展開
    │
    └─ convertYAML() [ObjectYAMLライブラリ]
           │
           ├─ ELF生成
           ├─ COFF生成
           ├─ MachO生成
           ├─ Wasm生成
           ├─ Archive生成
           └─ etc.
```

### データフロー図

```
[入力]                   [処理]                     [出力]

YAMLファイル
    │
    ▼
MemoryBuffer::getFileOrSTDIN()
    │
    ▼
preprocess() ─────────▶ [-Eオプション時] ─────────▶ 標準出力
    │
    ▼
yaml::Input
    │
    ▼
convertYAML()
    │
    ▼
バイナリ出力 ─────────────────────────────────────▶ 標準出力/ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| yaml2obj.cpp | `llvm/tools/yaml2obj/yaml2obj.cpp` | ソース | メインプログラム |
| CMakeLists.txt | `llvm/tools/yaml2obj/CMakeLists.txt` | ビルド | ビルド設定 |
