# 機能設計書 67-llvm-libtool-darwin

## 概要

本ドキュメントは、LLVM llvm-libtool-darwin ツールの機能設計について記載する。llvm-libtool-darwinは、Darwin（macOS/iOS）用の静的ライブラリ作成ツールである。

### 本機能の処理概要

llvm-libtool-darwinは、Apple社のlibtoolと互換性のある静的ライブラリ作成ツールである。複数のオブジェクトファイルやアーカイブを結合して静的ライブラリ（.aファイル）を作成する。複数アーキテクチャが含まれる場合は自動的にユニバーサルバイナリを生成する。

**業務上の目的・背景**：macOSおよびiOSの開発において、静的ライブラリの作成はビルドプロセスの重要な部分である。llvm-libtool-darwinは、Apple社のlibtoolと互換性のあるクロスプラットフォーム対応ツールとして、LLVMツールチェーンの一部として提供される。

**機能の利用シーン**：
- 複数のオブジェクトファイルからの静的ライブラリ作成
- 複数アーキテクチャ対応のユニバーサル静的ライブラリ作成
- 既存アーカイブの内容を新しいライブラリに統合
- ビットコードファイルを含むライブラリの作成

**主要な処理内容**：
1. -static: 静的ライブラリを作成（必須オプション）
2. -arch_only: 特定アーキテクチャのみを含むライブラリを作成
3. -filelist: ファイルリストからの入力
4. -l / -L: ライブラリ検索と追加
5. -D / -U: 決定的/非決定的出力モード

**関連システム・外部連携**：LLVM Object ライブラリ、ArchiveWriter

**権限による制御**：特になし（ファイルシステムへのアクセス権限のみ必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIツール | 主機能 | コマンドラインインターフェースによる操作 |

## 機能種別

ライブラリ作成 / アーカイブ操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 入力ファイル | string[] | Yes | Mach-Oオブジェクト、Archive、ユニバーサルバイナリ | ファイルが存在すること |
| -static | flag | Yes | 静的ライブラリを作成 | - |
| -o | string | Yes | 出力ファイルパス | - |
| -arch_only | arch | No | 指定アーキテクチャのみを含める | 有効なアーキテクチャ名 |
| -filelist | path[,dir] | No | 入力ファイルリスト | ファイルが存在すること |
| -l | lib | No | ライブラリを追加 | - |
| -L | dir | No | ライブラリ検索パス | - |
| -D | flag | No | 決定的出力（デフォルト） | - |
| -U | flag | No | 非決定的出力 | -Dと排他 |
| -no_warning_for_no_symbols | flag | No | シンボルなし警告を抑制 | - |
| -warnings_as_errors | flag | No | 警告をエラーとして扱う | - |
| -dependency_info | path | No | 依存関係情報を出力 | - |

### 入力データソース

- ファイルシステム上のMach-Oオブジェクトファイル
- 静的アーカイブ（.aファイル）
- ユニバーサルバイナリ
- ビットコードファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 静的ライブラリ | バイナリ | Darwin形式のアーカイブ |
| ユニバーサルバイナリ | バイナリ | 複数アーキテクチャ時のFatバイナリ |
| 依存関係情報 | バイナリ | -dependency_info指定時 |

### 出力先

- 指定された出力ファイル（-o）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ parseCommandLine()でConfigを構築

2. 入力ファイルの収集
   ├─ 直接指定されたファイル
   ├─ -filelistからのファイル
   └─ -lオプションで検索されたライブラリ

3. メンバーのビルド
   └─ MembersBuilder.build()
       ├─ アーカイブの展開（フラット化）
       ├─ ユニバーサルバイナリの展開
       ├─ Mach-Oオブジェクトの検証
       └─ ビットコードの処理

4. 重複チェック
   └─ checkForDuplicates()

5. ライブラリ作成
   ├─ 単一アーキテクチャ: writeArchive()
   └─ 複数アーキテクチャ: writeUniversalBinary()

6. 結果の出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{-staticオプション?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[入力ファイル収集]
    E --> F[MembersBuilder.build]
    F --> G{-arch_only指定?}
    G -->|Yes| H[指定アーキテクチャのみフィルタ]
    G -->|No| I[全アーキテクチャ処理]
    H --> J[重複チェック]
    I --> J
    J --> K{アーキテクチャ数?}
    K -->|1つ| L[writeArchive]
    K -->|複数| M[writeUniversalBinary]
    L --> N[終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-67-1 | 静的オプション必須 | -staticオプションは必須 | 常時 |
| BR-67-2 | 出力ファイル必須 | -oオプションは必須 | 常時 |
| BR-67-3 | アーカイブ展開 | 入力アーカイブのメンバーは展開される | アーカイブ入力時 |
| BR-67-4 | ユニバーサルバイナリ自動生成 | 複数アーキテクチャ時は自動的にファットバイナリ | 複数アーキテクチャ時 |
| BR-67-5 | 決定的出力デフォルト | デフォルトで決定的出力（-D）が有効 | -U未指定時 |
| BR-67-6 | 重複ファイル警告 | 同名ファイルが複数存在する場合は警告 | 重複検出時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（データベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | オプション不足 | -staticオプション未指定 | エラーメッセージを表示し終了 |
| - | 出力先未指定 | -oオプション未指定 | エラーメッセージを表示し終了 |
| - | 入力ファイルなし | 入力ファイルが指定されていない | エラーメッセージを表示し終了 |
| - | アーキテクチャ不正 | 無効なアーキテクチャ名を指定 | 有効なアーキテクチャ一覧を表示し終了 |
| - | DとU同時指定 | -Dと-Uを同時に指定 | エラーメッセージを表示し終了 |
| - | シンボルなし警告 | オブジェクトにシンボルがない | 警告（-no_warning_for_no_symbolsで抑制可） |

### リトライ仕様

なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に定義なし

## セキュリティ考慮事項

- 入力ファイルへの読み取りアクセス権限が必要
- 出力ファイルへの書き込みアクセス権限が必要

## 備考

- Apple libtoolの-staticモードと互換性を持つ
- 複数アーキテクチャの場合、K_DARWIN形式でアーカイブを作成
- ビットコードファイルもサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造とオプション定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-libtool-darwin.cpp | `llvm/tools/llvm-libtool-darwin/llvm-libtool-darwin.cpp` | Config構造体（101-105行目） |
| 1-2 | llvm-libtool-darwin.cpp | `llvm/tools/llvm-libtool-darwin/llvm-libtool-darwin.cpp` | グローバル変数（75-97行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-libtool-darwin.cpp | `llvm/tools/llvm-libtool-darwin/llvm-libtool-darwin.cpp` | llvm_libtool_darwin_main関数（729-756行目） |

**主要処理フロー**:
1. **730-734行目**: parseCommandLine()で引数解析とConfig構築
2. **739-741行目**: ターゲット初期化
3. **745-753行目**: Operation::Staticの場合createStaticLibrary()呼び出し

#### Step 3: ライブラリ作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-libtool-darwin.cpp | `llvm/tools/llvm-libtool-darwin/llvm-libtool-darwin.cpp` | createStaticLibrary関数（581-628行目） |
| 3-2 | llvm-libtool-darwin.cpp | `llvm/tools/llvm-libtool-darwin/llvm-libtool-darwin.cpp` | MembersBuilderクラス（261-531行目） |

**主要処理フロー**:
- **582-585行目**: MembersBuilder.build()でメンバー収集
- **589-593行目**: checkForDuplicates()で重複チェック
- **595-599行目**: 単一アーキテクチャ時はwriteArchive()
- **601-627行目**: 複数アーキテクチャ時はユニバーサルバイナリ生成

### プログラム呼び出し階層図

```
llvm_libtool_darwin_main()
    │
    ├─ parseCommandLine()
    │      ├─ parseRawArgs()
    │      ├─ processCommandLineLibraries()
    │      └─ processFileList()
    │
    └─ createStaticLibrary()
           │
           ├─ MembersBuilder.build()
           │      └─ AddMember()
           │             ├─ addArchiveMembers()
           │             ├─ addUniversalMembers()
           │             ├─ verifyAndAddMachOObject()
           │             └─ verifyAndAddIRObject()
           │
           ├─ checkForDuplicates()
           │
           ├─ [単一アーキテクチャ]
           │      └─ writeArchive()
           │
           └─ [複数アーキテクチャ]
                  ├─ writeArchiveToBuffer()
                  ├─ buildSlices()
                  └─ writeUniversalBinary()
```

### データフロー図

```
[入力]                   [処理]                     [出力]

オブジェクトファイル1 ──┐
                      ├──▶ MembersBuilder.build()
オブジェクトファイル2 ──┤         │
                      │         ▼
アーカイブファイル ────┘   MembersPerArchitecture
                              │
                              ▼
                    ┌─────────┴─────────┐
                    │                   │
              [単一アーキ]          [複数アーキ]
                    │                   │
                    ▼                   ▼
              writeArchive()    writeUniversalBinary()
                    │                   │
                    └─────────┬─────────┘
                              │
                              ▼
                         出力ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-libtool-darwin.cpp | `llvm/tools/llvm-libtool-darwin/llvm-libtool-darwin.cpp` | ソース | メインプログラム |
| DependencyInfo.h | `llvm/tools/llvm-libtool-darwin/DependencyInfo.h` | ヘッダ | 依存関係情報クラス |
| DependencyInfo.cpp | `llvm/tools/llvm-libtool-darwin/DependencyInfo.cpp` | ソース | 依存関係情報実装 |
| Opts.td | `llvm/tools/llvm-libtool-darwin/Opts.td` | 定義 | コマンドラインオプション定義 |
| CMakeLists.txt | `llvm/tools/llvm-libtool-darwin/CMakeLists.txt` | ビルド | ビルド設定 |
