# 機能設計書 7-LLD

## 概要

本ドキュメントは、LLD（LLVMリンカ）の機能設計を記述する。LLDはLLVMプロジェクトのリンカであり、ELF、COFF、Mach-O、WebAssemblyの各形式をサポートするクロスプラットフォームリンカである。

### 本機能の処理概要

LLDは、複数のオブジェクトファイルとライブラリを結合し、実行可能ファイルまたは共有ライブラリを生成する。プラットフォームごとに専用のリンカドライバ（ld.lld、lld-link、ld64、wasm-ld）を提供し、高速なリンク処理を実現する。

**業務上の目的・背景**：GNU ldやMicrosoft linkに代わる高速で互換性のあるリンカを提供する。大規模プロジェクトのビルド時間短縮に貢献し、LLVMツールチェーン全体の一貫性を向上させる。

**機能の利用シーン**：
- オブジェクトファイルから実行ファイルの生成
- 共有ライブラリ（.so/.dll/.dylib）の生成
- 静的ライブラリのリンク
- クロスコンパイル環境でのリンク
- インクリメンタルリンク

**主要な処理内容**：
1. オブジェクトファイルの読み込みと解析
2. シンボル解決
3. セクション配置とアドレス割り当て
4. リロケーション処理
5. 出力ファイル生成

**関連システム・外部連携**：
- LLVM LLDライブラリ
- libc/libstdc++等のシステムライブラリ
- デバッグ情報（DWARF）処理

**権限による制御**：特になし（コマンドラインツールとして実行）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | LLDはCLIツールであり、GUI画面は持たない |

## 機能種別

リンカ / オブジェクトファイル処理 / 実行ファイル生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| オブジェクトファイル | string | Yes | 入力オブジェクトファイル | .o/.obj |
| -o | string | No | 出力ファイル名 | 有効なパス |
| -L | string | No | ライブラリ検索パス | 有効なディレクトリ |
| -l | string | No | ライブラリ名 | 有効な名前 |
| -shared | flag | No | 共有ライブラリ生成 | true/false |
| -static | flag | No | 静的リンク | true/false |
| -pie | flag | No | PIE生成 | true/false |
| -m | string | No | エミュレーションモード | elf_x86_64等 |
| --sysroot | string | No | システムルート | 有効なパス |
| -flavor | string | No | リンカフレーバー指定 | gnu/darwin/wasm/link |

### 入力データソース

- オブジェクトファイル（.o, .obj）
- 静的ライブラリ（.a, .lib）
- 共有ライブラリ（.so, .dll, .dylib）
- リンカスクリプト
- アーカイブファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行ファイル | - | ELF/PE/Mach-O実行ファイル |
| 共有ライブラリ | .so/.dll/.dylib | 動的リンクライブラリ |
| マップファイル | .map | シンボルマップ |
| 診断メッセージ | text | エラー/警告 |

### 出力先

- ファイル（-oオプションで指定、デフォルト: a.out）
- 標準エラー（診断メッセージ）

## 処理フロー

### 処理シーケンス

```
1. フレーバー判定
   └─ プログラム名または-flavorオプションからリンカ種別決定
2. ドライバ選択
   └─ ELF/COFF/Mach-O/WebAssemblyドライバ選択
3. オブジェクトファイル読み込み
   └─ 全入力ファイルの解析
4. シンボル解決
   └─ 未定義シンボルと定義の照合
5. セクション配置
   └─ アドレス空間へのレイアウト
6. リロケーション
   └─ アドレス参照の解決
7. 出力生成
   └─ 最終実行ファイル出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[lld_main]
    B --> C{テストモード?}
    C -->|Yes| D[CrashRecoveryContext有効化]
    C -->|No| E[unsafeLldMain]
    D --> F[lldMain ループ実行]
    E --> G[LLD_ALL_DRIVERS]
    F --> G
    G --> H{フレーバー判定}
    H -->|ld.lld| I[ELFリンカ]
    H -->|lld-link| J[COFFリンカ]
    H -->|ld64| K[Mach-Oリンカ]
    H -->|wasm-ld| L[WebAssemblyリンカ]
    I --> M[リンク処理]
    J --> M
    K --> M
    L --> M
    M --> N[出力生成]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | フレーバー自動判定 | プログラム名から対象フォーマット判定 | lld直接実行時 |
| BR-002 | ld.lld | ELFリンカとして動作 | Unixシステム |
| BR-003 | lld-link | COFFリンカとして動作 | Windowsシステム |
| BR-004 | ld64 | Mach-Oリンカとして動作 | macOSシステム |
| BR-005 | wasm-ld | WebAssemblyリンカとして動作 | WebAssemblyターゲット |

### 計算ロジック

- シンボル解決：強シンボル/弱シンボルの優先順位
- アドレス計算：セクションアライメントと配置
- リロケーション：相対/絶対アドレス計算

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | LLDはデータベースを使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------
| 1 | 未定義シンボル | シンボルが見つからない | ライブラリを追加 |
| 1 | 多重定義 | 同一シンボルの重複定義 | 定義を整理 |
| 1 | ファイルエラー | ファイルが存在しない | パスを確認 |
| 1 | 形式エラー | 不正なオブジェクト形式 | ファイルを確認 |

### リトライ仕様

リトライは行わない。エラー発生時は終了コードで通知。

## トランザクション仕様

LLDはデータベーストランザクションを使用しない。

## パフォーマンス要件

- 大規模プロジェクトの高速リンク
- 並列処理によるスループット向上
- メモリ効率の最適化

## セキュリティ考慮事項

- PIE（Position Independent Executable）サポート
- RELRO（Relocation Read-Only）サポート
- スタック保護機能との連携

## 備考

LLDはGNU ldとの高い互換性を持ちながら、大幅な速度向上を実現している。複数のプラットフォーム向けリンカを単一バイナリに統合している点が特徴である。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lld.cpp | `lld/tools/lld/lld.cpp` | メインエントリーポイント |

**主要処理フロー**:
1. **75-115行目**: lld_main関数 - メインエントリー
2. **76行目**: ANSIエスケープコード有効化
3. **78-82行目**: FORCE_LLD_DIAGNOSTICS_CRASH環境変数チェック
4. **88-93行目**: テストモードでない場合はunsafeLldMain呼び出し
5. **96行目**: CrashRecoveryContext有効化（テストモード）
6. **98-113行目**: テスト用の複数回実行ループ

#### Step 2: ドライバ登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lld.cpp | `lld/tools/lld/lld.cpp` | ドライバ登録マクロ |

**主要処理フロー**:
- **69-73行目**: LLD_HAS_DRIVERマクロによるドライバ登録
  - COFF（Windows PE形式）
  - ELF（Unix形式）
  - MinGW（MinGW形式）
  - Mach-O（macOS形式）
  - WebAssembly（WASM形式）

#### Step 3: テストモード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lld.cpp | `lld/tools/lld/lld.cpp` | テスト用機能 |

**主要処理フロー**:
- **63-67行目**: inTestVerbosity関数 - LLD_IN_TEST環境変数チェック
- **103-105行目**: canRunAgainチェックと早期終了

### プログラム呼び出し階層図

```
lld_main (lld.cpp:75)
    │
    ├─ Process::UseANSIEscapeCodes
    │
    ├─ [非テストモード] unsafeLldMain (lld.cpp:89-92)
    │      │
    │      └─ LLD_ALL_DRIVERS
    │             ├─ coff::link (COFF/Windows)
    │             ├─ elf::link (ELF/Unix)
    │             ├─ mingw::link (MinGW)
    │             ├─ macho::link (Mach-O/macOS)
    │             └─ wasm::link (WebAssembly)
    │
    └─ [テストモード] lldMain (lld.cpp:103)
           │
           ├─ CrashRecoveryContext::Enable
           │
           └─ lldMain ループ
                  └─ LLD_ALL_DRIVERS（上記と同様）
```

### データフロー図

```
入力ファイル
    │
    ├─ オブジェクトファイル (.o/.obj)
    ├─ 静的ライブラリ (.a/.lib)
    └─ 共有ライブラリ (.so/.dll/.dylib)
        │
        v
+------------------+
|    lld_main      | ← コマンドライン引数
|   (lld.cpp)      |
+------------------+
        │
        v
+------------------+
|  フレーバー判定   |
| (プログラム名)    |
+------------------+
        │
        ├── ld.lld ──> ELF::link
        ├── lld-link ──> COFF::link
        ├── ld64 ──> MachO::link
        └── wasm-ld ──> WASM::link
              │
              v
+------------------+
|   リンク処理      |
| - シンボル解決    |
| - セクション配置  |
| - リロケーション  |
+------------------+
        │
        v
+------------------+
|     出力         |
| (実行ファイル/   |
|  共有ライブラリ)  |
+------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lld.cpp | `lld/tools/lld/lld.cpp` | ソース | メインエントリー |
| Driver.h | `lld/Common/Driver.h` | ヘッダ | ドライバ共通定義 |
| ErrorHandler.h | `lld/Common/ErrorHandler.h` | ヘッダ | エラー処理 |
| Memory.h | `lld/Common/Memory.h` | ヘッダ | メモリ管理 |
| Driver.cpp | `lld/ELF/Driver.cpp` | ソース | ELFドライバ |
| Driver.cpp | `lld/COFF/Driver.cpp` | ソース | COFFドライバ |
| Driver.cpp | `lld/MachO/Driver.cpp` | ソース | Mach-Oドライバ |
| Driver.cpp | `lld/wasm/Driver.cpp` | ソース | WebAssemblyドライバ |
