# 機能設計書 71-Clang Static Analyzer

## 概要

本ドキュメントは、LLVM/Clangプロジェクトにおける静的解析ツール「Clang Static Analyzer」の機能設計書である。scan-buildコマンドを中心に、C/C++/Objective-Cコードの潜在的なバグを検出する静的解析機能について記述する。

### 本機能の処理概要

Clang Static Analyzerは、ソースコードをコンパイルすることなく、プログラムの実行パスをシミュレートして潜在的なバグを検出する静的解析ツールである。

**業務上の目的・背景**：ソフトウェア開発において、実行時エラーやセキュリティ脆弱性を早期に発見することは品質向上とコスト削減に直結する。Clang Static Analyzerは、メモリリーク、NULL参照、未初期化変数、バッファオーバーフローなどの問題をコンパイル前に検出し、開発者にフィードバックを提供する。

**機能の利用シーン**：
- CI/CDパイプラインでの自動コード品質チェック
- コードレビュー前の事前検証
- セキュリティ脆弱性の早期発見
- レガシーコードの品質改善

**主要な処理内容**：
1. ビルドコマンドのインターセプト: scan-buildがコンパイラ呼び出しをラップし、各ソースファイルに対して静的解析を実行
2. シンボリック実行: プログラムの実行パスを抽象的にシミュレートし、可能な全ての実行経路を探索
3. パス感応解析: 条件分岐を考慮した精密な解析により、誤検知を削減
4. 診断レポート生成: 検出された問題をHTML形式のレポートとして出力

**関連システム・外部連携**：Clangコンパイラフロントエンド、CMake/Make等のビルドシステム

**権限による制御**：特になし（ファイルシステムへの読み書き権限が必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | HTMLレポートビュー | 結果表示画面 | 解析結果をブラウザで表示、バグの詳細と発生パスを可視化 |

## 機能種別

静的解析 / バグ検出 / レポート生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -o | string | No | HTML出力ディレクトリ | 有効なディレクトリパス |
| --use-analyzer | string | No | 使用するアナライザのパス | 実行可能ファイル |
| --use-cc | string | No | Cコンパイラの指定 | 実行可能ファイル |
| --use-c++ | string | No | C++コンパイラの指定 | 実行可能ファイル |
| -enable-checker | string | No | 有効にするチェッカー | 有効なチェッカー名 |
| -disable-checker | string | No | 無効にするチェッカー | 有効なチェッカー名 |
| --status-bugs | flag | No | バグ発見時に非ゼロ終了 | - |
| -v | flag | No | 詳細出力 | - |
| build_command | string[] | Yes | ビルドコマンド | 有効なコマンド |

### 入力データソース

- ソースコード（C/C++/Objective-C）
- コンパイルデータベース（compile_commands.json、オプション）
- ビルドコマンド（make、cmake等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTMLレポート | HTML | バグの詳細、発生パス、ソースコード参照を含むレポート |
| index.html | HTML | 全バグの一覧ページ |
| プリプロセス済みファイル | file | 解析失敗時のデバッグ用ファイル（failures/ディレクトリ） |

### 出力先

- 指定されたディレクトリ（-oオプション）または一時ディレクトリ
- 標準出力（診断メッセージ）
- 標準エラー出力（エラーメッセージ）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ オプション、チェッカー設定、ビルドコマンドの分離

2. 環境変数の設定
   └─ CCC_ANALYZER_HTML、CCC_ANALYZER_ANALYSIS等の設定

3. ビルドコマンドの実行
   └─ CC/CXX環境変数をccc-analyzerに置換してビルド実行

4. 各ソースファイルの解析
   └─ Clang Static Analyzerによるシンボリック実行

5. 診断結果の収集
   └─ plistファイルからバグ情報を収集

6. HTMLレポートの生成
   └─ バグの詳細、パス情報、ソースコード参照を含むHTML生成

7. 結果の表示
   └─ バグ数のサマリー表示、オプションでブラウザ起動
```

### フローチャート

```mermaid
flowchart TD
    A[開始: scan-build] --> B[コマンドライン解析]
    B --> C[環境変数設定]
    C --> D[ccc-analyzerをCC/CXXに設定]
    D --> E[ビルドコマンド実行]
    E --> F{各ソースファイル}
    F --> G[プリプロセス]
    G --> H[AST構築]
    H --> I[シンボリック実行]
    I --> J{バグ検出?}
    J -->|Yes| K[診断情報記録]
    J -->|No| L[次のファイル]
    K --> L
    L --> F
    F -->|完了| M[HTMLレポート生成]
    M --> N[結果サマリー表示]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-01 | デフォルトチェッカー | core、deadcode、securityチェッカーがデフォルトで有効 | 常時 |
| BR-71-02 | alphaチェッカー | alphaプレフィックスのチェッカーは明示的に有効化が必要 | alpha系チェッカー使用時 |
| BR-71-03 | 出力ディレクトリ | 未指定時は/tmp配下に日時付きディレクトリを作成 | -o未指定時 |
| BR-71-04 | 終了コード | --status-bugs指定時、バグ発見で非ゼロ終了 | オプション指定時 |

### 計算ロジック

パス感応解析では、条件分岐ごとに状態を分岐させ、各パスでの変数状態を追跡する。MaxLoop設定により、ループの展開回数を制限してパス爆発を防止する。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ビルドエラー | ソースコードのコンパイルエラー | --ignore-errorsで継続可能 |
| - | アナライザクラッシュ | 解析中の内部エラー | failures/にプリプロセス済みファイル保存 |
| - | パス制限超過 | 解析パスが上限に達した | MaxLoop設定の調整 |

### リトライ仕様

クラッシュ発生時は該当ファイルをスキップして継続。--report-failures指定でクラッシュ情報を保存。

## トランザクション仕様

該当なし（ファイルベースの処理）

## パフォーマンス要件

- 大規模プロジェクトでは並列実行を推奨
- MaxLoop設定でパス爆発を制御
- 解析対象ファイルの絞り込みで実行時間を短縮可能

## セキュリティ考慮事項

- 解析結果には潜在的なセキュリティ脆弱性が含まれる可能性があるため、レポートのアクセス管理が必要
- HTMLレポートにはソースコードの一部が含まれる

## 備考

- scan-buildはPerlスクリプトとして実装されている
- clang-tidyと併用することで、より広範なコード品質チェックが可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

scan-buildスクリプトがビルドプロセス全体をラップする仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scan-build | `clang/tools/scan-build/bin/scan-build` | メインのPerlスクリプト、コマンドライン解析とビルド実行の統括 |

**主要処理フロー**:
1. **46-76行目**: Optionsハッシュの定義、全オプションのデフォルト値設定
2. **151-245行目**: GetHTMLRunDir関数、出力ディレクトリの作成
3. **247-267行目**: SetHtmlEnv関数、環境変数CCC_ANALYZER_HTMLの設定

#### Step 2: コンパイララッパーを理解する

ccc-analyzerがコンパイラ呼び出しをインターセプトする仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ccc-analyzer | `clang/tools/scan-build/libexec/ccc-analyzer` | コンパイラ呼び出しをインターセプトし、解析を実行するPerlスクリプト |

**読解のコツ**: ccc-analyzerは環境変数を通じてscan-buildから設定を受け取り、各ソースファイルに対してClang Static Analyzerを呼び出す。

#### Step 3: 静的解析エンジンを理解する

Clangの静的解析エンジンの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AnalysisConsumer.cpp | `clang/lib/StaticAnalyzer/Frontend/AnalysisConsumer.cpp` | 解析の実行を統括するクラス |
| 3-2 | PathDiagnostic.h | `clang/include/clang/Analysis/PathDiagnostic.h` | バグレポートのデータ構造 |

### プログラム呼び出し階層図

```
scan-build (Perl)
    │
    ├─ 環境変数設定
    │      └─ CCC_ANALYZER_HTML, CCC_ANALYZER_ANALYSIS等
    │
    ├─ CC/CXX環境変数をccc-analyzerに設定
    │
    └─ ビルドコマンド実行
           │
           └─ ccc-analyzer (Perl)
                  │
                  ├─ コンパイラ引数解析
                  │
                  └─ clang --analyze
                         │
                         ├─ Frontend/AnalysisAction
                         │      └─ AnalysisConsumer
                         │             └─ ExprEngine (シンボリック実行)
                         │
                         └─ 診断出力 (HTML/plist)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ソースファイル ─────▶ プリプロセス ─────▶ AST構築
     │                                        │
     │                                        ▼
コンパイル引数 ─────▶ ccc-analyzer ─────▶ ExprEngine
                                              │
                                              ▼
                                       パス探索・状態追跡
                                              │
                                              ▼
                              ┌───────────────┴───────────────┐
                              │                               │
                              ▼                               ▼
                        バグ診断情報                     正常完了
                              │
                              ▼
                        HTMLレポート ────────▶ index.html
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scan-build | `clang/tools/scan-build/bin/scan-build` | スクリプト | メインエントリーポイント、ビルドラッパー |
| ccc-analyzer | `clang/tools/scan-build/libexec/ccc-analyzer` | スクリプト | Cコンパイララッパー |
| c++-analyzer | `clang/tools/scan-build/libexec/c++-analyzer` | スクリプト | C++コンパイララッパー |
| sorttable.js | `clang/tools/scan-build/share/scan-build/sorttable.js` | JavaScript | HTMLレポートのテーブルソート機能 |
| scanview.css | `clang/tools/scan-build/share/scan-build/scanview.css` | CSS | HTMLレポートのスタイル |
| AnalysisConsumer.cpp | `clang/lib/StaticAnalyzer/Frontend/AnalysisConsumer.cpp` | ソース | 解析実行の統括 |
| ExprEngine.cpp | `clang/lib/StaticAnalyzer/Core/ExprEngine.cpp` | ソース | シンボリック実行エンジン |
