# 機能設計書 72-clang-tidy

## 概要

本ドキュメントは、LLVM/Clangプロジェクトにおける静的解析・リンティングツール「clang-tidy」の機能設計書である。C++コードの品質チェック、モダナイゼーション支援、コーディング規約の自動検証を行う機能について記述する。

### 本機能の処理概要

clang-tidyは、Clang ASTマッチャーを活用したプラグイン可能な静的解析フレームワークである。数百種類のチェッカーを備え、バグの検出からコードスタイルの統一、C++11/14/17/20への移行支援まで幅広いコード品質改善を支援する。

**業務上の目的・背景**：モダンC++開発において、コーディング規約の遵守、潜在的バグの検出、レガシーコードのモダナイゼーションは品質向上の重要な要素である。clang-tidyは、これらを自動化し、一貫したコード品質を維持するための基盤を提供する。

**機能の利用シーン**：
- 継続的インテグレーション（CI）でのコード品質ゲート
- IDEでのリアルタイムコード解析
- コードレビュー前の自動チェック
- レガシーコードのC++11以降への移行支援
- プロジェクト固有のコーディング規約の強制

**主要な処理内容**：
1. ソースファイルのパース: Clang Toolingを使用してAST（抽象構文木）を構築
2. チェッカーの適用: 有効なチェッカーがASTマッチャーを使用してパターンマッチング
3. 診断の生成: 問題箇所の特定と修正提案の生成
4. 自動修正の適用: --fix オプションで修正を自動適用

**関連システム・外部連携**：Clang Static Analyzer（clang-analyzer-*チェッカー経由）、clang-format（自動修正後の整形）

**権限による制御**：特になし（ファイルシステムへの読み書き権限が必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 端末出力 | 結果表示画面 | 診断メッセージと修正提案の表示 |

## 機能種別

静的解析 / Linting / コード変換 / 自動修正

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -checks | string | No | 有効/無効にするチェッカーのパターン | glob形式 |
| -config | string | No | 設定のYAML形式指定 | 有効なYAML |
| -config-file | string | No | 設定ファイルパス | 有効なファイルパス |
| -p | string | No | コンパイルデータベースのパス | 有効なディレクトリ |
| --fix | flag | No | 自動修正の適用 | - |
| --fix-errors | flag | No | エラーレベルの問題も修正 | - |
| --fix-notes | flag | No | ノートの修正も適用 | - |
| -format-style | string | No | 修正時のフォーマットスタイル | clang-format形式 |
| -header-filter | regex | No | ヘッダーファイルのフィルタ | 正規表現 |
| -line-filter | json | No | 行範囲のフィルタ | JSON配列 |
| --list-checks | flag | No | 有効なチェッカー一覧表示 | - |
| -warnings-as-errors | string | No | 警告をエラー扱いにするパターン | glob形式 |
| source_files | string[] | Yes | 解析対象ファイル | 有効なC/C++ファイル |

### 入力データソース

- C/C++ソースファイル
- コンパイルデータベース（compile_commands.json）
- 設定ファイル（.clang-tidy）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 診断メッセージ | text | 問題の位置、種類、説明、修正提案 |
| YAML診断出力 | YAML | --export-fixes オプションでの構造化出力 |
| 修正済みソース | file | --fix オプション使用時の修正されたファイル |

### 出力先

- 標準出力（診断メッセージ）
- 標準エラー出力（エラーメッセージ）
- ファイル（--fix使用時の修正、--export-fixes使用時のYAML）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ チェッカー設定、ファイルパス、オプションの取得

2. 設定ファイルの読み込み
   └─ .clang-tidyファイルの検索と適用

3. コンパイルデータベースの読み込み
   └─ compile_commands.jsonからコンパイルフラグを取得

4. チェッカーのインスタンス化
   └─ 有効なチェッカーをClangTidyCheckFactoriesから生成

5. 各ソースファイルの処理
   └─ AST構築、マッチャー登録、解析実行

6. 診断の収集と表示
   └─ ClangTidyDiagnosticConsumerによる出力

7. 自動修正の適用（オプション）
   └─ Replacementsの適用とファイル書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始: clang-tidy] --> B[コマンドライン解析]
    B --> C[.clang-tidy設定読み込み]
    C --> D[compile_commands.json読み込み]
    D --> E[チェッカーインスタンス化]
    E --> F{各ソースファイル}
    F --> G[AST構築]
    G --> H[ASTマッチャー実行]
    H --> I[診断生成]
    I --> J{--fix指定?}
    J -->|Yes| K[修正適用]
    J -->|No| L[次のファイル]
    K --> L
    L --> F
    F -->|完了| M[結果サマリー表示]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-72-01 | デフォルトチェッカー | clang-analyzer-*とclang-diagnostic-*がデフォルト有効 | 常時 |
| BR-72-02 | 設定ファイル検索 | ソースファイルのディレクトリから親へ.clang-tidyを検索 | 常時 |
| BR-72-03 | NOLINT抑制 | NOLINTコメントで特定行の警告を抑制可能 | コメント存在時 |
| BR-72-04 | ヘッダーフィルタ | デフォルトでヘッダーファイルの診断は抑制 | header-filter未指定時 |

### 計算ロジック

チェッカーの有効/無効はグロブパターンで制御。`-*`で全無効化、`modernize-*`でmodernizeカテゴリ全有効化など、複数パターンの組み合わせが可能。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コンパイルエラー | ソースコードの構文エラー | ソースコードの修正 |
| - | 設定エラー | .clang-tidy の構文エラー | 設定ファイルの修正 |
| - | データベースエラー | compile_commands.json が見つからない | -p オプションで指定 |

### リトライ仕様

コンパイルエラー発生時は該当ファイルの解析をスキップして継続。

## トランザクション仕様

該当なし（ファイルベースの処理）。--fix使用時は修正をメモリに蓄積し、全チェック完了後にまとめて適用。

## パフォーマンス要件

- 並列実行オプション（-j）で複数ファイルの同時解析が可能
- プリコンパイル済みヘッダー（PCH）の活用で解析時間を短縮

## セキュリティ考慮事項

- --fix オプションはソースファイルを直接変更するため、バージョン管理下での使用を推奨
- 信頼できないソースコードの解析時は、コードの実行を伴わないことを認識

## 備考

- チェッカーはモジュール形式で整理（modernize、readability、performance、bugprone等）
- カスタムチェッカーの追加が可能（Clang Toolingを使用）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

clang-tidyの設定と診断情報のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClangTidyOptions.h | `clang-tools-extra/clang-tidy/ClangTidyOptions.h` | オプション設定の構造体定義 |
| 1-2 | ClangTidyDiagnosticConsumer.h | `clang-tools-extra/clang-tidy/ClangTidyDiagnosticConsumer.h` | 診断情報の管理 |

**読解のコツ**: ClangTidyOptionsはYAML形式でシリアライズ可能な設定を保持し、階層的にマージされる。

#### Step 2: エントリーポイントを理解する

メイン処理の流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClangTidy.cpp | `clang-tools-extra/clang-tidy/ClangTidy.cpp` | 解析実行の中核処理 |
| 2-2 | ClangTidy.h | `clang-tools-extra/clang-tidy/ClangTidy.h` | 公開インターフェース |

**主要処理フロー**:
1. **348-362行目**: ClangTidyASTConsumerFactoryのコンストラクタ、チェッカーファクトリの初期化
2. **412-488行目**: createASTConsumer関数、各チェッカーのマッチャー登録
3. **559-658行目**: runClangTidy関数、ClangToolの実行とエラー処理
4. **660-685行目**: handleErrors関数、診断結果の表示と修正適用

#### Step 3: チェッカーの仕組みを理解する

個別チェッカーの実装パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ClangTidyCheck.h | `clang-tools-extra/clang-tidy/ClangTidyCheck.h` | チェッカー基底クラス |
| 3-2 | MiscTidyModule.cpp | `clang-tools-extra/clang-tidy/misc/MiscTidyModule.cpp` | チェッカーモジュールの登録例 |

**読解のコツ**: 各チェッカーはClangTidyCheckを継承し、registerMatchers()でパターンを登録、check()でマッチ時の処理を実装する。

### プログラム呼び出し階層図

```
main (ClangTidyMain.cpp)
    │
    ├─ ClangTidyOptions::getDefaults()
    │      └─ デフォルト設定の取得
    │
    ├─ getCheckOptions()
    │      └─ チェッカー固有オプションの取得
    │
    └─ runClangTidy()
           │
           ├─ ClangTidyASTConsumerFactory
           │      ├─ ClangTidyCheckFactories
           │      │      └─ createChecks()
           │      │             └─ 各チェッカーのインスタンス化
           │      │
           │      └─ createASTConsumer()
           │             ├─ MatchFinder
           │             └─ 各チェッカーのregisterMatchers()
           │
           └─ ClangTool::run()
                  │
                  └─ 各ファイルの処理
                         │
                         ├─ AST構築
                         ├─ マッチャー実行
                         └─ check()コールバック
```

### データフロー図

```
[入力]                     [処理]                         [出力]

ソースファイル ──────▶ Clang Tooling ──────▶ AST構築
     │                                          │
     │                                          ▼
.clang-tidy ──────────▶ オプション解析 ──────▶ チェッカー設定
     │                                          │
     │                                          ▼
compile_commands.json ─▶ コンパイルフラグ ──▶ ASTマッチャー実行
                                                │
                                                ▼
                                         診断情報生成
                                                │
                        ┌───────────────────────┴───────────────────────┐
                        │                                               │
                        ▼                                               ▼
                  標準出力表示                                    --export-fixes
                        │                                               │
                        ▼                                               ▼
                  --fix適用 ──────▶ 修正済みファイル              YAML出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClangTidy.cpp | `clang-tools-extra/clang-tidy/ClangTidy.cpp` | ソース | メイン処理実装 |
| ClangTidy.h | `clang-tools-extra/clang-tidy/ClangTidy.h` | ヘッダ | 公開インターフェース |
| ClangTidyCheck.h | `clang-tools-extra/clang-tidy/ClangTidyCheck.h` | ヘッダ | チェッカー基底クラス |
| ClangTidyOptions.h | `clang-tools-extra/clang-tidy/ClangTidyOptions.h` | ヘッダ | オプション構造体 |
| ClangTidyDiagnosticConsumer.h | `clang-tools-extra/clang-tidy/ClangTidyDiagnosticConsumer.h` | ヘッダ | 診断出力管理 |
| ClangTidyModule.h | `clang-tools-extra/clang-tidy/ClangTidyModule.h` | ヘッダ | モジュール基底クラス |
| ClangTidyModuleRegistry.h | `clang-tools-extra/clang-tidy/ClangTidyModuleRegistry.h` | ヘッダ | モジュール登録機構 |
| NoLintDirectiveHandler.cpp | `clang-tools-extra/clang-tidy/NoLintDirectiveHandler.cpp` | ソース | NOLINT処理 |
| GlobList.cpp | `clang-tools-extra/clang-tidy/GlobList.cpp` | ソース | グロブパターン処理 |
