# 機能設計書 74-clang-check

## 概要

本ドキュメントは、LLVM/Clangプロジェクトにおける構文チェック・AST出力ツール「clang-check」の機能設計書である。C/C++ソースコードの構文検証とAST（抽象構文木）のダンプ機能を提供する。

### 本機能の処理概要

clang-checkは、Clang Toolingインフラストラクチャを使用して、C/C++ソースコードの構文チェックを行い、オプションでASTのダンプや静的解析を実行するツールである。

**業務上の目的・背景**：コンパイル前のソースコード検証、ASTの構造理解、Clangの内部動作の調査に利用される。開発者がClangの解析結果を直接確認でき、ツール開発やデバッグに有用である。

**機能の利用シーン**：
- ソースコードの構文チェック（コンパイルエラーの事前検出）
- ASTの構造確認（ツール開発時の調査）
- 静的解析の実行
- Syntax Treeのダンプ（Clang内部構造の理解）
- FixItヒントの適用

**主要な処理内容**：
1. コンパイルデータベースの読み込み
2. ソースファイルの解析
3. AST構築と出力（オプション）
4. 静的解析実行（オプション）
5. FixIt適用（オプション）

**関連システム・外部連携**：compile_commands.json、Clang Static Analyzer

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 端末出力 | 結果表示画面 | AST、診断メッセージ、Syntax Treeの表示 |

## 機能種別

構文チェック / AST出力 / 静的解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -p | string | No | コンパイルデータベースのパス | 有効なディレクトリ |
| --ast-dump | flag | No | ASTをダンプ | - |
| --ast-list | flag | No | AST宣言をリスト表示 | - |
| --ast-print | flag | No | ASTをソース形式で出力 | - |
| --ast-dump-filter | string | No | ダンプ対象をフィルタ | 文字列 |
| --analyze | flag | No | 静的解析を実行 | - |
| --analyzer-output-path | string | No | 解析結果の出力パス | 有効なパス |
| --fixit | flag | No | FixItを適用 | - |
| --fix-what-you-can | flag | No | 適用可能なFixItのみ適用 | - |
| --syntax-tree-dump | flag | No | Syntax Treeをダンプ | - |
| --tokens-dump | flag | No | トークンをダンプ | - |
| source_files | string[] | Yes | 解析対象ファイル | 有効なC/C++ファイル |

### 入力データソース

- C/C++ソースファイル
- コンパイルデータベース（compile_commands.json）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 診断メッセージ | text | コンパイルエラー・警告 |
| ASTダンプ | text | 抽象構文木のテキスト表現 |
| Syntax Tree | text | 構文木のテキスト表現 |
| 修正済みソース | file | --fixit使用時の修正されたファイル |

### 出力先

- 標準出力
- ファイル（--fixit使用時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ オプション、ファイルパスの取得

2. コンパイルデータベースの読み込み
   └─ compile_commands.jsonからコンパイルフラグを取得

3. ClangToolの設定
   └─ FrontendActionの選択（モードに応じて）

4. 各ソースファイルの処理
   └─ 解析実行、出力生成

5. 結果の表示/書き込み
   └─ 診断メッセージ、AST、修正の出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始: clang-check] --> B[コマンドライン解析]
    B --> C{モード判定}
    C -->|--analyze| D[AnalysisAction]
    C -->|--fixit| E[ClangCheckFixItAction]
    C -->|--syntax-tree-dump| F[DumpSyntaxTree]
    C -->|その他| G[ClangCheckActionFactory]
    D --> H[ClangTool::run]
    E --> H
    F --> H
    G --> H
    H --> I[結果出力]
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-74-01 | モード排他 | --analyze、--fixit、--ast-*は排他的 | 常時 |
| BR-74-02 | FixIt適用 | IncludeInDiagnosticCountsをfalseに設定 | --fixit使用時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | コンパイルエラー | ソースコードの構文エラー | ソースコードの修正 |
| 1 | ファイルエラー | 入力ファイルが見つからない | パスの確認 |

### リトライ仕様

なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

特になし。

## セキュリティ考慮事項

- --fixitはソースファイルを直接変更する

## 備考

- Clang Toolingの基本的な使用例として有用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClangCheck.cpp | `clang/tools/clang-check/ClangCheck.cpp` | 全体の処理フロー |

**主要処理フロー**:
1. **59-98行目**: コマンドラインオプションの定義
2. **103-146行目**: FixItRewriter関連クラスの定義
3. **148-172行目**: DumpSyntaxTreeアクションの実装
4. **174-190行目**: ClangCheckActionFactoryの実装
5. **194-259行目**: main関数、モード選択とTool実行

### プログラム呼び出し階層図

```
main
    │
    ├─ CommonOptionsParser::create()
    │
    ├─ ClangTool設定
    │      └─ ArgumentsAdjuster（--analyze用）
    │
    └─ FrontendActionFactory選択
           │
           ├─ AnalysisAction (--analyze)
           ├─ ClangCheckFixItAction (--fixit)
           ├─ DumpSyntaxTree (--syntax-tree-dump)
           └─ ClangCheckActionFactory (AST操作)
                  │
                  └─ newASTConsumer()
                         ├─ CreateASTDeclNodeLister (--ast-list)
                         ├─ CreateASTDumper (--ast-dump)
                         └─ CreateASTPrinter (--ast-print)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

ソースファイル ─────▶ ClangTool ─────▶ FrontendAction
                                            │
                                            ▼
                                       ASTConsumer
                                            │
                    ┌───────────────────────┼───────────────────────┐
                    │                       │                       │
                    ▼                       ▼                       ▼
              ASTダンプ              Syntax Tree              静的解析結果
                    │                       │                       │
                    └───────────────────────┼───────────────────────┘
                                            │
                                            ▼
                                       標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClangCheck.cpp | `clang/tools/clang-check/ClangCheck.cpp` | ソース | メイン実装 |
| ASTConsumers.h | `clang/include/clang/Frontend/ASTConsumers.h` | ヘッダ | AST出力用Consumer |
| FixItRewriter.h | `clang/include/clang/Rewrite/Frontend/FixItRewriter.h` | ヘッダ | FixIt適用 |
