# 機能設計書 75-clang-refactor

## 概要

本ドキュメントは、LLVM/Clangプロジェクトにおけるリファクタリングツール「clang-refactor」の機能設計書である。C/C++/Objective-Cコードのリファクタリング操作を自動化する。

### 本機能の処理概要

clang-refactorは、Clang Refactoringインフラストラクチャを使用して、様々なソースコード変換を実行するツールである。リネーム、extract、move等のリファクタリング操作をコマンドラインから実行できる。

**業務上の目的・背景**：大規模なコードベースにおいて、識別子のリネーム、関数の抽出、コードの移動などのリファクタリング作業を安全かつ自動的に行うことは、コードの保守性向上に不可欠である。

**機能の利用シーン**：
- シンボル名の一括変更
- 関数やメソッドの抽出
- コードの構造的な変換
- スクリプトによるバッチリファクタリング

**主要な処理内容**：
1. リファクタリングアクションの選択（サブコマンド）
2. 選択範囲の解析
3. リファクタリングルールの適用
4. ソースコード変更の生成と適用

**関連システム・外部連携**：compile_commands.json

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 端末出力 | 結果表示画面 | 変換結果の表示 |

## 機能種別

リファクタリング / コード変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| subcommand | string | Yes | リファクタリングアクション名 | 有効なアクション |
| -selection | string | No | 変換対象の範囲 | file:line:col-line:col形式 |
| -i | flag | No | ファイルをインプレース編集 | - |
| -v | flag | No | 詳細出力 | - |
| source_files | string[] | Yes | 対象ファイル | 有効なC/C++ファイル |

### 入力データソース

- C/C++/Objective-Cソースファイル
- コンパイルデータベース（compile_commands.json）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換後ソース | text/file | 変換結果（-i指定時はファイル直接更新） |
| 診断メッセージ | text | エラー・警告 |

### 出力先

- 標準出力（-i未指定時）
- ファイル（-i指定時）

## 処理フロー

### 処理シーケンス

```
1. サブコマンドの解析
   └─ RefactoringActionSubcommandの特定

2. オプションの解析
   └─ -selection等の解析

3. マッチするルールの検索
   └─ 条件に合うRefactoringActionRuleの選択

4. ASTの構築
   └─ 対象ファイルの解析

5. リファクタリングの実行
   └─ ルールのinvoke()呼び出し

6. 変更の適用
   └─ AtomicChangesの適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始: clang-refactor] --> B[サブコマンド解析]
    B --> C[オプション解析]
    C --> D[マッチするルール検索]
    D --> E{ルール発見?}
    E -->|No| F[エラー出力]
    E -->|Yes| G[AST構築]
    G --> H[リファクタリング実行]
    H --> I{-i指定?}
    I -->|Yes| J[ファイル更新]
    I -->|No| K[標準出力]
    J --> L[終了]
    K --> L
    F --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-75-01 | 選択範囲必須 | 一部のアクションは-selectionが必須 | hasSelectionRequirement()がtrue |
| BR-75-02 | ルール一意性 | マッチするルールは1つのみ許可 | 常時 |

### 計算ロジック

選択範囲は`file:line:column-line:column`形式または`test:filename`形式（テスト用）で指定。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ルール不一致 | 必須オプション不足 | オプション追加 |
| 1 | 解析失敗 | ASTの構築失敗 | ソースコード修正 |

### リトライ仕様

なし。

## トランザクション仕様

該当なし。全ての変更はAtomicChangesとして収集され、成功時にまとめて適用。

## パフォーマンス要件

特になし。

## セキュリティ考慮事項

- -i オプションはソースファイルを直接変更する

## 備考

- リファクタリングアクションはプラグイン形式で追加可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClangRefactor.cpp | `clang/tools/clang-refactor/ClangRefactor.cpp` | 全体の処理フロー |

**主要処理フロー**:
1. **54-166行目**: SourceSelectionArgument関連クラス
2. **170-253行目**: CommandLineRefactoringOption関連クラス
3. **256-315行目**: RefactoringActionSubcommandクラス
4. **317-344行目**: ClangRefactorConsumerクラス
5. **346-607行目**: ClangRefactorToolクラス
6. **611-645行目**: main関数

### プログラム呼び出し階層図

```
main
    │
    ├─ ClangRefactorTool()
    │      └─ createRefactoringActions()
    │             └─ 全アクションのSubCommand登録
    │
    ├─ ClangRefactorTool::Init()
    │      ├─ getSelectedSubcommand()
    │      └─ getMatchingRule()
    │
    └─ ClangTool::run()
           │
           └─ ClangRefactorTool::callback()
                  │
                  ├─ RefactoringRuleContext設定
                  └─ MatchingRule::invoke()
                         │
                         └─ AtomicChanges生成
```

### データフロー図

```
[入力]                     [処理]                       [出力]

サブコマンド ─────▶ RefactoringActionSubcommand
                           │
                           ▼
-selection ──────▶ SourceSelectionArgument
                           │
                           ▼
ソースファイル ─────▶ AST構築 ─────▶ RefactoringRuleContext
                                            │
                                            ▼
                                   RefactoringActionRule::invoke()
                                            │
                                            ▼
                                      AtomicChanges
                                            │
                        ┌───────────────────┴───────────────────┐
                        │                                       │
                        ▼                                       ▼
                  標準出力（変換後ソース）              ファイル更新（-i）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClangRefactor.cpp | `clang/tools/clang-refactor/ClangRefactor.cpp` | ソース | メイン実装 |
| TestSupport.cpp | `clang/tools/clang-refactor/TestSupport.cpp` | ソース | テスト支援 |
| RefactoringAction.h | `clang/include/clang/Tooling/Refactoring/RefactoringAction.h` | ヘッダ | アクション基底クラス |
| RefactoringOptions.h | `clang/include/clang/Tooling/Refactoring/RefactoringOptions.h` | ヘッダ | オプション定義 |
