# 機能設計書 76-clang-diff

## 概要

本ドキュメントは、LLVM/ClangプロジェクトにおけるAST差分ツール「clang-diff」の機能設計書である。2つのソースファイル間のASTレベルでの差分を検出・表示する。

### 本機能の処理概要

clang-diffは、Clang ASTDiffライブラリを使用して、2つのC/C++ソースファイルのAST（抽象構文木）を比較し、構造的な差分を検出するツールである。テキストレベルではなくAST構造での比較により、意味的な変更を正確に把握できる。

**業務上の目的・背景**：テキストベースの差分ツール（diff等）では、空白の変更やコードフォーマットの違いに影響されやすい。clang-diffはAST構造で比較することで、実質的なコード変更のみを検出し、コードレビューや変更解析に役立つ。

**機能の利用シーン**：
- コードレビュー時の構造的変更の確認
- リファクタリング前後の等価性検証
- コード進化の分析
- ASTの構造理解（単一ファイルダンプ）

**主要な処理内容**：
1. 2つのソースファイルからASTを構築
2. SyntaxTreeの構築
3. ASTDiffアルゴリズムによるマッチング
4. 差分（Insert/Delete/Update/Move）の検出と出力

**関連システム・外部連携**：compile_commands.json

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 端末出力 | 結果表示画面 | 差分のテキスト/HTML/JSON表示 |

## 機能種別

差分解析 / AST比較

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source | string | Yes | ソースファイル（変更前） | 有効なC/C++ファイル |
| destination | string | No | デスティネーションファイル（変更後） | 有効なC/C++ファイル |
| --ast-dump | flag | No | ASTをダンプ（単一ファイル） | - |
| --ast-dump-json | flag | No | ASTをJSONでダンプ | - |
| --dump-matches | flag | No | マッチしたノードを表示 | - |
| --html | flag | No | HTMLで差分を出力 | - |
| -s | int | No | 最大ノードサイズ | 正の整数 |
| --stop-diff-after | enum | No | 差分アルゴリズムの停止位置 | topdown/bottomup |
| -p | string | No | ビルドパス | 有効なディレクトリ |

### 入力データソース

- C/C++ソースファイル（2つ）
- コンパイルデータベース（オプション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 差分レポート | text | Insert/Delete/Update/Move操作のリスト |
| HTMLレポート | HTML | side-by-side差分表示 |
| JSONダンプ | JSON | AST構造のJSON表現 |

### 出力先

- 標準出力

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ ソース/デスティネーションファイル、オプションの取得

2. ASTの構築
   └─ 各ファイルからASTUnitを生成

3. SyntaxTreeの構築
   └─ diff::SyntaxTreeでAST構造を抽象化

4. 差分計算
   └─ diff::ASTDiffでtop-down/bottom-upマッチング

5. 結果の出力
   └─ テキスト/HTML/JSONで差分を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始: clang-diff] --> B[コマンドライン解析]
    B --> C{--ast-dump?}
    C -->|Yes| D[単一ファイルASTダンプ]
    C -->|No| E[2ファイル比較]
    E --> F[SrcTree構築]
    F --> G[DstTree構築]
    G --> H[ASTDiff計算]
    H --> I{--html?}
    I -->|Yes| J[HTML出力]
    I -->|No| K[テキスト出力]
    D --> L[終了]
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-76-01 | 単一ファイルモード | --ast-dump時はデスティネーション不要 | --ast-dump指定時 |
| BR-76-02 | 変更種別 | None/Delete/Update/Insert/Move/UpdateMoveの6種類 | 常時 |

### 計算ロジック

ASTDiffアルゴリズムは、top-downフェーズ（ルートからのグリーディマッチング）とbottom-upフェーズ（リーフからの最適化）の2段階で動作する。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 解析失敗 | ソースコードのパースエラー | ソースコード修正 |
| 1 | ファイルエラー | ファイルが見つからない | パス確認 |

### リトライ仕様

なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- MaxSizeオプションで大きなノードの処理を制限可能

## セキュリティ考慮事項

- 読み取り専用の解析のみ

## 備考

- GumTreeアルゴリズムをベースにした実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClangDiff.cpp | `clang/tools/clang-diff/ClangDiff.cpp` | 全体の処理フロー |

**主要処理フロー**:
1. **23-71行目**: コマンドラインオプションの定義
2. **86-112行目**: getAST関数でASTUnit取得
3. **116-317行目**: HTML出力関連関数
4. **344-408行目**: ノード出力関数
5. **443-536行目**: main関数、モード選択と差分処理

### プログラム呼び出し階層図

```
main
    │
    ├─ getAST()
    │      └─ ClangTool::buildASTs()
    │
    ├─ diff::SyntaxTree()
    │      └─ AST構造の抽象化
    │
    └─ diff::ASTDiff()
           │
           ├─ Top-downマッチング
           └─ Bottom-upマッチング
                  │
                  └─ printDstChange() / printHtmlForNode()
```

### データフロー図

```
[入力]                    [処理]                     [出力]

Source.cpp ──────▶ ASTUnit ──────▶ SyntaxTree (Src)
                                          │
                                          ▼
Dest.cpp ────────▶ ASTUnit ──────▶ SyntaxTree (Dst)
                                          │
                                          ▼
                                     ASTDiff
                                          │
                    ┌─────────────────────┼─────────────────────┐
                    │                     │                     │
                    ▼                     ▼                     ▼
              テキスト出力           HTML出力            JSONダンプ
                    │                     │                     │
                    └─────────────────────┼─────────────────────┘
                                          │
                                          ▼
                                       標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClangDiff.cpp | `clang/tools/clang-diff/ClangDiff.cpp` | ソース | メイン実装 |
| ASTDiff.h | `clang/include/clang/Tooling/ASTDiff/ASTDiff.h` | ヘッダ | 差分アルゴリズムAPI |
| ASTDiff.cpp | `clang/lib/Tooling/ASTDiff/ASTDiff.cpp` | ソース | 差分アルゴリズム実装 |
