# 機能設計書 77-clang-doc

## 概要

本ドキュメントは、LLVM/Clangプロジェクトにおけるドキュメント生成ツール「clang-doc」の機能設計書である。C/C++ソースコードとコメントからAPIドキュメントを自動生成する。

### 本機能の処理概要

clang-docは、LibToolingを使用してC/C++ソースコードを解析し、Doxygen形式のコメントを含む宣言情報を収集して、HTML、Markdown、YAML、JSON形式のドキュメントを生成するツールである。

**業務上の目的・背景**：ソフトウェアプロジェクトにおいてAPIドキュメントの維持は重要だが手作業では困難。clang-docはソースコードから自動的にドキュメントを生成し、常に最新のコードと同期したドキュメントを維持できる。

**機能の利用シーン**：
- プロジェクトのAPIリファレンス生成
- ライブラリのドキュメント自動生成
- コードコメントからのドキュメント抽出
- CI/CDパイプラインでのドキュメント自動更新

**主要な処理内容**：
1. ソースファイルの解析とAST構築
2. 宣言情報とコメントの収集
3. USR（Unified Symbol Resolution）によるマージ
4. 指定形式（HTML/MD/YAML/JSON）でのドキュメント出力

**関連システム・外部連携**：compile_commands.json

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 生成ドキュメント | 結果表示画面 | HTML/MD/YAML形式のドキュメント表示 |

## 機能種別

ドキュメント生成 / ソース解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --format | enum | No | 出力形式 | yaml/md/html/json |
| --output | string | No | 出力ディレクトリ | 有効なディレクトリ |
| --project-name | string | No | プロジェクト名 | 文字列 |
| --public | flag | No | publicな宣言のみ | - |
| --doxygen | flag | No | Doxygenコメントのみ使用 | - |
| --source-root | string | No | ソースルートディレクトリ | 有効なディレクトリ |
| --repository | string | No | リポジトリURL | 有効なURL |
| --stylesheets | string[] | No | カスタムCSSファイル | 有効なファイルパス |
| --asset | string | No | アセットディレクトリ | 有効なディレクトリ |
| source_files | string[] | Yes | 対象ファイル | 有効なC/C++ファイル |

### 入力データソース

- C/C++ソースファイル
- コンパイルデータベース（compile_commands.json）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTMLドキュメント | HTML | ナビゲーション付きのWebドキュメント |
| Markdownドキュメント | MD | Markdown形式のドキュメント |
| YAMLデータ | YAML | 構造化されたドキュメントデータ |
| JSONデータ | JSON | JSON形式のドキュメントデータ |

### 出力先

- 指定されたoutputディレクトリ（デフォルト: docs/）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ 出力形式、オプションの取得

2. マッピングフェーズ
   └─ 各ソースファイルからInfo（宣言情報）を抽出

3. 収集フェーズ
   └─ USRをキーにしてビットコードを収集

4. リデュースフェーズ
   └─ 同じUSRのInfo情報をマージ

5. 生成フェーズ
   └─ 指定形式でドキュメントを生成

6. アセット生成
   └─ CSS/JSなどのリソースファイルをコピー
```

### フローチャート

```mermaid
flowchart TD
    A[開始: clang-doc] --> B[コマンドライン解析]
    B --> C[Executor作成]
    C --> D[マッピングフェーズ]
    D --> E[ビットコード収集]
    E --> F[スレッドプールでリデュース]
    F --> G[インデックス構築]
    G --> H{format}
    H -->|html| I[HTMLGenerator]
    H -->|md| J[MDGenerator]
    H -->|yaml| K[YAMLGenerator]
    H -->|json| L[JSONGenerator]
    I --> M[アセット生成]
    J --> M
    K --> M
    L --> M
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-77-01 | デフォルト形式 | 出力形式のデフォルトはYAML | --format未指定時 |
| BR-77-02 | Publicフィルタ | --public指定時はpublic宣言のみ出力 | --public指定時 |
| BR-77-03 | Doxygenフィルタ | --doxygen指定時はDoxygenコメントのみ使用 | --doxygen指定時 |
| BR-77-04 | USRマージ | 同じUSRを持つ宣言は1つにマージ | 常時 |

### 計算ロジック

USR（Unified Symbol Resolution）はClangが生成するシンボルの一意識別子。ヘッダーと実装で分かれた宣言も同じUSRでマージされる。

## データベース操作仕様

本機能はデータベースを使用しない。ビットコード形式で中間データを保持。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | マッピングエラー | ファイル解析失敗 | --ignore-map-errorsで継続可能 |
| - | ビットコードエラー | ビットコード読み込み失敗 | エラーを報告して中断 |
| - | マージエラー | Info情報のマージ失敗 | エラーを報告して中断 |

### リトライ仕様

--ignore-map-errors指定時は解析失敗を警告として継続。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- マルチスレッド処理による並列リデュース
- ExecutorConcurrencyフラグで並列度制御
- --ftime-traceでプロファイリング可能

## セキュリティ考慮事項

- ソースコードの内容がドキュメントに含まれる

## 備考

- 大規模プロジェクトではAllTUsExecutionを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Representation.h | `clang-tools-extra/clang-doc/Representation.h` | Info構造体群の定義 |

**読解のコツ**: Info基底クラスとNamespaceInfo、RecordInfo、FunctionInfo等の派生クラスの関係を理解する。

#### Step 2: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClangDocMain.cpp | `clang-tools-extra/clang-doc/tool/ClangDocMain.cpp` | 全体の処理フロー |

**主要処理フロー**:
1. **49-127行目**: コマンドラインオプションの定義
2. **238-256行目**: Executorの作成と引数調整
3. **291-296行目**: マッピングフェーズの実行
4. **327-390行目**: スレッドプールでのリデュース処理
5. **400-411行目**: ドキュメント生成とリソース作成

### プログラム呼び出し階層図

```
main
    │
    ├─ createExecutorFromCommandLineArgs()
    │
    ├─ Executor::execute()
    │      └─ newMapperActionFactory()
    │             └─ Mapper (Serialize.cpp)
    │                    └─ ビットコード生成
    │
    ├─ ThreadPool (リデュース)
    │      ├─ ClangDocBitcodeReader
    │      └─ mergeInfos()
    │
    └─ Generator::generateDocumentation()
           │
           ├─ HTMLGenerator
           ├─ MDGenerator
           ├─ YAMLGenerator
           └─ JSONGenerator
```

### データフロー図

```
[入力]                    [処理]                       [出力]

ソースファイル群 ─────▶ Mapper ─────▶ ビットコード (USR -> Info)
                                            │
                                            ▼
                                  USRToBitcode (StringMap)
                                            │
                                            ▼
                            ThreadPool (ClangDocBitcodeReader)
                                            │
                                            ▼
                                    mergeInfos()
                                            │
                                            ▼
                                  USRToInfo (StringMap)
                                            │
                                            ▼
                                     Generator
                                            │
                    ┌───────────────────────┼───────────────────────┐
                    │                       │                       │
                    ▼                       ▼                       ▼
               HTML出力                  MD出力               YAML/JSON出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClangDocMain.cpp | `clang-tools-extra/clang-doc/tool/ClangDocMain.cpp` | ソース | メイン実装 |
| Representation.h | `clang-tools-extra/clang-doc/Representation.h` | ヘッダ | Info構造体定義 |
| Serialize.cpp | `clang-tools-extra/clang-doc/Serialize.cpp` | ソース | AST->Info変換 |
| Mapper.cpp | `clang-tools-extra/clang-doc/Mapper.cpp` | ソース | マッピング処理 |
| BitcodeWriter.cpp | `clang-tools-extra/clang-doc/BitcodeWriter.cpp` | ソース | ビットコード書き込み |
| BitcodeReader.cpp | `clang-tools-extra/clang-doc/BitcodeReader.cpp` | ソース | ビットコード読み込み |
| Generators.cpp | `clang-tools-extra/clang-doc/Generators.cpp` | ソース | ジェネレータ登録 |
| HTMLGenerator.cpp | `clang-tools-extra/clang-doc/HTMLGenerator.cpp` | ソース | HTML生成 |
| MDGenerator.cpp | `clang-tools-extra/clang-doc/MDGenerator.cpp` | ソース | Markdown生成 |
| YAMLGenerator.cpp | `clang-tools-extra/clang-doc/YAMLGenerator.cpp` | ソース | YAML生成 |
| JSONGenerator.cpp | `clang-tools-extra/clang-doc/JSONGenerator.cpp` | ソース | JSON生成 |
