# 機能設計書 78-include-cleaner

## 概要

本ドキュメントは、LLVM/Clangプロジェクトにおけるインクルード整理ツール「include-cleaner」の機能設計書である。不要なヘッダーインクルードの検出・削除を行う。

### 本機能の処理概要

include-cleanerは、C/C++ソースコードを解析し、使用されていない#includeディレクティブを検出して削除を提案し、また不足している#includeの追加を提案するツールである。

**業務上の目的・背景**：不要なインクルードはコンパイル時間の増大、依存関係の複雑化、ヘッダー変更時の不必要な再コンパイルを引き起こす。include-cleanerは、各ファイルが必要最小限のインクルードのみを持つ「自己完結」状態を目指す。

**機能の利用シーン**：
- コンパイル時間の短縮
- ヘッダー依存関係の整理
- コードの保守性向上
- インクルード順序の最適化

**主要な処理内容**：
1. ソースファイルの解析とAST構築
2. シンボル使用箇所の収集
3. 各シンボルを提供するヘッダーの特定
4. 不要インクルードと不足インクルードの検出
5. 修正の提案または自動適用

**関連システム・外部連携**：compile_commands.json、clang-format

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 端末出力 | 結果表示画面 | 変更リスト、修正後コードの表示 |
| - | HTMLレポート | 結果表示画面 | 詳細な解析レポート |

## 機能種別

インクルード解析 / コード整理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --edit | flag | No | ファイルを直接編集 | - |
| --print | enum | No | 出力形式（changes/final） | changes/（空） |
| --html | string | No | HTMLレポート出力パス | 有効なパス |
| --disable-insert | flag | No | ヘッダー挿入を無効化 | - |
| --disable-remove | flag | No | ヘッダー削除を無効化 | - |
| --only-headers | string | No | 解析対象ヘッダーのフィルタ | 正規表現 |
| --ignore-headers | string | No | 除外ヘッダーのフィルタ | 正規表現 |
| source_files | string[] | Yes | 対象ファイル | 有効なC/C++ファイル |

### 入力データソース

- C/C++ソースファイル
- コンパイルデータベース（compile_commands.json）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変更リスト | text | 追加/削除すべきインクルードのリスト |
| 修正後ソース | text/file | 修正適用後のソースコード |
| HTMLレポート | HTML | 詳細な解析レポート |

### 出力先

- 標準出力（変更リスト、修正後コード）
- ファイル（--edit使用時、--html使用時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ オプション、フィルタ設定の取得

2. ヘッダーフィルタの構築
   └─ --only-headers、--ignore-headersの正規表現コンパイル

3. 各ソースファイルの解析
   └─ AST構築、マクロ参照の記録、インクルード記録

4. シンボル使用箇所の収集
   └─ 宣言参照のウォーク

5. 解析の実行
   └─ 不要/不足インクルードの特定

6. 修正の生成と適用
   └─ fixIncludes関数で修正を生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始: include-cleaner] --> B[コマンドライン解析]
    B --> C[ヘッダーフィルタ構築]
    C --> D{各ソースファイル}
    D --> E[AST構築]
    E --> F[RecordedAST/PP記録]
    F --> G[analyze実行]
    G --> H[Results取得]
    H --> I{--print指定?}
    I -->|changes| J[変更リスト出力]
    I -->|final| K[修正後コード出力]
    I -->|なし| L[標準出力なし]
    J --> M{--edit指定?}
    K --> M
    L --> M
    M -->|Yes| N[ファイル更新]
    M -->|No| O[次のファイル]
    N --> O
    O --> D
    D -->|完了| P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-78-01 | 自己完結原則 | 各ファイルは使用するシンボルを直接インクルードすべき | 常時 |
| BR-78-02 | IWYU | Include What You Useの原則に従う | 常時 |
| BR-78-03 | コンパイル可能前提 | 解析対象はコンパイル可能なコードが前提 | 常時 |

### 計算ロジック

シンボルの使用箇所から、そのシンボルを提供するヘッダーを逆引きし、現在のインクルードリストと比較して過不足を検出。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コンパイルエラー | ソースコードがコンパイル不可 | エラーを報告してスキップ |
| - | 正規表現エラー | 無効なフィルタパターン | エラー終了 |

### リトライ仕様

コンパイルエラー発生時は該当ファイルをスキップ。

## トランザクション仕様

該当なし。

## パフォーマンス要件

特になし。

## セキュリティ考慮事項

- --edit オプションはソースファイルを直接変更する

## 備考

- clangdと統合されており、LSP経由でも利用可能
- clang-tidyのmisc-include-cleanerチェッカーとしても利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Types.h | `clang-tools-extra/include-cleaner/include/clang-include-cleaner/Types.h` | 基本型の定義 |
| 1-2 | Record.h | `clang-tools-extra/include-cleaner/include/clang-include-cleaner/Record.h` | 記録用構造体 |

#### Step 2: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IncludeCleaner.cpp | `clang-tools-extra/include-cleaner/tool/IncludeCleaner.cpp` | 全体の処理フロー |

**主要処理フロー**:
1. **37-117行目**: コマンドラインオプションの定義
2. **131-252行目**: Actionクラスの実装
3. **253-270行目**: ActionFactoryクラス
4. **274-296行目**: matchesAny関数（正規表現フィルタ）
5. **358-414行目**: main関数

### プログラム呼び出し階層図

```
main
    │
    ├─ CommonOptionsParser::create()
    │
    ├─ headerFilter()
    │      └─ matchesAny()
    │
    └─ ClangTool::run()
           │
           └─ ActionFactory::create()
                  │
                  └─ Action
                         │
                         ├─ BeginInvocation()
                         ├─ ExecuteAction()
                         │      └─ PP記録設定
                         ├─ CreateASTConsumer()
                         │      └─ RecordedAST
                         └─ EndSourceFile()
                                │
                                ├─ analyze()
                                ├─ fixIncludes()
                                └─ 結果出力/ファイル更新
```

### データフロー図

```
[入力]                    [処理]                       [出力]

ソースファイル ─────▶ Action::ExecuteAction ─────▶ RecordedAST + RecordedPP
                                                        │
                                                        ▼
                                                   analyze()
                                                        │
                                                        ▼
                                                 AnalysisResults
                                                   (Missing, Unused)
                                                        │
                                                        ▼
                                                 fixIncludes()
                                                        │
                        ┌───────────────────────────────┼───────────────────────────────┐
                        │                               │                               │
                        ▼                               ▼                               ▼
                  変更リスト出力                  修正後コード出力                 ファイル更新
                  (--print=changes)              (--print)                        (--edit)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IncludeCleaner.cpp | `clang-tools-extra/include-cleaner/tool/IncludeCleaner.cpp` | ソース | メイン実装 |
| Analysis.h | `clang-tools-extra/include-cleaner/include/clang-include-cleaner/Analysis.h` | ヘッダ | 解析API |
| Analysis.cpp | `clang-tools-extra/include-cleaner/lib/Analysis.cpp` | ソース | 解析実装 |
| Record.h | `clang-tools-extra/include-cleaner/include/clang-include-cleaner/Record.h` | ヘッダ | 記録構造体 |
| Record.cpp | `clang-tools-extra/include-cleaner/lib/Record.cpp` | ソース | 記録実装 |
| Types.h | `clang-tools-extra/include-cleaner/include/clang-include-cleaner/Types.h` | ヘッダ | 基本型定義 |
| WalkAST.cpp | `clang-tools-extra/include-cleaner/lib/WalkAST.cpp` | ソース | ASTウォーク |
| FindHeaders.cpp | `clang-tools-extra/include-cleaner/lib/FindHeaders.cpp` | ソース | ヘッダー検索 |
| HTMLReport.cpp | `clang-tools-extra/include-cleaner/lib/HTMLReport.cpp` | ソース | HTMLレポート生成 |
