# 機能設計書 79-clang-include-fixer

## 概要

本ドキュメントは、LLVM/Clangプロジェクトにおけるインクルード自動修正ツール「clang-include-fixer」の機能設計書である。未定義シンボルに対して適切な#includeディレクティブを自動追加する。

### 本機能の処理概要

clang-include-fixerは、C/C++ソースコードを解析し、未定義のシンボル（型、関数、変数など）を検出して、そのシンボルを提供するヘッダーファイルを自動的に特定し、#includeディレクティブを追加するツールである。

**業務上の目的・背景**：C/C++開発において、使用したいシンボルがどのヘッダーファイルで定義されているかを調べる作業は煩雑で時間がかかる。clang-include-fixerは、シンボルデータベースを活用して適切なヘッダーを自動的に特定し、開発効率を向上させる。

**機能の利用シーン**：
- 新しいシンボルを使用する際のヘッダー追加
- コンパイルエラー「undefined symbol」の自動修正
- エディタ統合による即時インクルード提案
- 大規模プロジェクトでのヘッダー依存関係整理

**主要な処理内容**：
1. ソースファイルの解析と未定義シンボルの検出
2. シンボルデータベースからのヘッダー検索
3. 適切なヘッダーの選択と#include文の生成
4. コードスタイルに合わせたフォーマット適用
5. ファイルへの修正適用または提案出力

**関連システム・外部連携**：compile_commands.json、find-all-symbols（シンボルDB生成）、clang-format

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 端末出力 | 結果表示画面 | 追加されたヘッダーの表示 |
| - | JSON出力 | 結果表示画面 | シンボル情報とヘッダー候補の出力 |

## 機能種別

インクルード修正 / コード補完

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --db | enum | No | データベース形式（fixed/yaml/fuzzyYaml） | 有効な形式 |
| --input | string | No | データベースファイルパス | 有効なパス |
| --query-symbol | string | No | 直接クエリするシンボル名 | シンボル形式 |
| --minimize-paths | bool | No | インクルードパスの最小化 | - |
| --stdin | flag | No | 標準入力からソース読み込み | - |
| --output-headers | flag | No | ヘッダー情報をJSON出力 | - |
| --insert-header | string | No | 指定ヘッダーを挿入（YAML/JSON） | 有効なYAML/JSON |
| --style | string | No | フォーマットスタイル | 有効なスタイル名 |
| -q | flag | No | 出力を抑制 | - |
| source_files | string[] | Yes | 対象ファイル | 有効なC/C++ファイル |

### 入力データソース

- C/C++ソースファイル
- コンパイルデータベース（compile_commands.json）
- シンボルデータベース（find_all_symbols_db.yaml）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 修正後ソース | text/file | #include追加後のソースコード |
| ヘッダー情報 | JSON | クエリシンボルと候補ヘッダーの情報 |
| 追加ログ | text | 追加されたヘッダーのログ |

### 出力先

- 標準出力（STDINモード時、--output-headers時）
- ファイル（通常モード時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ オプション、データベース設定の取得

2. シンボルインデックスマネージャの作成
   └─ データベース形式に応じたインデックス構築

3. モード判定と処理分岐
   ├─ --query-symbol: シンボル直接クエリ
   ├─ --insert-header: 指定ヘッダー挿入
   └─ 通常モード: ソース解析と修正

4. ソースファイルの解析
   └─ 未定義シンボルの検出とコンテキスト収集

5. ヘッダー検索と選択
   └─ シンボルDBからマッチするヘッダーを検索

6. 修正の生成と適用
   └─ createIncludeFixerReplacementsで修正生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始: clang-include-fixer] --> B[コマンドライン解析]
    B --> C[createSymbolIndexManager]
    C --> D{モード判定}
    D -->|--query-symbol| E[シンボルDB検索]
    E --> F[JSON出力]
    D -->|--insert-header| G[YAML/JSON解析]
    G --> H[ヘッダー挿入]
    H --> I[修正後コード出力]
    D -->|通常| J[ClangTool実行]
    J --> K[IncludeFixerActionFactory]
    K --> L[未定義シンボル検出]
    L --> M[Contexts収集]
    M --> N{--output-headers?}
    N -->|Yes| O[JSON出力]
    N -->|No| P[Replacements生成]
    P --> Q{--stdin?}
    Q -->|Yes| R[標準出力に書き込み]
    Q -->|No| S[Rewriterでファイル更新]
    F --> T[終了]
    I --> T
    O --> T
    R --> T
    S --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-79-01 | デフォルトDB | データベース形式のデフォルトはyaml | --db未指定時 |
| BR-79-02 | DB自動検索 | --input未指定時は親ディレクトリを遡って検索 | yaml形式時 |
| BR-79-03 | パス最小化 | デフォルトでインクルードパスを最小化 | --minimize-paths未指定時 |
| BR-79-04 | 単一ヘッダー | --insert-header時は単一の一意なヘッダーが必要 | --insert-header使用時 |

### 計算ロジック

シンボル検索はSymbolIndexManagerを通じて行われ、fixed/yaml/fuzzyYamlの各形式に対応したインデックスから候補を取得。複数候補がある場合はSignals（使用頻度等）でランキング。

## データベース操作仕様

本機能はデータベースを使用しない。シンボル情報はYAML形式のファイルから読み込み。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB読み込みエラー | シンボルDBが見つからない | エラーメッセージを出力して終了 |
| - | 解析エラー | ソースファイルがコンパイル不可 | エラーを報告して終了 |
| - | 複数ヘッダーエラー | --insert-headerで複数ヘッダー指定 | エラーを報告して終了 |

### リトライ仕様

リトライなし。エラー発生時は即座に終了。

## トランザクション仕様

該当なし。

## パフォーマンス要件

特になし。

## セキュリティ考慮事項

- ソースファイルを直接変更する（非STDINモード時）

## 備考

- エディタ統合では--stdinモードと--output-headersを組み合わせて使用
- find-all-symbolsツールでシンボルDBを事前生成する必要がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IncludeFixerContext.h | `clang-tools-extra/clang-include-fixer/IncludeFixerContext.h` | コンテキスト構造体 |
| 1-2 | SymbolIndex.h | `clang-tools-extra/clang-include-fixer/SymbolIndex.h` | シンボルインデックスインターフェース |

#### Step 2: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClangIncludeFixer.cpp | `clang-tools-extra/clang-include-fixer/tool/ClangIncludeFixer.cpp` | 全体の処理フロー |

**主要処理フロー**:
1. **33-78行目**: YAML MappingTraitsの定義
2. **81-158行目**: コマンドラインオプションの定義
3. **160-234行目**: createSymbolIndexManager関数（DB形式別のインデックス作成）
4. **236-261行目**: writeToJson関数（JSON出力）
5. **263-471行目**: includeFixerMain関数（メイン処理）
6. **475-477行目**: main関数

### プログラム呼び出し階層図

```
main
    │
    └─ includeFixerMain()
           │
           ├─ CommonOptionsParser::create()
           │
           ├─ createSymbolIndexManager()
           │      │
           │      ├─ InMemorySymbolIndex (fixed)
           │      ├─ YamlSymbolIndex (yaml)
           │      └─ FuzzySymbolIndex (fuzzyYaml)
           │
           ├─ [--query-symbol] SymbolIndexMgr->search()
           │      └─ writeToJson()
           │
           ├─ [--insert-header] yaml::Input
           │      └─ createIncludeFixerReplacements()
           │
           └─ [通常] ClangTool::run()
                  │
                  └─ IncludeFixerActionFactory
                         │
                         └─ IncludeFixer
                                │
                                ├─ 未定義シンボル検出
                                └─ Contexts収集
                  │
                  └─ createIncludeFixerReplacements()
                         │
                         └─ Rewriter::overwriteChangedFiles()
```

### データフロー図

```
[入力]                    [処理]                       [出力]

ソースファイル ─────▶ ClangTool::run() ─────▶ IncludeFixerContext
                                                     │
シンボルDB ─────────▶ SymbolIndexManager              │
                           │                         │
                           ▼                         ▼
                     search(symbol) ────────▶ HeaderInfos
                                                     │
                                                     ▼
                                     createIncludeFixerReplacements()
                                                     │
                        ┌────────────────────────────┼────────────────────────────┐
                        │                            │                            │
                        ▼                            ▼                            ▼
                  JSON出力                    標準出力                      ファイル更新
                  (--output-headers)          (--stdin)                     (通常モード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClangIncludeFixer.cpp | `clang-tools-extra/clang-include-fixer/tool/ClangIncludeFixer.cpp` | ソース | メイン実装 |
| IncludeFixer.h | `clang-tools-extra/clang-include-fixer/IncludeFixer.h` | ヘッダ | IncludeFixerクラス定義 |
| IncludeFixer.cpp | `clang-tools-extra/clang-include-fixer/IncludeFixer.cpp` | ソース | IncludeFixer実装 |
| IncludeFixerContext.h | `clang-tools-extra/clang-include-fixer/IncludeFixerContext.h` | ヘッダ | コンテキスト構造体 |
| IncludeFixerContext.cpp | `clang-tools-extra/clang-include-fixer/IncludeFixerContext.cpp` | ソース | コンテキスト実装 |
| SymbolIndex.h | `clang-tools-extra/clang-include-fixer/SymbolIndex.h` | ヘッダ | インデックスインターフェース |
| SymbolIndexManager.h | `clang-tools-extra/clang-include-fixer/SymbolIndexManager.h` | ヘッダ | インデックス管理 |
| SymbolIndexManager.cpp | `clang-tools-extra/clang-include-fixer/SymbolIndexManager.cpp` | ソース | インデックス管理実装 |
| YamlSymbolIndex.h | `clang-tools-extra/clang-include-fixer/YamlSymbolIndex.h` | ヘッダ | YAML DB読み込み |
| YamlSymbolIndex.cpp | `clang-tools-extra/clang-include-fixer/YamlSymbolIndex.cpp` | ソース | YAML DB実装 |
| InMemorySymbolIndex.h | `clang-tools-extra/clang-include-fixer/InMemorySymbolIndex.h` | ヘッダ | インメモリDB |
| FuzzySymbolIndex.h | `clang-tools-extra/clang-include-fixer/FuzzySymbolIndex.h` | ヘッダ | ファジーマッチDB |
