# 機能設計書 8-LLDB

## 概要

本ドキュメントは、LLDB（LLVMデバッガ）の機能設計を記述する。LLDBはLLVMプロジェクトのデバッガであり、C、C++、Objective-C、Swiftなどの言語をサポートする高機能なソースレベルデバッガである。

### 本機能の処理概要

LLDBは、実行可能ファイルのデバッグセッションを管理し、ブレークポイント設定、ステップ実行、変数検査、メモリ表示などのデバッグ機能を提供する。コマンドラインインタフェースとAPI（SB API）の両方を提供する。

**業務上の目的・背景**：GDBに代わるモダンで拡張性の高いデバッガを提供する。LLVMのコンパイラインフラストラクチャと緊密に統合され、優れたデバッグ情報サポートとPythonスクリプト拡張機能を持つ。XcodeのデフォルトデバッガとしてmacOSで広く使用される。

**機能の利用シーン**：
- アプリケーションのデバッグ
- クラッシュダンプの解析
- ライブプロセスへのアタッチ
- リモートデバッグ
- REPL（対話型評価）
- IDE統合（Xcode、Visual Studio Code等）

**主要な処理内容**：
1. デバッグセッションの初期化
2. コマンドインタプリタの実行
3. ブレークポイント管理
4. プロセス制御（実行、停止、ステップ）
5. シンボル/変数検査
6. Pythonスクリプトサポート

**関連システム・外部連携**：
- LLVM/Clangデバッグ情報
- DWARFデバッグフォーマット
- Python拡張機能
- DAP（Debug Adapter Protocol）

**権限による制御**：デバッグ対象プロセスへのアクセス権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | LLDBはCLI/APIツールであり、GUI画面は持たない |

## 機能種別

デバッガ / プロセス制御 / シンボル解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 実行ファイル | string | No | デバッグ対象 | 実行可能ファイル |
| -c/--core | string | No | コアファイル | 有効なパス |
| -p/--attach-pid | int | No | アタッチ対象PID | 有効なPID |
| -n/--attach-name | string | No | アタッチ対象プロセス名 | プロセス名 |
| -f/--file | string | No | デバッグ対象ファイル | 実行可能ファイル |
| -s/--source | string | No | 実行するコマンドファイル | 有効なパス |
| -o/--one-line | string | No | 実行するコマンド | 有効なコマンド |
| -r/--repl | flag | No | REPLモード | true/false |
| --batch | flag | No | バッチモード | true/false |
| -a/--arch | string | No | アーキテクチャ | 有効なアーキテクチャ |

### 入力データソース

- 実行可能ファイル
- 共有ライブラリ（シンボル情報）
- dSYMファイル（macOS）
- コアダンプファイル
- コマンドスクリプトファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| デバッグ出力 | text | 変数値、スタックトレース等 |
| 診断メッセージ | text | エラー/警告 |
| バージョン情報 | text | LLDBバージョン |
| Pythonパス | text | Python実行パス |

### 出力先

- 標準出力（デバッグ情報）
- 標準エラー（エラーメッセージ）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ SBDebugger初期化、オプション解析
2. 初期ファイル読み込み
   └─ .lldbinit読み込み
3. ターゲット作成
   └─ 実行ファイルロードまたはアタッチ
4. コマンド実行
   └─ -o/-sで指定されたコマンド実行
5. メインループ
   └─ 対話型コマンドインタプリタ
6. 終了処理
   └─ セッションクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[main]
    B --> C[InitLLVM]
    C --> D[オプション解析]
    D --> E{ヘルプ表示?}
    E -->|Yes| F[ヘルプ表示]
    E -->|No| G[SBDebugger初期化]
    F --> Z[終了]
    G --> H[Driver作成]
    H --> I[ProcessArgs]
    I --> J{バージョン表示?}
    J -->|Yes| K[バージョン表示]
    J -->|No| L[MainLoop]
    K --> Z
    L --> M[初期化ファイル読み込み]
    M --> N{ターゲット指定?}
    N -->|Yes| O[target create]
    N -->|No| P[アタッチ処理]
    O --> Q[コマンド実行]
    P --> Q
    Q --> R{REPLモード?}
    R -->|Yes| S[RunREPL]
    R -->|No| T[RunCommandInterpreter]
    S --> U[終了処理]
    T --> U
    U --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 初期化ファイル | ~/.lldbinit、.lldbinit読み込み | 起動時 |
| BR-002 | バッチモード | --batchで非対話型実行 | オプション指定時 |
| BR-003 | REPLモード | -rでREPL実行 | オプション指定時 |
| BR-004 | コマンド優先 | -oコマンドはファイルロード前/後で順序制御 | オプション指定時 |
| BR-005 | 終了コード | quitコマンドで終了コード指定可能 | セッション終了時 |

### 計算ロジック

- シンボル解決：DWARF情報からのシンボル検索
- アドレス計算：仮想アドレスから物理位置への変換
- 式評価：デバッグ中の式のランタイム評価

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | LLDBはデータベースを使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------
| 1 | ファイルエラー | ファイルが存在しない | パスを確認 |
| 1 | アタッチエラー | プロセスにアタッチ不可 | 権限を確認 |
| 1 | シンボルエラー | デバッグ情報不足 | -gでコンパイル |
| 1 | 引数エラー | 不正なオプション | ヘルプ参照 |

### リトライ仕様

リトライは行わない。エラー発生時はエラーメッセージを出力。

## トランザクション仕様

LLDBはデータベーストランザクションを使用しない。

## パフォーマンス要件

- 大規模バイナリの高速シンボル読み込み
- 効率的なブレークポイント管理
- メモリ使用量の最適化

## セキュリティ考慮事項

- デバッグ対象プロセスへのアクセス権限チェック
- 署名検証（macOS）
- サンドボックス考慮

## 備考

LLDBはC++ SB APIを通じてプログラマティックなアクセスが可能であり、IDE統合やカスタムデバッグツールの開発に適している。Pythonバインディングにより柔軟な拡張が可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Driver.cpp | `lldb/tools/driver/Driver.cpp` | メインエントリーポイント |

**主要処理フロー**:
1. **805-955行目**: main関数 - メインエントリー
2. **812行目**: InitLLVM初期化
3. **827-832行目**: LLDBOptTableでオプション解析
4. **835-837行目**: ヘルプ表示処理
5. **858行目**: SBDebugger::InitializeWithErrorHandling
6. **921行目**: Driver作成
7. **924行目**: ProcessArgs実行
8. **930行目**: MainLoop実行

#### Step 2: Driverクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Driver.cpp | `lldb/tools/driver/Driver.cpp` | Driverクラス |

**主要処理フロー**:
- **114-125行目**: Driverコンストラクタ/デストラクタ
- **115行目**: SBDebugger::Create(false)でデバッガ作成
- **191-434行目**: ProcessArgs - 引数処理

#### Step 3: MainLoopを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Driver.cpp | `lldb/tools/driver/Driver.cpp` | MainLoop |

**主要処理フロー**:
- **529-726行目**: MainLoop関数
- **554-559行目**: 初期化ファイル読み込み
- **570行目**: AllowExitCodeOnQuit(true)
- **577行目**: WriteCommandsForSourcing（before file）
- **624行目**: WriteCommandsForSourcing（after file）
- **658-659行目**: RunCommandInterpreter実行
- **704行目**: REPLモード時RunREPL
- **718行目**: 対話型RunCommandInterpreter

### プログラム呼び出し階層図

```
main (Driver.cpp:805)
    │
    ├─ InitLLVM
    ├─ LLDBOptTable::ParseArgs
    │
    ├─ [--help] printHelp (Driver.cpp:759)
    │
    ├─ SBDebugger::InitializeWithErrorHandling
    ├─ SBDebugger::PrintDiagnosticsOnError
    │
    └─ Driver (Driver.cpp:114)
           │
           ├─ SBDebugger::Create
           │
           ├─ ProcessArgs (Driver.cpp:191)
           │      ├─ SkipLLDBInitFiles
           │      ├─ SetUseColor
           │      └─ AddInitialCommand
           │
           └─ MainLoop (Driver.cpp:529)
                  │
                  ├─ SourceInitFileInGlobalDirectory
                  ├─ SourceInitFileInHomeDirectory
                  ├─ SourceInitFileInCurrentWorkingDirectory
                  │
                  ├─ WriteCommandsForSourcing
                  │
                  ├─ [batch] RunCommandInterpreter
                  │
                  ├─ [repl] RunREPL
                  │
                  └─ [interactive] RunCommandInterpreter
```

### データフロー図

```
コマンドライン引数
        │
        v
+------------------+
|      main        |
| (Driver.cpp:805) |
+------------------+
        │
        v
+------------------+
| SBDebugger初期化 |
+------------------+
        │
        v
+------------------+
|     Driver       |
|   ProcessArgs    |
+------------------+
        │
        ├── --version ──> バージョン表示
        ├── --python-path ──> Pythonパス表示
        │
        v
+------------------+
|    MainLoop      |
+------------------+
        │
        ├─ .lldbinit読み込み
        │
        ├─ ターゲット作成
        │      ├── -f/--file ──> target create
        │      ├── -c/--core ──> コア読み込み
        │      ├── -p/--attach-pid ──> process attach --pid
        │      └── -n/--attach-name ──> process attach --name
        │
        ├─ コマンド実行 (-o/-s)
        │
        └─ 対話モード
               ├── [repl] RunREPL
               └── [通常] RunCommandInterpreter
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Driver.cpp | `lldb/tools/driver/Driver.cpp` | ソース | メインエントリー |
| Driver.h | `lldb/tools/driver/Driver.h` | ヘッダ | Driverクラス定義 |
| SBDebugger.h | `lldb/include/lldb/API/SBDebugger.h` | ヘッダ | デバッガAPI |
| SBCommandInterpreter.h | `lldb/include/lldb/API/SBCommandInterpreter.h` | ヘッダ | コマンドインタプリタ |
| SBTarget.h | `lldb/include/lldb/API/SBTarget.h` | ヘッダ | ターゲットAPI |
| SBProcess.h | `lldb/include/lldb/API/SBProcess.h` | ヘッダ | プロセスAPI |
| Options.inc | `lldb/tools/driver/Options.inc` | 生成 | オプション定義 |
