# 機能設計書 86-clang-repl

## 概要

本ドキュメントは、clang-replツールの機能設計について記述する。clang-replは、C++のREPL（Read-Eval-Print Loop）環境を提供する対話型インタプリタである。

### 本機能の処理概要

clang-replは、Clang Interpreterライブラリを使用して、C++コードを対話的に入力・実行できる環境を提供する。入力されたコードは逐次的にコンパイル・実行され、結果が表示される。

**業務上の目的・背景**：C++は従来コンパイル言語であり、コードの試行錯誤にはコンパイル・リンク・実行のサイクルが必要だった。clang-replは、PythonやRubyのようなスクリプト言語と同様の対話的開発体験をC++で実現する。

**機能の利用シーン**：
- C++コードの実験と学習
- ライブラリAPIの探索
- プロトタイピング
- データ解析や科学計算
- 教育目的

**主要な処理内容**：
1. 対話型プロンプトの表示
2. ユーザー入力の受け付け（複数行対応）
3. コードの逐次コンパイル
4. JIT実行
5. 結果の表示
6. 特殊コマンド（%undo, %quit等）の処理

**関連システム・外部連携**：Clang Interpreter API、LLVM JIT（ORC）、LineEditor。CUDAサポートあり。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIツール | 主画面 | インタラクティブプロンプト |

## 機能種別

対話型実行環境 / REPL

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| code | string list | No | 直接実行するコード | - |
| -Xcc | string list | No | CompilerInvocationに渡す引数 | - |
| --cuda | bool | No | CUDAモードを有効化 | - |
| --cuda-path | string | No | CUDA SDKパス | - |
| --offload-arch | string | No | オフロードアーキテクチャ | - |
| --oop-executor | string | No | Out-of-process実行 | - |
| --oop-executor-connect | string | No | TCP経由でOOP接続 | - |
| --orc-runtime | string | No | ORCランタイムパス | - |
| --slab-allocate | string | No | スラブアロケータサイズ | - |

### 入力データソース

- 標準入力（インタラクティブモード）
- コマンドライン引数（コード直接指定時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行結果 | stdout | コード実行の出力 |
| エラーメッセージ | stderr | コンパイル/実行エラー |

### 出力先

- 標準出力/標準エラー出力

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ cl::ParseCommandLineOptions

2. LLVMターゲット初期化
   └─ InitializeAllTargets/TargetMCs/AsmPrinters/AsmParsers

3. OOP引数のサニタイズ
   └─ sanitizeOopArguments

4. IncrementalCompilerBuilder設定
   └─ CompilerArgs、CUDA設定等

5. CompilerInstance作成
   └─ CreateCpp() または CreateCudaHost()/CreateCudaDevice()

6. Interpreter作成
   └─ Interpreter::create() または createWithCUDA()

7. コマンドライン指定コードの実行
   └─ 引数で指定されたコードをParseAndExecute

8. インタラクティブモード
   └─ LineEditor初期化
   └─ 補完機能設定
   └─ 入力ループ開始

9. 入力処理
   └─ 複数行入力対応（行末\で継続）
   └─ %コマンド処理
   └─ ParseAndExecuteで実行

10. 終了処理
    └─ %quitまたはEOFで終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C[LLVMターゲット初期化]
    C --> D[OOP引数サニタイズ]
    D --> E[IncrementalCompilerBuilder設定]
    E --> F{CUDAモード?}
    F -->|Yes| G[CreateCudaHost/Device]
    F -->|No| H[CreateCpp]
    G --> I[Interpreter::createWithCUDA]
    H --> J[Interpreter::create]
    I --> K{コードが引数で指定?}
    J --> K
    K -->|Yes| L[ParseAndExecute]
    L --> M{エラー?}
    M -->|Yes| N[エラー報告]
    N --> O{次のコード?}
    M -->|No| O
    O -->|Yes| L
    O -->|No| P{引数のみモード?}
    P -->|Yes| Z[終了]
    P -->|No| Q[LineEditor初期化]
    Q --> R[入力待ち]
    R --> S{入力あり?}
    S -->|No/EOF| Z
    S -->|Yes| T{行末 \?}
    T -->|Yes| U[入力を蓄積]
    U --> R
    T -->|No| V{%コマンド?}
    V -->|%quit| Z
    V -->|%undo| W[Interp->Undo]
    V -->|%help| X[ヘルプ表示]
    V -->|%lib| Y[LoadDynamicLibrary]
    V -->|No| AA[ParseAndExecute]
    W --> R
    X --> R
    Y --> R
    AA --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 複数行入力 | 行末の\で入力を継続 | インタラクティブモード |
| BR-02 | %コマンド | 特殊コマンドは%で開始 | 常時 |
| BR-03 | OOP排他 | -oop-executorと-oop-executor-connectは同時指定不可 | OOP使用時 |
| BR-04 | OOPプラットフォーム制限 | OOPはUnix系プラットフォームのみ | OOP使用時 |

### 特殊コマンド

| コマンド | 説明 |
|---------|------|
| %quit | clang-replを終了 |
| %undo | 直前の入力を取り消し |
| %help | コマンド一覧を表示 |
| %lib \<path\> | 動的ライブラリをロード |

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | コンパイルエラー | 無効なC++コード | コードを修正 |
| 1 | 実行時エラー | プログラムのクラッシュ | コードを修正 |
| 1 | オプションエラー | 無効なオプション組み合わせ | オプションを確認 |
| 70 | LLVM致命的エラー | LLVMバックエンドのエラー | 環境を確認 |

### リトライ仕様

インタラクティブモードではエラー後も入力を継続可能。

## トランザクション仕様

該当なし。%undoで直前の入力を取り消し可能。

## パフォーマンス要件

特に規定なし。JITコンパイル時間はコードサイズに依存。

## セキュリティ考慮事項

- 任意のC++コードを実行可能
- システムコール制限なし
- 信頼できないコードの実行は危険

## 備考

- CUDAサポートにより GPU計算も可能
- Out-of-process実行でデバッグ/隔離が可能
- -verifyオプションでテストモード動作

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClangRepl.cpp | `clang/tools/clang-repl/ClangRepl.cpp` | main関数と全体フロー |

**主要処理フロー**:
1. **258-262行目**: コマンドライン解析、LLVM初期化
2. **269-274行目**: ターゲット初期化
3. **292行目**: OOP引数サニタイズ
4. **294-295行目**: IncrementalCompilerBuilder設定
5. **328-332行目**: CompilerInstance作成
6. **345-360行目**: Interpreter作成
7. **364-369行目**: 引数コードの実行
8. **371-422行目**: インタラクティブループ

#### Step 2: 補完機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClangRepl.cpp | `clang/tools/clang-repl/ClangRepl.cpp` | ReplListCompleterクラス |

**主要処理フロー**:
- **201-212行目**: ReplListCompleter構造体
- **214-255行目**: 補完実装

#### Step 3: Interpreterを理解する（参考）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Interpreter.h | `clang/include/clang/Interpreter/Interpreter.h` | 公開API |
| 3-2 | Interpreter.cpp | `clang/lib/Interpreter/Interpreter.cpp` | 実装詳細 |

### プログラム呼び出し階層図

```
main (ClangRepl.cpp)
    │
    ├─ cl::ParseCommandLineOptions
    │
    ├─ InitializeAllTargets/TargetMCs/AsmPrinters/AsmParsers
    │
    ├─ sanitizeOopArguments
    │
    ├─ IncrementalCompilerBuilder::SetCompilerArgs
    │
    ├─ IncrementalCompilerBuilder::CreateCpp/CreateCudaHost/CreateCudaDevice
    │
    ├─ Interpreter::create/createWithCUDA
    │
    ├─ Interp->ParseAndExecute (引数コード)
    │
    └─ インタラクティブループ
           │
           ├─ LineEditor::setListCompleter
           │      └─ ReplListCompleter
           │             └─ ReplCodeCompleter::codeComplete
           │
           └─ LineEditor::readLine
                  │
                  ├─ %quit → 終了
                  │
                  ├─ %undo → Interp->Undo
                  │
                  ├─ %help → ヘルプ表示
                  │
                  ├─ %lib <path> → Interp->LoadDynamicLibrary
                  │
                  └─ Interp->ParseAndExecute
                         │
                         ├─ Parse (IncrementalParser)
                         │
                         └─ Execute (IncrementalExecutor/JIT)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──┐
                    │
-Xcc ───────────────┼─▶ IncrementalCompilerBuilder
                    │            │
--cuda* ────────────┘            ▼
                          CompilerInstance
                                 │
                                 ▼
                            Interpreter
                                 │
           ┌─────────────────────┼─────────────────────┐
           ▼                     ▼                     ▼
    引数コード           インタラクティブ入力      %コマンド
           │                     │                     │
           ▼                     ▼                     │
    ParseAndExecute       ParseAndExecute             │
           │                     │                     │
           ├─────────────────────┤                     │
           ▼                     ▼                     ▼
       Parse (AST)          JIT Compile          Undo/Help/Lib
           │                     │                     │
           ▼                     ▼                     │
       Execute               Run Code                 │
           │                     │                     │
           └─────────────────────┴─────────────────────┘
                                 │
                                 ▼
                    stdout (結果) / stderr (エラー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClangRepl.cpp | `clang/tools/clang-repl/ClangRepl.cpp` | ソース | mainエントリーポイント |
| Interpreter.h | `clang/include/clang/Interpreter/Interpreter.h` | ヘッダ | Interpreter公開API |
| Interpreter.cpp | `clang/lib/Interpreter/Interpreter.cpp` | ソース | Interpreter実装 |
| IncrementalParser.h | `clang/include/clang/Interpreter/IncrementalParser.h` | ヘッダ | 逐次パーサー |
| IncrementalExecutor.h | `clang/include/clang/Interpreter/IncrementalExecutor.h` | ヘッダ | 逐次実行 |
| CodeCompletion.h | `clang/include/clang/Interpreter/CodeCompletion.h` | ヘッダ | コード補完 |
