# 機能設計書 9-MLIR

## 概要

本ドキュメントは、MLIR（Multi-Level Intermediate Representation）の機能設計を記述する。MLIRはLLVMプロジェクトのマルチレベル中間表現インフラストラクチャであり、ドメイン固有言語（DSL）やコンパイラの構築を支援する。

### 本機能の処理概要

MLIRは、複数の抽象化レベルでの中間表現を定義・操作するためのインフラストラクチャを提供する。ダイアレクト（方言）システムにより、様々なドメインに特化した操作とデータ型を定義でき、段階的な変換パイプラインを構築できる。

**業務上の目的・背景**：コンパイラインフラストラクチャの再利用性と拡張性を向上させる。機械学習コンパイラ（TensorFlow XLA等）、ハードウェア合成、DSLコンパイラなど、多様なドメインでの活用を可能にする。LLVMの抽象化レベルより高レベルな最適化と変換をサポートする。

**機能の利用シーン**：
- 機械学習フレームワークのコンパイラ構築
- DSL（ドメイン固有言語）のコンパイラ開発
- ハードウェア記述言語の処理
- 高レベル最適化パスの開発
- LLVM IRへの段階的変換

**主要な処理内容**：
1. MLIR入力の解析（パース）
2. ダイアレクト登録と操作定義
3. 変換パスの適用
4. IR検証
5. 出力生成（MLIR/LLVM IR）

**関連システム・外部連携**：
- LLVM Coreとの連携
- TensorFlow/PyTorchとの連携
- 各種ダイアレクト（Affine、SCF、Linalg等）

**権限による制御**：特になし（コマンドラインツールとして実行）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | MLIRはCLIツールであり、GUI画面は持たない |

## 機能種別

中間表現処理 / 変換パイプライン / コンパイラインフラストラクチャ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 入力ファイル | string | No | MLIR入力ファイル | .mlir |
| -pass-pipeline | string | No | パスパイプライン指定 | 有効なパス構文 |
| -convert-* | flag | No | 変換パス指定 | 各種変換オプション |
| -o | string | No | 出力ファイル名 | 有効なパス |
| -split-input-file | flag | No | 入力ファイル分割 | true/false |
| -verify-diagnostics | flag | No | 診断検証 | true/false |
| -mlir-print-op-generic | flag | No | 汎用形式出力 | true/false |
| -allow-unregistered-dialect | flag | No | 未登録ダイアレクト許可 | true/false |

### 入力データソース

- MLIR形式ファイル（.mlir）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| MLIR出力 | .mlir | 変換後のMLIR |
| LLVM IR | .ll | LLVM形式出力 |
| 診断メッセージ | text | エラー/警告 |

### 出力先

- ファイル（-oオプションで指定）
- 標準出力

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ パス登録、ダイアレクト登録
2. 入力解析
   └─ MLIR形式のパース
3. パスパイプライン構築
   └─ 指定パスのパイプライン構築
4. パス実行
   └─ 変換パスの適用
5. 検証
   └─ 出力IRの整合性検証
6. 出力生成
   └─ MLIR/LLVM IR出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[registerAllPasses]
    B --> C[registerAllDialects]
    C --> D[registerAllExtensions]
    D --> E[MlirOptMain]
    E --> F{入力解析}
    F -->|成功| G[パス実行]
    F -->|失敗| H[エラー出力]
    G --> I[IR検証]
    I --> J{検証結果}
    J -->|成功| K[出力生成]
    J -->|失敗| H
    K --> L[終了]
    H --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | パス登録 | 起動時に全パス登録 | 初期化時 |
| BR-002 | ダイアレクト登録 | 起動時に全ダイアレクト登録 | 初期化時 |
| BR-003 | 段階的変換 | 高レベルから低レベルへ段階的に変換 | 変換時 |
| BR-004 | 検証必須 | 各パス後にIR検証 | パス実行後 |

### 計算ロジック

- パターンマッチング：パス内での操作パターン検出
- グラフ書き換え：操作グラフの変換
- ダイアレクト変換：異なるダイアレクト間の変換

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | MLIRはデータベースを使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------
| 1 | 解析エラー | 不正なMLIR形式 | 入力を修正 |
| 1 | 検証エラー | IR整合性違反 | パスを確認 |
| 1 | パスエラー | 不正なパス名 | パス名を確認 |
| 1 | ダイアレクトエラー | 未登録ダイアレクト | 登録またはオプション使用 |

### リトライ仕様

リトライは行わない。エラー発生時は終了コードで通知。

## トランザクション仕様

MLIRはデータベーストランザクションを使用しない。

## パフォーマンス要件

- 大規模IRの効率的な処理
- 並列パス実行のサポート
- メモリ効率の最適化

## セキュリティ考慮事項

- 入力ファイルの検証
- 未登録ダイアレクトの制御

## 備考

MLIRは拡張可能なダイアレクトシステムにより、様々なドメイン固有の表現をサポートする。TensorFlow、PyTorch、CIRCTなど、多くのプロジェクトがMLIRを基盤として活用している。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mlir-opt.cpp | `mlir/tools/mlir-opt/mlir-opt.cpp` | メインエントリーポイント |

**主要処理フロー**:
1. **325-349行目**: main関数 - メインエントリー
2. **326行目**: registerAllPasses() - 全パス登録
3. **328行目**: registerTestPasses()（テスト時）
4. **330-331行目**: DialectRegistryへのダイアレクト登録
5. **332行目**: registerAllExtensions() - 拡張登録
6. **337行目**: registerAllGPUToLLVMIRTranslations()
7. **347-348行目**: MlirOptMain実行

#### Step 2: パス登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mlir-opt.cpp | `mlir/tools/mlir-opt/mlir-opt.cpp` | パス登録 |

**主要処理フロー**:
- **34-172行目**: テストパス登録関数の宣言
- **185-322行目**: registerTestPasses関数 - 全テストパス登録

#### Step 3: ダイアレクト登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mlir-opt.cpp | `mlir/tools/mlir-opt/mlir-opt.cpp` | ダイアレクト登録 |

**主要処理フロー**:
- **330行目**: registerAllDialects(registry) - 全ダイアレクト登録
- **340-346行目**: テストダイアレクト登録（テスト時）

### プログラム呼び出し階層図

```
main (mlir-opt.cpp:325)
    │
    ├─ registerAllPasses()
    │      └─ 全変換/解析パス登録
    │
    ├─ [MLIR_INCLUDE_TESTS] registerTestPasses (mlir-opt.cpp:185)
    │      └─ 全テストパス登録
    │
    ├─ DialectRegistry registry
    │      │
    │      ├─ registerAllDialects(registry)
    │      │      └─ Affine, SCF, Linalg, GPU, etc.
    │      │
    │      ├─ registerAllExtensions(registry)
    │      │
    │      └─ registerAllGPUToLLVMIRTranslations(registry)
    │
    ├─ [MLIR_INCLUDE_TESTS] テストダイアレクト登録
    │      ├─ registerIrdlTestDialect
    │      ├─ registerTestDialect
    │      ├─ registerTestDynDialect
    │      └─ registerTestTransformDialectExtension
    │
    └─ MlirOptMain (MlirOptMain.h)
           │
           ├─ コマンドライン解析
           ├─ 入力ファイル解析
           ├─ パスパイプライン構築
           ├─ パス実行
           └─ 出力生成
```

### データフロー図

```
入力ファイル (.mlir)
        │
        v
+------------------+
|      main        |
| (mlir-opt.cpp)   |
+------------------+
        │
        ├─ registerAllPasses
        ├─ registerAllDialects
        ├─ registerAllExtensions
        │
        v
+------------------+
|   MlirOptMain    |
+------------------+
        │
        v
+------------------+
|   入力パース     |
| (MLIRContext)    |
+------------------+
        │
        v
+------------------+
|  パスパイプライン |
| (PassManager)    |
+------------------+
        │
        ├── -convert-*
        ├── -pass-pipeline
        │
        v
+------------------+
|   パス実行       |
|   IR変換         |
+------------------+
        │
        v
+------------------+
|   検証・出力     |
+------------------+
        │
        v
出力 (.mlir / .ll)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mlir-opt.cpp | `mlir/tools/mlir-opt/mlir-opt.cpp` | ソース | メインエントリー |
| MlirOptMain.h | `mlir/include/mlir/Tools/mlir-opt/MlirOptMain.h` | ヘッダ | メイン処理API |
| InitAllDialects.h | `mlir/include/mlir/InitAllDialects.h` | ヘッダ | ダイアレクト登録 |
| InitAllPasses.h | `mlir/include/mlir/InitAllPasses.h` | ヘッダ | パス登録 |
| PassManager.h | `mlir/include/mlir/Pass/PassManager.h` | ヘッダ | パス管理 |
| MLIRContext.h | `mlir/include/mlir/IR/MLIRContext.h` | ヘッダ | IRコンテキスト |
| Dialect.h | `mlir/include/mlir/IR/Dialect.h` | ヘッダ | ダイアレクト定義 |
