# 機能設計書 91-diagtool

## 概要

本ドキュメントは、LLVMプロジェクトにおけるdiagtool（Clang診断情報調査ツール）の機能設計書である。diagtoolはClangコンパイラの診断メッセージ（警告・エラー）に関する情報を調査・表示するためのコマンドラインツールである。

### 本機能の処理概要

diagtoolは、Clangコンパイラが出力する診断メッセージに関するメタ情報を調査し、開発者やツール作成者が診断システムを理解・活用するための情報を提供するツールである。

**業務上の目的・背景**：Clangは数千の診断メッセージを持ち、それぞれが警告フラグ（-Wオプション）と関連付けられている。開発者がどの警告フラグがどの診断を制御するか、またコマンドラインオプションによって有効化される警告を確認するために、診断情報を体系的に調査できるツールが必要である。

**機能の利用シーン**：
- コンパイラ開発者が新しい警告フラグを追加する際の確認
- ビルドシステム設計者が有効化すべき警告を検討する際
- IDE/エディタプラグイン開発者が診断情報を利用する際
- 教育目的でClangの警告体系を理解する際

**主要な処理内容**：
1. `list-warnings`: 全警告とその対応フラグを一覧表示
2. `tree`: 警告フラグを階層ツリー形式で表示
3. `show-enabled`: 指定されたコマンドラインで有効化される警告を表示
4. `find-diagnostic-id`: 診断名とIDの相互変換

**関連システム・外部連携**：Clangの診断システム（DiagnosticIDs、DiagnosticGroups）と密接に連携し、コンパイラの内部診断データベースを参照する。

**権限による制御**：特になし（スタンドアロンのコマンドラインツール）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | コマンドライン引数による操作 |

## 機能種別

情報表示 / 診断情報検索

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| command | string | Yes | 実行するサブコマンド（list-warnings/tree/show-enabled/find-diagnostic-id） | 登録済みコマンド名であること |
| args | string[] | No | サブコマンド固有の引数 | サブコマンドに依存 |

### 入力データソース

- Clangの内蔵診断データベース（DiagnosticIndexName.inc、DiagnosticGroups.inc）
- show-enabledコマンドの場合はソースファイルとコンパイルオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 診断名一覧 | text | 診断名とフラグの組み合わせリスト |
| ツリー表示 | text | 警告フラグの階層構造（色付き） |
| 有効警告一覧 | text | 指定オプションで有効な警告リスト |
| 診断ID | integer | 診断の内部ID番号 |

### 出力先

標準出力（stdout）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ diagtools->getTool()でサブコマンドを取得
2. サブコマンドの実行
   └─ tool->run()で対応するツールを実行
3. 診断データの取得
   └─ getBuiltinDiagnosticsByName()等で内部データを取得
4. 結果のフォーマットと出力
   └─ 標準出力への整形表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{サブコマンド解析}
    B -->|list-warnings| C[ListWarnings::run]
    B -->|tree| D[TreeView::run]
    B -->|show-enabled| E[ShowEnabledWarnings::run]
    B -->|find-diagnostic-id| F[FindDiagnosticID::run]
    B -->|unknown| G[使用法表示]
    C --> H[診断データ取得]
    D --> H
    E --> I[CompilerInvocation作成]
    F --> J[診断名/ID検索]
    H --> K[結果出力]
    I --> K
    J --> K
    G --> L[終了]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-91-01 | 診断分類 | Note/Trap診断は警告リストから除外 | list-warnings実行時 |
| BR-91-02 | 色分け表示 | デフォルト有効=緑、無効=黄、未実装=赤 | tree表示時 |
| BR-91-03 | レベル表示 | W=Warning、E=Error、F=Fatal等の1文字表記 | show-enabled表示時 |

### 計算ロジック

- 警告フラグ統計：flagHistogramで各フラグに属する診断数をカウント
- 有効率計算：Flagged.size() / (Flagged.size() + Unflagged.size()) * 100

## データベース操作仕様

### 操作別データベース影響一覧

本ツールはデータベースを使用しない。Clangの内蔵診断データ（コンパイル時生成）を参照する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | コマンドエラー | 不明なサブコマンド | 使用法を表示して終了 |
| 1 | 診断エラー | 存在しない診断名 | エラーメッセージ表示 |
| EXIT_FAILURE | 初期化エラー | CompilerInvocation作成失敗 | 使用法表示 |

### リトライ仕様

リトライは実装されていない。

## トランザクション仕様

該当なし（読み取り専用ツール）

## パフォーマンス要件

特に規定なし。診断データは全てインメモリで処理される。

## セキュリティ考慮事項

- 入力ファイルのパス検証はshow-enabledコマンドで実施
- 外部入力によるコード実行リスクなし

## 備考

diagtoolはClang開発者向けの内部ツールとして位置付けられる。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

診断情報のデータ構造を把握することが最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiagnosticNames.h | `clang/tools/diagtool/DiagnosticNames.h` | DiagnosticRecord構造体とGroupRecord構造体の定義 |
| 1-2 | DiagTool.h | `clang/tools/diagtool/DiagTool.h` | DiagToolクラスとDEF_DIAGTOOLマクロ |

**読解のコツ**: DiagnosticRecordは診断名とIDのペアを保持し、GroupRecordは警告グループの階層構造を表現する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | diagtool_main.cpp | `clang/tools/diagtool/diagtool_main.cpp` | main関数とサブコマンドディスパッチ |

**主要処理フロー**:
1. **17-20行目**: argv[1]からサブコマンド取得、getTool()でツール検索
2. **20行目**: tool->run()でサブコマンド実行
3. **22-24行目**: 不明コマンド時の使用法表示

#### Step 3: ツール登録システムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DiagTool.cpp | `clang/tools/diagtool/DiagTool.cpp` | DiagToolsクラスによるツール管理 |

**主要処理フロー**:
- **25-26行目**: ToolMapによるコマンド名→ツールのマッピング
- **36-38行目**: registerToolでツール登録
- **40-61行目**: printCommandsで利用可能コマンド一覧表示

#### Step 4: 各サブコマンドの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ListWarnings.cpp | `clang/tools/diagtool/ListWarnings.cpp` | 警告一覧表示の実装 |
| 4-2 | TreeView.cpp | `clang/tools/diagtool/TreeView.cpp` | ツリー表示の実装 |
| 4-3 | ShowEnabledWarnings.cpp | `clang/tools/diagtool/ShowEnabledWarnings.cpp` | 有効警告表示 |
| 4-4 | FindDiagnosticID.cpp | `clang/tools/diagtool/FindDiagnosticID.cpp` | 診断ID検索 |

**主要処理フロー（ListWarnings）**:
- **49-73行目**: 全診断をイテレートし、フラグ有無で分類
- **75-76行目**: フラグ付き警告の出力
- **78-79行目**: フラグなし警告の出力
- **83-97行目**: 統計情報の計算と出力

### プログラム呼び出し階層図

```
main() [diagtool_main.cpp:17]
    │
    ├─ diagTools->getTool() [DiagTool.cpp:31]
    │      └─ ToolMap検索
    │
    └─ tool->run() [各サブコマンド]
           │
           ├─ ListWarnings::run [ListWarnings.cpp:49]
           │      └─ getBuiltinDiagnosticsByName()
           │
           ├─ TreeView::run [TreeView.cpp:142]
           │      └─ getDiagnosticGroups()
           │
           ├─ ShowEnabledWarnings::run [ShowEnabledWarnings.cpp:91]
           │      └─ createDiagnostics()
           │
           └─ FindDiagnosticID::run [FindDiagnosticID.cpp:40]
                  └─ findDiagnostic()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

サブコマンド名 ───▶ ツール検索・ディスパッチ ───▶ 診断情報一覧
                          │
                          ▼
                  診断データベース参照
                  (DiagnosticGroups.inc,
                   DiagnosticIndexName.inc)
                          │
                          ▼
                     結果フォーマット ───────▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| diagtool_main.cpp | `clang/tools/diagtool/diagtool_main.cpp` | ソース | エントリーポイント |
| DiagTool.h | `clang/tools/diagtool/DiagTool.h` | ヘッダ | ツール基底クラス定義 |
| DiagTool.cpp | `clang/tools/diagtool/DiagTool.cpp` | ソース | ツール管理実装 |
| DiagnosticNames.h | `clang/tools/diagtool/DiagnosticNames.h` | ヘッダ | 診断データ構造定義 |
| DiagnosticNames.cpp | `clang/tools/diagtool/DiagnosticNames.cpp` | ソース | 診断データアクセス実装 |
| ListWarnings.cpp | `clang/tools/diagtool/ListWarnings.cpp` | ソース | list-warningsコマンド |
| TreeView.cpp | `clang/tools/diagtool/TreeView.cpp` | ソース | treeコマンド |
| ShowEnabledWarnings.cpp | `clang/tools/diagtool/ShowEnabledWarnings.cpp` | ソース | show-enabledコマンド |
| FindDiagnosticID.cpp | `clang/tools/diagtool/FindDiagnosticID.cpp` | ソース | find-diagnostic-idコマンド |
