# 機能設計書 92-libclang

## 概要

本ドキュメントは、LLVMプロジェクトにおけるlibclang（Clang C言語API）の機能設計書である。libclangは、Clangコンパイラの機能を外部プログラムから利用するためのC言語APIを提供するライブラリである。

### 本機能の処理概要

libclangは、Clangコンパイラのフロントエンド機能をC言語APIとして公開し、IDE、エディタ、コード解析ツールなどの外部アプリケーションがC/C++/Objective-Cソースコードを解析できるようにするライブラリである。

**業務上の目的・背景**：IDE（統合開発環境）やコードエディタ、静的解析ツールなどの開発において、C/C++ソースコードの構文解析、セマンティック解析、コード補完、リファクタリングなどの機能を実装するために、コンパイラの内部機能にアクセスする必要がある。libclangは安定したC APIを提供することで、これらのツールがClangの機能を活用できるようにする。

**機能の利用シーン**：
- IDE/エディタでのコード補完機能の実装
- シンボル検索・定義ジャンプ機能
- ソースコードのインデックス作成
- 静的解析ツールの開発
- リファクタリングツールの開発
- ドキュメント生成ツール

**主要な処理内容**：
1. Translation Unit（翻訳単位）の作成・解析
2. AST（抽象構文木）のトラバース
3. カーソル（AST要素）の操作と情報取得
4. コード補完の実行
5. 診断情報（エラー・警告）の取得
6. ソースロケーション・範囲の管理
7. 型情報の取得

**関連システム・外部連携**：Clangのフロントエンド（AST、Sema、Lex等）と直接連携し、これらの機能をC APIとしてラップする。

**権限による制御**：特になし（ライブラリAPI）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | API | 主機能 | ライブラリとして他プログラムから呼び出される |

## 機能種別

ライブラリAPI / ソースコード解析 / コード補完

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source_filename | const char* | Yes | 解析対象ソースファイルパス | NULLでないこと |
| command_line_args | const char** | No | コンパイルオプション配列 | - |
| num_command_line_args | int | No | コンパイルオプション数 | 0以上 |
| unsaved_files | CXUnsavedFile* | No | 未保存ファイル情報 | - |
| num_unsaved_files | unsigned | No | 未保存ファイル数 | 0以上 |
| options | unsigned | No | 解析オプションフラグ | CXTranslationUnit_* |

### 入力データソース

- C/C++/Objective-Cソースファイル
- ヘッダファイル
- プリコンパイルヘッダ（PCH）
- シリアライズされたAST

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CXTranslationUnit | handle | 翻訳単位ハンドル |
| CXCursor | struct | AST要素カーソル |
| CXType | struct | 型情報 |
| CXSourceLocation | struct | ソース位置情報 |
| CXSourceRange | struct | ソース範囲情報 |
| CXString | struct | 文字列（要解放） |
| CXDiagnostic | handle | 診断情報ハンドル |
| CXCodeCompleteResults | struct | コード補完結果 |

### 出力先

呼び出し元プログラムへの戻り値

## 処理フロー

### 処理シーケンス

```
1. CXIndexの作成
   └─ clang_createIndex()でグローバルインデックス作成
2. Translation Unitの作成/解析
   └─ clang_parseTranslationUnit()でソース解析
3. ASTトラバース
   └─ clang_visitChildren()でカーソル巡回
4. 情報取得
   └─ clang_getCursor*()系APIで情報取得
5. リソース解放
   └─ clang_dispose*()でリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[clang_createIndex]
    B --> C{解析方法}
    C -->|ソースから| D[clang_parseTranslationUnit]
    C -->|ASTから| E[clang_createTranslationUnit]
    D --> F[Translation Unit取得]
    E --> F
    F --> G{処理内容}
    G -->|AST巡回| H[clang_visitChildren]
    G -->|コード補完| I[clang_codeCompleteAt]
    G -->|診断取得| J[clang_getDiagnostic]
    H --> K[カーソル情報取得]
    I --> L[補完結果処理]
    J --> M[エラー/警告表示]
    K --> N[clang_disposeTranslationUnit]
    L --> N
    M --> N
    N --> O[clang_disposeIndex]
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-01 | リソース管理 | 取得したリソースは対応するdispose関数で解放 | 全API利用時 |
| BR-92-02 | スレッド安全性 | CXIndexは複数スレッドで共有可能 | マルチスレッド利用時 |
| BR-92-03 | 文字列解放 | CXStringはclang_disposeString()で解放 | CXString取得時 |
| BR-92-04 | カーソル無効チェック | clang_Cursor_isNull()で無効カーソル確認 | カーソル操作前 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本ライブラリはデータベースを使用しない。インメモリでAST操作を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CXError_Failure | 一般エラー | 解析失敗 | 診断情報を確認 |
| CXError_Crashed | クラッシュ | 内部エラー | リトライまたはバグ報告 |
| CXError_InvalidArguments | 引数エラー | 不正なパラメータ | パラメータを確認 |
| CXError_ASTReadError | AST読込エラー | ASTファイル破損 | ASTファイル再生成 |

### リトライ仕様

クラッシュリカバリ機構（CrashRecoveryContext）により、クラッシュ時も呼び出し元に制御を戻す。

## トランザクション仕様

該当なし（ステートレスAPI）

## パフォーマンス要件

- プリアンブルのキャッシュによる再解析の高速化
- プリコンパイルヘッダ（PCH）サポートによる解析時間短縮
- 部分的再解析（clang_reparseTranslationUnit）のサポート

## セキュリティ考慮事項

- ファイルパスの検証は呼び出し元責任
- クラッシュリカバリ機構によるセキュリティ境界の維持
- SetSafetyThreadStackSizeによるスタックオーバーフロー防止

## 備考

libclangはABI安定性を重視して設計されており、後方互換性が維持される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Index.h | `clang/include/clang-c/Index.h` | 公開APIと主要データ型の定義 |
| 1-2 | CIndexer.h | `clang/tools/libclang/CIndexer.h` | CIndexerクラスの内部構造 |
| 1-3 | CXTranslationUnit.h | `clang/tools/libclang/CXTranslationUnit.h` | 翻訳単位の内部表現 |
| 1-4 | CXCursor.h | `clang/tools/libclang/CXCursor.h` | カーソルの内部表現 |

**読解のコツ**: CXで始まる型はC APIの公開型、内部実装はCIndexerやASTUnitを使用する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CIndex.cpp | `clang/tools/libclang/CIndex.cpp` | 主要API実装のエントリーポイント |
| 2-2 | CIndexer.cpp | `clang/tools/libclang/CIndexer.cpp` | インデクサの初期化処理 |

**主要処理フロー**:
1. **82-97行目（CIndex.cpp）**: MakeCXTranslationUnitでTU作成
2. **95-143行目（CIndexer.cpp）**: getClangResourcesPathでリソースパス取得
3. **155-225行目（CIndexer.cpp）**: LibclangInvocationReporterでログ記録

#### Step 3: カーソル操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CXCursor.cpp | `clang/tools/libclang/CXCursor.cpp` | カーソル操作の実装 |
| 3-2 | CursorVisitor.h | `clang/tools/libclang/CursorVisitor.h` | ASTビジタパターン |

**主要処理フロー**:
- CursorVisitorクラスによるAST巡回
- clang_visitChildren()のコールバック呼び出し

#### Step 4: 補助機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CIndexCodeCompletion.cpp | `clang/tools/libclang/CIndexCodeCompletion.cpp` | コード補完実装 |
| 4-2 | CIndexDiagnostic.cpp | `clang/tools/libclang/CIndexDiagnostic.cpp` | 診断情報処理 |
| 4-3 | CXType.cpp | `clang/tools/libclang/CXType.cpp` | 型情報処理 |
| 4-4 | CXSourceLocation.cpp | `clang/tools/libclang/CXSourceLocation.cpp` | ソース位置処理 |

### プログラム呼び出し階層図

```
clang_createIndex()
    │
    └─ CIndexer::CIndexer()
           │
           └─ PCHContainerOperations作成

clang_parseTranslationUnit()
    │
    ├─ ASTUnit::LoadFromCommandLine()
    │      └─ CompilerInstance設定
    │      └─ フロントエンド実行
    │
    └─ MakeCXTranslationUnit()
           └─ CXTranslationUnitImpl作成

clang_visitChildren()
    │
    └─ CursorVisitor::VisitChildren()
           │
           ├─ 各AST要素への訪問
           │      └─ コールバック呼び出し
           │
           └─ 子要素への再帰

clang_codeCompleteAt()
    │
    └─ ASTUnit::CodeComplete()
           │
           ├─ Sema::CodeComplete*()
           │
           └─ CXCodeCompleteResults構築
```

### データフロー図

```
[入力]                         [処理]                         [出力]

ソースファイル ───────▶ Lexer ──────▶ Token列
                             │
                             ▼
                        Parser ──────▶ AST
                             │
                             ▼
                         Sema ───────▶ 型付きAST
                             │
                             ▼
コマンドライン引数 ───▶ ASTUnit ─────▶ CXTranslationUnit
                             │
                             ▼
                    CursorVisitor ───▶ CXCursor[]
                             │
                             ▼
                      APIラッパー ────▶ C API戻り値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Index.h | `clang/include/clang-c/Index.h` | ヘッダ | 公開C API定義 |
| CIndex.cpp | `clang/tools/libclang/CIndex.cpp` | ソース | 主要API実装 |
| CIndexer.h | `clang/tools/libclang/CIndexer.h` | ヘッダ | インデクサ内部定義 |
| CIndexer.cpp | `clang/tools/libclang/CIndexer.cpp` | ソース | インデクサ実装 |
| CXCursor.h | `clang/tools/libclang/CXCursor.h` | ヘッダ | カーソル内部定義 |
| CXCursor.cpp | `clang/tools/libclang/CXCursor.cpp` | ソース | カーソル操作実装 |
| CursorVisitor.h | `clang/tools/libclang/CursorVisitor.h` | ヘッダ | ビジタパターン定義 |
| CXTranslationUnit.h | `clang/tools/libclang/CXTranslationUnit.h` | ヘッダ | TU内部定義 |
| CXType.h | `clang/tools/libclang/CXType.h` | ヘッダ | 型情報内部定義 |
| CXType.cpp | `clang/tools/libclang/CXType.cpp` | ソース | 型情報実装 |
| CXSourceLocation.h | `clang/tools/libclang/CXSourceLocation.h` | ヘッダ | 位置情報内部定義 |
| CXSourceLocation.cpp | `clang/tools/libclang/CXSourceLocation.cpp` | ソース | 位置情報実装 |
| CXString.h | `clang/tools/libclang/CXString.h` | ヘッダ | 文字列内部定義 |
| CXString.cpp | `clang/tools/libclang/CXString.cpp` | ソース | 文字列実装 |
| CIndexDiagnostic.h | `clang/tools/libclang/CIndexDiagnostic.h` | ヘッダ | 診断内部定義 |
| CIndexDiagnostic.cpp | `clang/tools/libclang/CIndexDiagnostic.cpp` | ソース | 診断実装 |
| CIndexCodeCompletion.cpp | `clang/tools/libclang/CIndexCodeCompletion.cpp` | ソース | コード補完実装 |
| Indexing.cpp | `clang/tools/libclang/Indexing.cpp` | ソース | インデックス作成 |
| CXIndexDataConsumer.h | `clang/tools/libclang/CXIndexDataConsumer.h` | ヘッダ | インデックスデータ |
| CXIndexDataConsumer.cpp | `clang/tools/libclang/CXIndexDataConsumer.cpp` | ソース | インデックスデータ |
