# 機能設計書 96-llvm-stress

## 概要

本ドキュメントは、LLVMプロジェクトにおけるllvm-stress（LLVMストレステストツール）の機能設計書である。llvm-stressは、ランダムなLLVM IR（中間表現）を生成し、LLVMの各コンポーネントをストレステストするためのツールである。

### 本機能の処理概要

llvm-stressは、擬似乱数生成器を使用してランダムなLLVM IR命令を生成し、.llファイルとして出力するツールである。生成されたIRはLLVMの最適化パスやコード生成器のテストに使用される。

**業務上の目的・背景**：LLVMのような大規模コンパイラインフラでは、想定外の入力パターンによるバグを発見するためにファジングテストが重要である。llvm-stressは、有効なLLVM IRをランダムに生成することで、最適化パスやコード生成器のコーナーケースを発見する。

**機能の利用シーン**：
- LLVMの最適化パスのストレステスト
- コード生成器のファジング
- 新しいターゲットアーキテクチャの検証
- リグレッションテストのテストケース生成

**主要な処理内容**：
1. シード値に基づく擬似乱数生成器の初期化
2. 空の関数の生成
3. ランダムな命令の追加（ロード、ストア、算術演算、キャスト等）
4. 制御フローの導入
5. IR検証とファイル出力

**関連システム・外部連携**：LLVM IRモジュール、検証器（Verifier）と連携する。

**権限による制御**：特になし（スタンドアロンツール）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | コマンドライン引数による操作 |

## 機能種別

テストデータ生成 / ストレステスト

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --seed | unsigned | No | 乱数シード（デフォルト: 0） | - |
| --size | unsigned | No | 生成する命令数の目安（デフォルト: 100） | - |
| -o | string | No | 出力ファイル名（デフォルト: "-"=標準出力） | - |
| --types | string[] | No | 追加のスカラー型（カンマ区切り） | half/fp128/x86_fp80/ppc_fp128/iN |
| --enable-scalable-vectors | bool | No | スケーラブルベクター型を生成 | - |

### 入力データソース

コマンドラインオプションのみ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LLVM IR | text | 生成されたLLVM IRモジュール（.ll形式） |

### 出力先

標準出力または-oで指定したファイル

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ LLVMContext、Moduleの作成
2. 関数生成
   └─ GenEmptyFunction()で空関数作成
3. 命令生成
   └─ FillFunction()でランダム命令追加
4. 制御フロー導入
   └─ IntroduceControlFlow()で分岐追加
5. 検証と出力
   └─ verifyModule()で検証
   └─ M->print()で出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C[LLVMContext作成]
    C --> D[Module作成]
    D --> E[GenEmptyFunction]
    E --> F[Random初期化]
    F --> G[FillFunction]
    G --> H[AllocaModifier::ActN - 5回]
    H --> I[ConstModifier::ActN - 40回]
    I --> J[全Modifier::Act ループ]
    J --> K[StoreModifier::ActN - 5回]
    K --> L[IntroduceControlFlow]
    L --> M[verifyModule]
    M --> N{検証成功?}
    N -->|No| O[エラー終了]
    N -->|Yes| P[M->print]
    P --> Q[終了]
    O --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-01 | 乱数生成 | クロスプラットフォームで同一結果を保証 | 同一シード使用時 |
| BR-96-02 | 型選択 | デフォルトでi1/i8/i16/i32/i64/float/double | 常時 |
| BR-96-03 | ベクター幅 | 2^0〜2^4の範囲（正規分布的） | ベクター型生成時 |
| BR-96-04 | i1ベクター禁止 | i1ベクターのストアは生成しない | ストア命令生成時 |

### 計算ロジック

- 乱数生成: (Seed + 0x000b07a1) * 0x3c7c0ac1 の下位19ビット
- ベクター幅: 2^((getRandom() % 3) + (getRandom() % 3))

## データベース操作仕様

### 操作別データベース影響一覧

本ツールはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 出力エラー | ファイル作成失敗 | 出力パス確認 |
| fatal | 検証エラー | 生成IRが不正 | （内部エラー） |
| 1 | 型エラー | 無効な追加型指定 | 有効な型名を使用 |

### リトライ仕様

リトライは実装されていない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- --sizeオプションで生成する命令数を制御可能
- 生成時間はsizeに比例

## セキュリティ考慮事項

- 乱数生成器は暗号学的に安全ではない（テスト目的のみ）

## 備考

生成される関数名: autogen_SD{シード値}

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-stress.cpp | `llvm/tools/llvm-stress/llvm-stress.cpp` | Randomクラス、Modifier基底クラス |

**読解のコツ**: Randomクラスはクロスプラットフォーム乱数生成器、Modifierはランダム命令生成のテンプレートパターン。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-stress.cpp | `llvm/tools/llvm-stress/llvm-stress.cpp` | main関数 |

**主要処理フロー**:
1. **721-726行目**: 初期化とコマンドライン解析
2. **728-730行目**: Module作成と空関数生成
3. **733行目**: Random初期化
4. **735行目**: FillFunction()で命令生成
5. **737行目**: IntroduceControlFlow()で制御フロー追加
6. **753行目**: verifyModule()で検証
7. **757行目**: M->print()で出力

#### Step 3: 乱数生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-stress.cpp | `llvm/tools/llvm-stress/llvm-stress.cpp` | Randomクラス |

**主要処理フロー**:
- **85-97行目**: Randomクラス定義
- **92-97行目**: Rand()メソッド - 19ビット乱数生成
- **99-106行目**: Rand64()メソッド - 64ビット乱数生成

#### Step 4: Modifier群を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llvm-stress.cpp | `llvm/tools/llvm-stress/llvm-stress.cpp` | 各Modifierサブクラス |

**主要処理フロー**:
- **152-322行目**: Modifier基底クラス（型選択、値取得等）
- **324-335行目**: LoadModifier
- **337-354行目**: StoreModifier
- **356-398行目**: BinModifier（二項演算）
- **401-451行目**: ConstModifier（定数生成）
- **453-463行目**: AllocaModifier
- **525-604行目**: CastModifier（型変換）
- **606-628行目**: SelectModifier
- **630-657行目**: CmpModifier（比較演算）

### プログラム呼び出し階層図

```
main() [llvm-stress.cpp:721]
    │
    ├─ GenEmptyFunction() [130-148行目]
    │      └─ Function::Create()
    │
    ├─ FillFunction() [661-695行目]
    │      │
    │      ├─ AllocaModifier::ActN(5)
    │      │
    │      ├─ ConstModifier::ActN(40)
    │      │
    │      └─ [全Modifier::Act ループ]
    │             ├─ LoadModifier::Act()
    │             ├─ StoreModifier::Act()
    │             ├─ ExtractElementModifier::Act()
    │             ├─ ShuffModifier::Act()
    │             ├─ InsertElementModifier::Act()
    │             ├─ BinModifier::Act()
    │             ├─ CastModifier::Act()
    │             ├─ SelectModifier::Act()
    │             └─ CmpModifier::Act()
    │
    ├─ IntroduceControlFlow() [697-717行目]
    │      └─ BasicBlock::splitBasicBlock()
    │
    └─ verifyModule()
           └─ M->print()
```

### データフロー図

```
[入力]                        [処理]                        [出力]

--seed ────────────────▶ Random初期化
                              │
                              ▼
--size ────────────────▶ 命令数決定
                              │
                              ▼
--types ───────────────▶ 型リスト拡張
                              │
                              ▼
                        GenEmptyFunction() ───▶ 空のFunction
                              │
                              ▼
                        Modifier群::Act() ────▶ ランダム命令追加
                              │
                              ▼
                        IntroduceControlFlow() ───▶ 分岐追加
                              │
                              ▼
                        verifyModule() ───────▶ 検証
                              │
                              ▼
                        M->print() ───────────▶ .ll出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-stress.cpp | `llvm/tools/llvm-stress/llvm-stress.cpp` | ソース | 全機能の実装 |
