# 機能設計書 98-spirv-tools

## 概要

本ドキュメントは、LLVMプロジェクトにおけるspirv-tools（SPIR-V操作ツール群）の機能設計書である。spirv-toolsは、SPIR-V（Standard Portable Intermediate Representation for Vulkan）形式のシェーダーバイナリを操作するためのツール群であり、LLVMプロジェクトでは外部プロジェクトとして統合される。

### 本機能の処理概要

spirv-toolsは、Khronos GroupのSPIRV-Toolsプロジェクトから提供されるツール群をLLVMビルドシステムに統合し、SPIR-V関連のテストやビルドで利用できるようにする統合モジュールである。

**業務上の目的・背景**：SPIR-Vは、Vulkan、OpenCL、OpenGL等で使用されるシェーダーバイナリ形式である。LLVMのSPIR-Vバックエンドやフロントエンドの開発・テストにおいて、SPIR-Vファイルの逆アセンブル、検証、アセンブル、リンクが必要となる。

**機能の利用シーン**：
- SPIR-Vバックエンドのテスト
- シェーダーコンパイルパイプラインの検証
- SPIR-Vバイナリのデバッグ・解析
- クロスコンパイル環境の構築

**主要な処理内容**：
1. spirv-dis: SPIR-Vバイナリの逆アセンブル
2. spirv-val: SPIR-Vバイナリの検証
3. spirv-as: SPIR-Vアセンブリのアセンブル
4. spirv-link: 複数SPIR-Vモジュールのリンク

**関連システム・外部連携**：Khronos Group SPIRV-Toolsプロジェクト（外部依存）と連携する。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | 各ツールのコマンドライン操作 |

## 機能種別

ビルド統合 / 外部ツール連携

## 入力仕様

### 入力パラメータ

本モジュールはCMakeLists.txtによるビルド設定であり、実行時パラメータは含まれない。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| LLVM_INCLUDE_SPIRV_TOOLS_TESTS | bool | No | SPIRV-Toolsテストを含めるか | CMakeオプション |
| SPIRV_DIS | path | No | 既存spirv-disバイナリのパス | - |
| SPIRV_VAL | path | No | 既存spirv-valバイナリのパス | - |
| SPIRV_AS | path | No | 既存spirv-asバイナリのパス | - |
| SPIRV_LINK | path | No | 既存spirv-linkバイナリのパス | - |

### 入力データソース

- Khronos Group SPIRV-Toolsリポジトリ（GitHubから自動取得）
- または既存のSPIRV-Toolsバイナリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| spirv-dis | executable | SPIR-V逆アセンブラ |
| spirv-val | executable | SPIR-V検証ツール |
| spirv-as | executable | SPIR-Vアセンブラ |
| spirv-link | executable | SPIR-Vリンカ |

### 出力先

LLVM_RUNTIME_OUTPUT_INTDIR（LLVMビルド出力ディレクトリ）

## 処理フロー

### 処理シーケンス

```
1. オプション確認
   └─ LLVM_INCLUDE_SPIRV_TOOLS_TESTSがOffなら終了
2. 既存バイナリ確認
   └─ SPIRV_*変数が設定されていれば使用
3. ソースからビルド
   └─ ExternalProject_Addでクローンとビルド
4. シンボリックリンク作成
   └─ ビルド成果物をLLVM出力ディレクトリにリンク
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{LLVM_INCLUDE_SPIRV_TOOLS_TESTS?}
    B -->|Off| C[終了]
    B -->|On| D{既存バイナリ指定?}
    D -->|Yes| E[既存バイナリへリンク]
    D -->|No| F[ExternalProject_Add]
    F --> G[SPIRV-Toolsクローン]
    G --> H[git-sync-deps実行]
    H --> I[CMakeビルド]
    I --> J[spirv-dis/val/as/link生成]
    J --> K[LLVMディレクトリへリンク]
    E --> K
    K --> C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-98-01 | デフォルト無効 | LLVM_INCLUDE_SPIRV_TOOLS_TESTSはデフォルトOff | CMake構成時 |
| BR-98-02 | シンボリックリンク | Unix系ではcreate_symlink、Windowsではcopy | プラットフォーム依存 |
| BR-98-03 | 自動更新無効 | UPDATE_DISCONNECTEDで自動更新しない | ビルド効率化 |
| BR-98-04 | 手動更新可能 | SPIRVTools-updateターゲットで手動更新 | 明示的な更新時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本モジュールはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CMakeエラー | ビルドエラー | SPIRV-Toolsビルド失敗 | ネットワーク/依存関係確認 |
| CMakeエラー | クローンエラー | Git取得失敗 | ネットワーク確認 |

### リトライ仕様

CMakeのExternalProject機能に依存。手動でSPIRVTools-updateを実行可能。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 初回ビルドでSPIRV-Toolsのクローン・ビルドが必要（数分〜十数分）
- 既存バイナリ指定時は即座に完了

## セキュリティ考慮事項

- 外部リポジトリからのコード取得を伴う
- mainブランチを追跡するため、最新の変更が含まれる

## 備考

SPIRV-Toolsは活発に開発されているため、LLVMとのバージョン互換性に注意が必要。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: CMakeLists.txtを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CMakeLists.txt | `llvm/tools/spirv-tools/CMakeLists.txt` | 全体構造の理解 |

**読解のコツ**: ExternalProject_Addが外部プロジェクトのビルドを定義し、add_custom_targetがシンボリックリンク作成を定義する。

#### Step 2: オプション定義を理解する

**主要処理フロー**:
1. **1-6行目**: LLVM_INCLUDE_SPIRV_TOOLS_TESTSオプション定義
2. **8-34行目**: ExternalProject_AddでSPIRV-Toolsビルド定義
3. **36-40行目**: シンボリックリンク設定

#### Step 3: 各ツールのターゲット定義を理解する

**主要処理フロー**:
- **43-51行目**: spirv-disターゲット
- **53-61行目**: spirv-valターゲット
- **63-71行目**: spirv-asターゲット
- **73-81行目**: spirv-linkターゲット

### プログラム呼び出し階層図

```
CMakeLists.txt
    │
    ├─ option(LLVM_INCLUDE_SPIRV_TOOLS_TESTS)
    │
    ├─ [条件: SPIRV_*未指定]
    │      │
    │      └─ ExternalProject_Add(SPIRVTools)
    │             │
    │             ├─ GIT_REPOSITORY: Khronos/SPIRV-Tools
    │             ├─ DOWNLOAD_COMMAND: git clone + sync-deps
    │             └─ BUILD_COMMAND: cmake --build
    │
    └─ add_custom_target(spirv-*)
           │
           └─ cmake -E create_symlink/copy
```

### データフロー図

```
[入力]                        [処理]                        [出力]

SPIRV-Tools.git ──────▶ ExternalProject_Add
                              │
                              ├─ git clone
                              ├─ git-sync-deps
                              └─ cmake --build
                              │
                              ▼
                        ビルド成果物
                              │
                              ▼
add_custom_target ────▶ create_symlink ──▶ ${LLVM_RUNTIME_OUTPUT_INTDIR}/
                                                spirv-dis
                                                spirv-val
                                                spirv-as
                                                spirv-link
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CMakeLists.txt | `llvm/tools/spirv-tools/CMakeLists.txt` | CMake | ビルド統合定義 |
