# 機能設計書 99-dxil-dis

## 概要

本ドキュメントは、LLVMプロジェクトにおけるdxil-dis（DirectXシェーダーIL逆アセンブラ）の機能設計書である。dxil-disは、DirectX Shader Compiler（DXC）プロジェクトから提供されるllvm-disバイナリをLLVMビルドシステムに統合し、DXIL（DirectX Intermediate Language）のテストで利用できるようにする統合モジュールである。

### 本機能の処理概要

dxil-disは、MicrosoftのDirectXShaderCompilerプロジェクトをExternalProjectとして取得・ビルドし、そのllvm-disバイナリをdxil-disとしてLLVMビルド出力ディレクトリに配置する。

**業務上の目的・背景**：DXIL（DirectX Intermediate Language）は、DirectX 12以降で使用されるシェーダーバイナリ形式である。LLVMのDirectXバックエンド開発・テストにおいて、DXILバイナリの逆アセンブルが必要となる。

**機能の利用シーン**：
- DirectXバックエンドのテスト
- DXILシェーダーのデバッグ・解析
- DirectXコンパイルパイプラインの検証
- クロスプラットフォームシェーダー開発

**主要な処理内容**：
1. DXCプロジェクトのクローン（または既存ソース使用）
2. llvm-disターゲットのビルド
3. ビルド成果物のシンボリックリンク/コピー

**関連システム・外部連携**：Microsoft DirectXShaderCompilerプロジェクト（外部依存）と連携する。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | dxil-disコマンドの実行 |

## 機能種別

ビルド統合 / 外部ツール連携

## 入力仕様

### 入力パラメータ

本モジュールはCMakeLists.txtによるビルド設定であり、実行時パラメータは含まれない。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| LLVM_INCLUDE_DXIL_TESTS | bool | No | DXILテストを含めるか（デフォルト: Off） | CMakeオプション |
| DXIL_DIS | path | No | 既存dxil-disバイナリのパス | - |
| DXC_SOURCE_DIR | path | No | 既存DXCソースディレクトリ | - |

### 入力データソース

- Microsoft DirectXShaderCompilerリポジトリ（GitHubから自動取得）
- または既存のdxil-disバイナリ
- またはローカルDXCソースディレクトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| dxil-dis | executable | DXIL逆アセンブラ |

### 出力先

LLVM_RUNTIME_OUTPUT_INTDIR（LLVMビルド出力ディレクトリ）

## 処理フロー

### 処理シーケンス

```
1. オプション確認
   └─ LLVM_INCLUDE_DXIL_TESTSがOffなら終了
2. DirectXターゲット確認
   └─ DirectXがビルド対象でなければエラー
3. 既存バイナリ確認
   └─ DXIL_DIS変数が設定されていれば使用
4. ソースからビルド
   └─ ExternalProject_AddでDXCクローンとビルド
5. シンボリックリンク作成
   └─ llvm-disをdxil-disとしてLLVM出力ディレクトリにリンク
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{LLVM_INCLUDE_DXIL_TESTS?}
    B -->|Off| C[終了]
    B -->|On| D{DirectXターゲット有効?}
    D -->|No| E[FATAL_ERROR]
    D -->|Yes| F{既存バイナリ指定?}
    F -->|Yes| G[既存バイナリへリンク]
    F -->|No| H{DXC_SOURCE_DIR指定?}
    H -->|Yes| I[ローカルソース使用]
    H -->|No| J[Gitクローン]
    I --> K[ExternalProject_Add]
    J --> K
    K --> L[llvm-disビルド]
    L --> M[dxil-disとしてリンク]
    G --> M
    M --> C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-99-01 | デフォルト無効 | LLVM_INCLUDE_DXIL_TESTSはデフォルトOff | CMake構成時 |
| BR-99-02 | DirectX必須 | DirectXターゲットがビルド対象でなければエラー | CMake構成時 |
| BR-99-03 | シンボリックリンク | Unix系ではcreate_symlink、Windowsではcopy | プラットフォーム依存 |
| BR-99-04 | 既存バイナリ優先 | DXIL_DIS指定時はビルドをスキップ | 既存バイナリ存在時 |
| BR-99-05 | ローカルソース優先 | DXC_SOURCE_DIR指定時はGitクローンをスキップ | ローカルソース存在時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本モジュールはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FATAL_ERROR | 構成エラー | DirectXターゲット未有効 | LLVM_TARGETS_TO_BUILDにDirectXを追加 |
| CMakeエラー | ビルドエラー | DXCビルド失敗 | ネットワーク/依存関係確認 |
| CMakeエラー | クローンエラー | Git取得失敗 | ネットワーク確認 |

### リトライ仕様

CMakeのExternalProject機能に依存。ビルド失敗時は手動で再実行可能。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 初回ビルドでDXCプロジェクトのクローン・ビルドが必要（数十分〜）
- 既存バイナリ指定時は即座に完了
- ローカルソース指定時はクローン時間を節約可能

## セキュリティ考慮事項

- 外部リポジトリからのコード取得を伴う
- mainブランチを追跡するため、最新の変更が含まれる
- PredefinedParams.cmakeでビルド設定を制御

## 備考

DirectXShaderCompilerは大規模プロジェクトのため、初回ビルドに時間がかかる。DXIL_DISオプションで既存バイナリを指定することで、ビルド時間を大幅に短縮可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: CMakeLists.txtを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CMakeLists.txt | `llvm/tools/dxil-dis/CMakeLists.txt` | 全体構造の理解 |

**読解のコツ**: オプション確認 -> 既存バイナリ確認 -> ExternalProject_Add の流れを理解する。

#### Step 2: オプション定義を理解する

**主要処理フロー**:
1. **1-2行目**: LLVM_INCLUDE_DXIL_TESTSオプション定義
2. **4-6行目**: オプションがOffなら早期終了
3. **8-10行目**: DirectXターゲット確認

#### Step 3: 既存バイナリ処理を理解する

**主要処理フロー**:
- **12-16行目**: シンボリックリンク設定（Unix/Windows分岐）
- **18-22行目**: DXIL_DIS指定時の処理

#### Step 4: ExternalProject設定を理解する

**主要処理フロー**:
- **24-35行目**: ソースディレクトリとGit設定
- **37-45行目**: ExternalProject_AddでDXCビルド定義
- **47-50行目**: dxil-disターゲット定義

### プログラム呼び出し階層図

```
CMakeLists.txt
    │
    ├─ option(LLVM_INCLUDE_DXIL_TESTS)
    │      └─ デフォルト: Off
    │
    ├─ [条件: DirectXターゲット必須]
    │      └─ FATAL_ERROR if not present
    │
    ├─ [条件: DXIL_DIS指定時]
    │      └─ add_custom_target(dxil-dis) → 既存バイナリへリンク
    │
    └─ [条件: DXIL_DIS未指定]
           │
           ├─ ExternalProject_Add(DXC)
           │      │
           │      ├─ GIT_REPOSITORY: microsoft/DirectXShaderCompiler
           │      ├─ GIT_TAG: main
           │      ├─ CMAKE_ARGS: PredefinedParams.cmake
           │      └─ BUILD_COMMAND: cmake --build → llvm-dis
           │
           └─ add_custom_target(dxil-dis)
                  │
                  └─ create_symlink/copy: llvm-dis → dxil-dis
```

### データフロー図

```
[入力]                        [処理]                        [出力]

DirectXShaderCompiler.git ──▶ ExternalProject_Add
                                     │
                                     ├─ git clone (optional)
                                     ├─ PredefinedParams.cmake
                                     └─ cmake --build --target llvm-dis
                                     │
                                     ▼
                               llvm-dis バイナリ
                                     │
                                     ▼
add_custom_target ────────▶ create_symlink ──▶ ${LLVM_RUNTIME_OUTPUT_INTDIR}/
                                                     dxil-dis
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CMakeLists.txt | `llvm/tools/dxil-dis/CMakeLists.txt` | CMake | ビルド統合定義 |
