---
generated_at: 2026-02-01 23:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Polly.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `polly/lib/Plugin/Polly.cpp` - プラグインエントリー（21行）
- E-02: `polly/lib/Support/RegisterPasses.cpp` - パス登録処理（682行）
- E-03: `polly/lib/Analysis/ScopInfo.cpp` - SCoP情報構築
- E-04: `機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pollyは多面体最適化フレームワーク | E-03 (8-16行目), E-04 | ○ |
| C-02 | llvmGetPassPluginInfoがプラグインエントリー | E-01 (17-20行目) | ○ |
| C-03 | getPollyPluginInfo関数でプラグイン情報取得 | E-01 (19行目), E-02 (678-681行目) | ○ |
| C-04 | registerPollyPassesでパス登録 | E-02 (625-676行目) | ○ |
| C-05 | PollyCategory定義 | E-02 (66-67行目) | ○ |
| C-06 | -pollyオプションで有効化 | E-02 (70-73行目) | ○ |
| C-07 | POSITION_EARLYとPOSITION_BEFORE_VECTORIZERの選択 | E-02 (80-89行目, 667-674行目) | ○ |
| C-08 | ISLがデフォルトオプティマイザ | E-02 (91-96行目) | ○ |
| C-09 | buildEarlyPollyPipelineでearly位置パイプライン構築 | E-02 (477-504行目) | ○ |
| C-10 | buildLatePollyPipelineでlate位置パイプライン構築 | E-02 (506-530行目) | ○ |
| C-11 | buildCommonPollyPipelineで共通パイプライン構築 | E-02 (460-475行目) | ○ |
| C-12 | PollyFunctionPassで処理実行 | E-02 (468行目) | ○ |
| C-13 | パイプラインパースコールバック登録 | E-02 (648-665行目) | ○ |
| C-14 | ScopInfo構築 | E-03 | ○ |
| C-15 | SCoP検出とカウント統計 | E-03 (89行目) | ○ |
| C-16 | -polly-vectorizerオプション | E-02 (106-116行目) | ○ |
| C-17 | -polly-exportオプション | E-02 (128-131行目) | ○ |
| C-18 | -polly-importオプション | E-02 (118-121行目) | ○ |
| C-19 | -polly-showオプション | E-02 (137-141行目) | ○ |
| C-20 | LLVM_PLUGIN_API_VERSION使用 | E-02 (679行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: すべての主張が根拠に基づいており、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] RegisterPasses.cpp の行番号参照が最新のコードと一致するか確認
- [ ] パス登録のコールバック設定が正確か確認
- [ ] パイプライン構築の順序が正確か確認
