---
generated_at: 2026-02-01 13:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-llvm-ir2vec

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-ir2vec/llvm-ir2vec.cpp`（1-409行目）
- E-02: `llvm/tools/llvm-ir2vec/lib/Utils.h`（1-202行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（101行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-ir2vecはIR2Vec/MIR2Vec埋め込み生成ツール | E-01（9-11行目）、E-03 | ○ |
| C-02 | 2つのモード（llvm/mir）をサポート | E-01（98-107行目） | ○ |
| C-03 | デフォルトモードはLLVM IR | E-01（107行目、init(LLVMIR)） | ○ |
| C-04 | triplets/entities/embeddingsの3サブコマンド | E-01（110-117行目） | ○ |
| C-05 | デフォルト入力は標準入力 | E-01（121行目、init("-")） | ○ |
| C-06 | Level: inst/bb/func | E-01（136-145行目） | ○ |
| C-07 | デフォルトレベルはfunction | E-01（144行目、init(FunctionLevel)） | ○ |
| C-08 | embeddings時は語彙ファイル必須 | E-01（157-162行目） | ○ |
| C-09 | --function で特定関数のみ処理可能 | E-01（167-175行目） | ○ |
| C-10 | IR関係タイプ: Type=0, Next=1, Arg=2+ | E-02（79-83行目） | ○ |
| C-11 | MIR関係タイプ: Next=0, Arg=1+ | E-02（131-134行目） | ○ |
| C-12 | setupMIRContextでMIRコンテキスト初期化 | E-01（190-231行目） | ○ |
| C-13 | createMIRParserFromFileでMIR解析 | E-01（193行目） | ○ |
| C-14 | createTargetMachineForTripleでターゲット設定 | E-01（207行目） | ○ |
| C-15 | EmbeddingLevel列挙型定義 | E-02（52-56行目） | ○ |
| C-16 | Triplet構造体（Head/Tail/Relation） | E-02（60-64行目） | ○ |
| C-17 | IR2VecToolクラス定義 | E-02（86-124行目） | ○ |
| C-18 | MIR2VecToolクラス定義 | E-02（137-187行目） | ○ |
| C-19 | MIRContextでLLVMContext/Module/MMI/TM保持 | E-02（190-195行目） | ○ |
| C-20 | InitializeAllTargetsでターゲット初期化 | E-01（391-394行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全機能がソースコードから確認可能
- 0: 低リスク - サブコマンド構造が明確
- 1: 中リスク - 語彙ファイル形式の詳細はIR2Vec.cpp/MIR2Vec.cppを参照する必要あり
- 1: 中リスク - 埋め込み生成の具体的アルゴリズムはライブラリ側で実装

## 6) レビュアーチェックリスト（最小）

- [ ] 3つのサブコマンド（triplets/entities/embeddings）が正確
- [ ] デフォルトモード（llvm）とデフォルトレベル（func）が正確
- [ ] IR関係タイプ（Type=0, Next=1, Arg=2+）が正確
- [ ] MIR関係タイプ（Next=0, Arg=1+）が正確
- [ ] main関数の行番号が実際のコードと一致
- [ ] embeddings時の語彙必須条件が正確
- [ ] MIRコンテキスト初期化の流れが正確
