---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-llvm-modextract

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-modextract/llvm-modextract.cpp`
- E-02: `llvm/tools/llvm-modextract/CMakeLists.txt`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (No.105行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マルチモジュールビットコードから特定モジュールを抽出 | E-01 (9-12行目コメント) | ○ |
| C-02 | -bオプションでバイナリ抽出モード | E-01 (28-30行目) | ○ |
| C-03 | -oオプションで出力ファイル指定（必須） | E-01 (32-35行目) | ○ |
| C-04 | 位置引数で入力ファイル指定 | E-01 (37-40行目) | ○ |
| C-05 | デフォルト入力は標準入力（-） | E-01 (39行目 cl::init("-")) | ○ |
| C-06 | -nオプションでモジュールインデックス指定（必須） | E-01 (42-45行目) | ○ |
| C-07 | getBitcodeModuleListでモジュールリスト取得 | E-01 (55行目) | ○ |
| C-08 | インデックスがモジュール数以上ならエラー | E-01 (58-63行目) | ○ |
| C-09 | バイナリモードでgetBuffer()使用 | E-01 (73-74行目) | ○ |
| C-10 | バイナリモードでcopyStrtab()使用 | E-01 (75行目) | ○ |
| C-11 | 通常モードでparseModule()使用 | E-01 (81行目) | ○ |
| C-12 | 通常モードでWriteBitcodeToFile()使用 | E-01 (82行目) | ○ |
| C-13 | MemoryBuffer::getFileOrSTDINで入力読み込み | E-01 (53-54行目) | ○ |
| C-14 | ToolOutputFileで出力ファイル作成 | E-01 (66-67行目) | ○ |
| C-15 | テスト目的で使用されるツール | E-01 (9行目コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- BitcodeModule::parseModule()の詳細実装
  - 候補：`llvm/lib/Bitcode/Reader/BitcodeReader.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなツールで全処理がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] BitcodeModuleクラスの詳細動作を確認
- [ ] バイナリ抽出と通常抽出の結果の違いを確認
