---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-llvm-opt-report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-opt-report/OptReport.cpp`
- E-02: `llvm/tools/llvm-opt-report/CMakeLists.txt`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (No.107行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | YAML形式の備考からソースコード注釈付きレポートを生成 | E-01 (9-13行目コメント) | ○ |
| C-02 | OptReportLocationItemInfo構造体が存在 | E-01 (75-96行目) | ○ |
| C-03 | OptReportLocationInfo構造体が存在 | E-01 (99-149行目) | ○ |
| C-04 | Inlined、Unrolled、Vectorizedの3種類を追跡 | E-01 (100-103行目) | ○ |
| C-05 | VectorizationFactor、InterleaveCount、UnrollCountを保持 | E-01 (104-106行目) | ○ |
| C-06 | -oオプションで出力ファイル指定 | E-01 (51-53行目) | ○ |
| C-07 | -rオプションで相対パスルート指定 | E-01 (55-57行目) | ○ |
| C-08 | -sオプションで簡潔モード | E-01 (59-61行目) | ○ |
| C-09 | --no-demangleオプションでデマングル無効化 | E-01 (63-65行目) | ○ |
| C-10 | --formatオプションで備考形式指定 | E-01 (67-70行目) | ○ |
| C-11 | デフォルト形式はyaml | E-01 (69行目 cl::init("yaml")) | ○ |
| C-12 | readLocationInfo関数で備考を読み込み | E-01 (155-262行目) | ○ |
| C-13 | LocationInfoはファイル→行→関数→列の4階層マップ | E-01 (151-152行目) | ○ |
| C-14 | writeReport関数でレポート出力 | E-01 (264-477行目) | ○ |
| C-15 | inlineパスでInlined情報を更新 | E-01 (243-246行目) | ○ |
| C-16 | loop-unrollパスでUnrolled情報を更新 | E-01 (247-251行目) | ○ |
| C-17 | loop-vectorizeパスでVectorized情報を更新 | E-01 (252-258行目) | ○ |
| C-18 | itaniumDemangleで関数名デマングル | E-01 (359行目) | ○ |
| C-19 | line_iteratorでソースファイルを行ごとに処理 | E-01 (318行目, 323行目) | ○ |
| C-20 | I/U/Vマーカーで最適化を表示 | E-01 (413-418行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全処理がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 出力形式の実例を確認
- [ ] スケーラブルベクトル（vscale）の表示形式を確認
