---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-llvm-tli-checker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-tli-checker/llvm-tli-checker.cpp`
- E-02: `llvm/tools/llvm-tli-checker/Opts.td`
- E-03: `llvm/tools/llvm-tli-checker/CMakeLists.txt`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (No.108行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TLIとSDKライブラリを比較・検証するツール | E-01 (1-7行目コメント) | ○ |
| C-02 | SDKNameMapクラスがシンボル収集を担当 | E-01 (150-157行目) | ○ |
| C-03 | ELF形式のみサポート | E-01 (180-183行目) | ○ |
| C-04 | ET_REL以外では動的シンボルテーブルを使用 | E-01 (187-192行目) | ○ |
| C-05 | IFunc対応（ST_Other + SF_Indirect） | E-01 (169-171行目) | ○ |
| C-06 | --tripleオプションでターゲット指定 | E-01 (273-274行目) | ○ |
| C-07 | --libdirオプションでライブラリディレクトリ指定 | E-01 (289行目) | ○ |
| C-08 | --dump-tliオプションでTLIダンプ | E-01 (281-284行目) | ○ |
| C-09 | --separateオプションで個別レポート | E-01 (290行目, 308-316行目) | ○ |
| C-10 | --reportオプションでレポートレベル指定 | E-01 (292-301行目) | ○ |
| C-11 | summary/discrepancy/fullの3レベル | E-01 (295-298行目) | ○ |
| C-12 | reportNumberOfEntriesで利用可能関数数を報告 | E-01 (110-124行目, 278行目) | ○ |
| C-13 | dumpTLIEntriesでTLI全エントリをダンプ | E-01 (126-146行目, 282行目) | ○ |
| C-14 | maybeInsertSymbolでシンボル種別チェック | E-01 (161-175行目) | ○ |
| C-15 | populateFromObjectでELFからシンボル抽出 | E-01 (178-194行目) | ○ |
| C-16 | populateFromArchiveでアーカイブ処理 | E-01 (198-218行目) | ○ |
| C-17 | populateFromFileでファイル処理 | E-01 (221-253行目) | ○ |
| C-18 | 4カテゴリで比較結果を分類 | E-01 (336-342行目) | ○ |
| C-19 | <<マーカーはTLI yes SDK no | E-01 (340行目, 348行目) | ○ |
| C-20 | >>マーカーはTLI no SDK yes | E-01 (339行目, 348行目) | ○ |
| C-21 | ==マーカーはTLI yes SDK yes | E-01 (341行目, 348行目) | ○ |
| C-22 | PASS/FAILで最終判定 | E-01 (370-375行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全処理がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] TargetLibraryInfoのLibFunc列挙の範囲を確認
- [ ] COFF/MachOサポート追加時の影響を確認
