---
generated_at: 2026-02-01 22:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-BOLT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Facebook性能向上15%の主張**：外部論文参照のため要確認
  2. **DynoStats計算ロジック**：概念的記述のため詳細確認推奨
  3. **処理時間要件**：具体的なベンチマークデータなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bolt/README.md` - プロジェクト概要、使用方法、要件
- E-02: `bolt/tools/driver/llvm-bolt.cpp` - メインエントリーポイント、コマンドラインオプション定義
- E-03: `bolt/include/bolt/Rewrite/RewriteInstance.h` - RewriteInstanceクラス定義
- E-04: `bolt/include/bolt/Core/BinaryContext.h` - BinaryContextクラス定義
- E-05: `bolt/lib/Rewrite/RewriteInstance.cpp` - RewriteInstance実装（先頭200行確認）
- E-06: `bolt/include/bolt/Core/BinaryFunction.h` - BinaryFunctionクラス（ディレクトリ構造から推定）
- E-07: `bolt/include/bolt/Passes/` - 各種最適化パスのヘッダー群
- E-08: `bolt/include/bolt/Profile/DataAggregator.h` - プロファイルデータ処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BOLTはポストリンク最適化ツールである | E-01 | ○ |
| C-02 | 実行プロファイルに基づくコードレイアウト最適化 | E-01 | ○ |
| C-03 | ELF/MachOバイナリに対応 | E-02, E-03 | ○ |
| C-04 | X86-64とAArch64アーキテクチャをサポート | E-01 | ○ |
| C-05 | シンボルテーブルが必須 | E-01 | ○ |
| C-06 | --emit-relocsが推奨される | E-01 | ○ |
| C-07 | perf.dataからプロファイルを取得可能 | E-01, E-02 | ○ |
| C-08 | .fdata形式のプロファイルに対応 | E-01, E-02 | ○ |
| C-09 | インストルメンテーションモードがある | E-01, E-02 | ○ |
| C-10 | 基本ブロックの並び替えが可能 | E-01, E-07 | ○ |
| C-11 | 関数の並び替えが可能 | E-01, E-07 | ○ |
| C-12 | ICF（Identical Code Folding）をサポート | E-05, E-07 | ○ |
| C-13 | 関数分割（hot/cold）をサポート | E-07 | ○ |
| C-14 | main関数がllvm-bolt.cppにある | E-02 | ○ |
| C-15 | 3つのモード（bolt/perf2bolt/boltdiff）がある | E-02 | ○ |
| C-16 | RewriteInstanceがELF処理を担当 | E-02, E-03 | ○ |
| C-17 | MachORewriteInstanceがMachO処理を担当 | E-02 | ○ |
| C-18 | BinaryContextが全体のコンテキストを管理 | E-04 | ○ |
| C-19 | BinaryFunctionMapでアドレスから関数を参照 | E-04 | ○ |
| C-20 | run()メソッドが主要な処理を実行 | E-03 | ○ |
| C-21 | .note.bolt_infoセクションで処理済み識別 | E-01 | ○ |
| C-22 | GCC8の-freorder-blocks-and-partitionと非互換 | E-01 | ○ |
| C-23 | PIEと.soをサポート | E-01 | ○ |
| C-24 | jemalloc/tcmallocで高速化可能 | E-01 | ○ |
| C-25 | 大規模アプリで最大15%の性能向上 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25（Facebook性能向上15%）：README.mdにCGO'19論文への参照があるが、論文自体は外部リソースのため直接検証不可
  - 候補：CGO'19論文 / Facebook技術ブログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードまたはREADME.mdで検証可能
- 1: 中リスク - 性能に関する数値的主張は外部参照に依存

## 6) レビュアーチェックリスト（最小）
- [ ] README.mdの記述と設計書の記述が一致しているか確認
- [ ] llvm-bolt.cppのmain関数の処理フローが正しく記述されているか確認
- [ ] RewriteInstance.hのメソッド一覧と設計書の処理シーケンスが整合しているか確認
- [ ] 最適化パス（Passes/）のファイル一覧と設計書の記述が整合しているか確認
- [ ] 外部参照（CGO'19論文）の性能数値の妥当性を必要に応じて確認
