---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：112-llvm-cxxdump

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり
- 追加確認推奨
  1. 出力フォーマットの詳細仕様
  2. ABI構造の完全なフィールド定義

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `llvm/tools/llvm-cxxdump/llvm-cxxdump.cpp` (1-563行)
- E-02: `llvm/tools/llvm-cxxdump/Error.cpp`
- E-03: 機能一覧.csv (No.112 llvm-cxxdump)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | C++ ABIデータをダンプする | E-01: 8-10行目「Dumps C++ data resident in object files and archives」 | ○ |
| C-02 | MS-ABIとItanium ABI両対応 | E-01: 220行目(??_7)、321行目(_ZTV)等のパターン判定 | ○ |
| C-03 | デフォルト入力はstdin | E-01: 556-557行目「if (opts::InputFilenames.size() == 0) opts::InputFilenames.push_back("-")」 | ○ |
| C-04 | VFTable（??_7）の解析 | E-01: 220-225行目「if (SymName.starts_with("??_7"))」 | ○ |
| C-05 | VBTable（??_8）の解析 | E-01: 228-233行目「else if (SymName.starts_with("??_8"))」 | ○ |
| C-06 | Complete Object Locator（??_R4）の解析 | E-01: 235-242行目「else if (SymName.starts_with("??_R4"))」 | ○ |
| C-07 | Class Hierarchy Descriptor（??_R3）の解析 | E-01: 244-251行目「else if (SymName.starts_with("??_R3"))」 | ○ |
| C-08 | Base Class Descriptor（??_R1）の解析 | E-01: 260-267行目「else if (SymName.starts_with("??_R1"))」 | ○ |
| C-09 | Type Descriptor（??_R0）の解析 | E-01: 269-280行目「else if (SymName.starts_with("??_R0"))」 | ○ |
| C-10 | ThrowInfo（_TI）の解析 | E-01: 282-288行目「else if (SymName.starts_with("_TI"))」 | ○ |
| C-11 | Itanium VTable（_ZTV）の解析 | E-01: 321-338行目「else if (SymName.starts_with("_ZTV"))」 | ○ |
| C-12 | Itanium VTT（_ZTT）の解析 | E-01: 313-316行目「else if (SymName.starts_with("_ZTT"))」 | ○ |
| C-13 | アーカイブの再帰処理 | E-01: 500-523行目 dumpArchive関数 | ○ |
| C-14 | BSS/仮想セクションのスキップ | E-01: 206-207行目「if (Sec.isBSS() || Sec.isVirtual()) continue」 | ○ |
| C-15 | セクションリロケーションマップ構築 | E-01: 176-185行目 SectionRelocMap構築 | ○ |
| C-16 | computeSymbolSizesによるサイズ計算 | E-01: 189-191行目「std::vector<std::pair<SymbolRef, uint64_t>> SymAddr = object::computeSymbolSizes(*Obj)」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要機能は全てソースコードで確認済み。
- 追加で確認可能な情報：
  - 出力フォーマットの詳細仕様（344-497行目の出力ループ詳細）
  - エラーコード定義（Error.cpp内）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり
- 0: 低リスク - ソースコードが明確で追跡容易

## 6) レビュアーチェックリスト（最小）
- [ ] VFTable/VBTable出力形式が期待通りか確認
- [ ] Itanium ABIシンボルのパターン（_Z/\_\_Z）が網羅されているか確認
- [ ] 32/64ビット対応（BytesInAddress使用箇所）の正確性確認
- [ ] CatchableType解析の正確性確認
