---
generated_at: 2026-02-01 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：117-llvm-ml

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり
- 追加確認推奨
  1. MASMとの互換性の詳細範囲
  2. サポートされているMASMディレクティブ一覧

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `llvm/tools/llvm-ml/llvm-ml.cpp` (1-447行)
- E-02: 機能一覧.csv (No.117 llvm-ml)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MASM互換アセンブラである | E-01: 9行目「A simple driver around MasmParser; based on llvm-mc.」 | ○ |
| C-02 | llvm-mcをベースに構築 | E-01: 9行目「based on llvm-mc」 | ○ |
| C-03 | プログラム名ml64で64ビット推測 | E-01: 88-90行目「if (Program.ends_with("ml64")) DefaultBitness = "64"」 | ○ |
| C-04 | デフォルトビット数は32 | E-01: 86行目「StringRef DefaultBitness = "32"」 | ○ |
| C-05 | トリプル生成（32ビット=i386-pc-windows） | E-01: 94行目「.Case("32", "i386-pc-windows")」 | ○ |
| C-06 | トリプル生成（64ビット=x86_64-pc-windows） | E-01: 95行目「.Case("64", "x86_64-pc-windows")」 | ○ |
| C-07 | SafeSEHは32ビットX86のみ | E-01: 282-286行目「if (SafeSEH && !(TheTriple.isArch32Bit() && TheTriple.isX86())) { WithColor::warning() << "/safeseh applies only to 32-bit X86 platforms」 | ○ |
| C-08 | createMCMasmParser使用 | E-01: 158-159行目「std::unique_ptr<MCAsmParser> Parser(createMCMasmParser(SrcMgr, Ctx, Str, MAI, TM, 0))」 | ○ |
| C-09 | MASM固有のLexer設定 | E-01: 171-174行目「Parser->getLexer().setLexMasmIntegers(true); Parser->getLexer().useMasmDefaultRadix(true); Parser->getLexer().setLexMasmHexFloats(true); Parser->getLexer().setLexMasmStrings(true)」 | ○ |
| C-10 | マクロ定義処理（/Dオプション） | E-01: 176-185行目「auto Defines = InputArgs.getAllArgValues(OPT_define); for (StringRef Define : Defines) ... Parser->defineMacro」 | ○ |
| C-11 | @feat.00シンボル生成 | E-01: 416-431行目「if (TheTriple.isOSBinFormatCOFF()) { int64_t Feat00Flags = 0x2; ... MCSymbol *Feat00Sym = Ctx.getOrCreateSymbol("@feat.00")」 | ○ |
| C-12 | SafeSEHフラグ計算（0x1ビット追加） | E-01: 420-426行目「if (SafeSEH) { ... Feat00Flags |= 0x1; }」 | ○ |
| C-13 | 出力ファイルタイプ（s/obj/null） | E-01: 369行目「if (FileType == "s")」、398行目「else if (FileType == "null")」、400行目「else if (FileType == "obj")」 | ○ |
| C-14 | AsLexInputでトークン出力 | E-01: 111-128行目 AsLexInput関数、434-436行目「if (InputArgs.hasArg(OPT_as_lex)) { Res = AsLexInput」 | ○ |
| C-15 | タイムスタンプ処理（UTCオプション） | E-01: 137-156行目「if (InputArgs.hasArg(OPT_timestamp))」および「if (InputArgs.hasArg(OPT_utc)) { TM = *gmtime(&Timestamp); } else { TM = *localtime(&Timestamp); }」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要機能は全てソースコードで確認済み。
- 追加で確認可能な情報：
  - 完全なMASMディレクティブ対応状況（MasmParser.cpp参照）
  - サポートされているMASMマクロ機能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり
- 0: 低リスク - llvm-mcベースの明確な実装

## 6) レビュアーチェックリスト（最小）
- [ ] MASMとの互換性レベルを確認
- [ ] SafeSEH機能の動作を確認
- [ ] @feat.00シンボルの意味を確認（COFF仕様）
- [ ] サポートされているMASMディレクティブを確認
