---
generated_at: 2026-02-01 22:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：12-Compiler-RT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンスオーバーヘッド数値**：一般的な値であり、環境依存の可能性
  2. **シャドウメモリマッピング詳細**：実装詳細は変更される可能性
  3. **サニタイザ互換性制約**：ドキュメントで確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `compiler-rt/README.txt` - プロジェクト概要
- E-02: `compiler-rt/CMakeLists.txt` - ビルドオプション、コンポーネント一覧
- E-03: `compiler-rt/lib/` ディレクトリ構造 - 各コンポーネントの存在確認
- E-04: `compiler-rt/lib/asan/` - AddressSanitizerの存在
- E-05: `compiler-rt/lib/tsan/` - ThreadSanitizerの存在
- E-06: `compiler-rt/lib/msan/` - MemorySanitizerの存在
- E-07: `compiler-rt/lib/ubsan/` - UBSanの存在
- E-08: `compiler-rt/lib/builtins/` - 組み込み関数の存在
- E-09: `compiler-rt/lib/profile/` - プロファイルランタイムの存在
- E-10: `compiler-rt/lib/sanitizer_common/` - サニタイザ共通コードの存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Compiler-RTはコンパイラサポートルーチンを提供 | E-01 | ○ |
| C-02 | builtinsコンポーネントが存在 | E-02, E-08 | ○ |
| C-03 | AddressSanitizerが含まれる | E-02, E-04 | ○ |
| C-04 | ThreadSanitizerが含まれる | E-02, E-05 | ○ |
| C-05 | MemorySanitizerが含まれる | E-02, E-06 | ○ |
| C-06 | UBSanが含まれる | E-02, E-07 | ○ |
| C-07 | プロファイルランタイムが含まれる | E-02, E-09 | ○ |
| C-08 | XRayが含まれる | E-02, E-03 | ○ |
| C-09 | libFuzzerが含まれる | E-02, E-03 | ○ |
| C-10 | ORCランタイムが含まれる | E-02, E-03 | ○ |
| C-11 | sanitizer_commonで共通コードを提供 | E-10 | ○ |
| C-12 | CMakeでビルド設定可能 | E-02 | ○ |
| C-13 | COMPILER_RT_BUILD_BUILTINSオプション存在 | E-02 | ○ |
| C-14 | COMPILER_RT_BUILD_SANITIZERSオプション存在 | E-02 | ○ |
| C-15 | COMPILER_RT_BUILD_XRAYオプション存在 | E-02 | ○ |
| C-16 | COMPILER_RT_BUILD_PROFILEオプション存在 | E-02 | ○ |
| C-17 | GWP-ASanが含まれる | E-02, E-03 | ○ |
| C-18 | SCUDOアロケータが含まれる | E-02, E-03 | ○ |
| C-19 | SafeStackが含まれる | E-03 | ○ |
| C-20 | CFIが含まれる | E-03 | ○ |
| C-21 | LSanが含まれる | E-03 | ○ |
| C-22 | DFSanが含まれる | E-03 | ○ |
| C-23 | HWASanが含まれる | E-02, E-03 | ○ |
| C-24 | interceptionライブラリが存在 | E-03 | ○ |
| C-25 | memprof（メモリプロファイラ）が存在 | E-02, E-03 | ○ |
| C-26 | ctx_profile（コンテキストプロファイル）が存在 | E-02, E-03 | ○ |
| C-27 | ASanは約2倍のオーバーヘッド | **根拠なし** | △ |
| C-28 | スタンドアロンビルドが可能 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-27（パフォーマンスオーバーヘッド）：一般的に知られている数値だが、compiler-rt内部ドキュメントでは未確認
  - 候補：LLVM公式ドキュメント / ASan論文 / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンポーネントの存在はディレクトリ構造で確認済み
- 1: 中リスク - パフォーマンス数値は環境依存、概算値として理解すべき

## 6) レビュアーチェックリスト（最小）
- [ ] CMakeLists.txtのオプション一覧と設計書の記述が一致しているか確認
- [ ] lib/ディレクトリの構造と設計書のコンポーネント一覧が整合しているか確認
- [ ] サニタイザの排他制約（ASanとMSan等）が正しく記述されているか確認
- [ ] パフォーマンスオーバーヘッドの数値が妥当か、必要に応じて外部ドキュメントで確認
