---
generated_at: 2026-02-01 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-clang-installapi

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり
- 追加確認推奨
  1. TextAPI（.tbd）形式の詳細仕様
  2. InstallAPIActionの詳細動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `clang/tools/clang-installapi/ClangInstallAPI.cpp` (1-217行)
- E-02: `clang/tools/clang-installapi/Options.cpp` (1-200行目以降)
- E-03: 機能一覧.csv (No.120 clang-installapi)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InstallAPIのClangライブラリ実装 | E-01: 9-11行目「This is the entry point to clang-installapi; it is a wrapper for functionality in the InstallAPI clang library.」 | ○ |
| C-02 | runFrontendでClangフロントエンド実行 | E-01: 42-69行目 runFrontend関数 | ○ |
| C-03 | createInputBufferで入力バッファ作成 | E-01: 47行目「std::unique_ptr<llvm::MemoryBuffer> ProcessedInput = createInputBuffer(Ctx)」 | ○ |
| C-04 | InMemoryFileSystemへの追加 | E-01: 57行目「FS->addFile(InputFile, /*ModTime=*/0, std::move(ProcessedInput))」 | ○ |
| C-05 | InstallAPIAction使用 | E-01: 67行目「std::make_unique<InstallAPIAction>(Ctx)」 | ○ |
| C-06 | ターゲットごとのスライス作成 | E-01: 127行目「Ctx.Slice = std::make_shared<FrontendRecordsSlice>(Trip)」 | ○ |
| C-07 | 3種類のヘッダータイプ処理 | E-01: 128-129行目「for (const HeaderType Type : {HeaderType::Public, HeaderType::Private, HeaderType::Project})」 | ○ |
| C-08 | 検証モードでverifyBinaryAttrs | E-01: 109-112行目「if (!Ctx.Verifier->verifyBinaryAttrs(Targets, Ctx.BA, Ctx.Reexports, Opts.LinkerOpts.AllowableClients, Opts.LinkerOpts.RPaths, Ctx.FT)) return EXIT_FAILURE」 | ○ |
| C-09 | verifyRemainingSymbols呼び出し | E-01: 151-152行目「if (Ctx.Verifier->verifyRemainingSymbols() == DylibVerifier::Result::Invalid) return EXIT_FAILURE」 | ○ |
| C-10 | InterfaceFile構築 | E-01: 166行目「InterfaceFile IF(Ctx.Verifier->takeExports())」 | ○ |
| C-11 | TextAPIWriter出力 | E-01: 188行目「if (auto Err = TextAPIWriter::writeToStream(*Out, IF, Ctx.FT))」 | ○ |
| C-12 | 出力ファイル必須 | E-02: 127-130行目「if (DriverOpts.OutputPath.empty()) { Diags->Report(diag::err_no_output_file); return false; }」 | ○ |
| C-13 | -archと-targetの排他チェック | E-02: 137-142行目「if (ArgArch && (ArgTarget || ArgTargetVariant)) { Diags->Report(clang::diag::err_drv_argument_not_allowed_with)」 | ○ |
| C-14 | ターゲットトリプル処理 | E-02: 152-165行目「for (const Arg *A : Args.filtered(options::OPT_target)) { ... DriverOpts.Targets[TAPITarget] = TargetTriple」 | ○ |
| C-15 | UniqueArgsループ | E-01: 139-146行目「for (const auto &[Label, ExtraArgs] : Opts.FEOpts.UniqueArgs)」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要機能は全てソースコードで確認済み。
- 追加で確認可能な情報：
  - TextAPI（.tbd）形式の詳細スキーマ
  - InstallAPIActionの詳細実装（InstallAPI/Frontend.cpp）
  - DylibVerifierの検証ロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり
- 0: 低リスク - Apple InstallAPIの明確な実装

## 6) レビュアーチェックリスト（最小）
- [ ] TextAPI形式の出力仕様を確認
- [ ] ヘッダータイプ（Public/Private/Project）の処理順序を確認
- [ ] 検証モード（-verify-against）の動作を確認
- [ ] 複数ターゲット時のマージ動作を確認
