---
generated_at: 2026-02-01 22:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-libc++

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張に根拠あり
- 注意事項
  1. C++標準への準拠度は継続的に更新されるため最新状況の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libcxx/CMakeLists.txt` - ビルドオプション、設定項目
- E-02: `libcxx/include/` ディレクトリ構造 - ヘッダーファイルの存在確認
- E-03: `libcxx/include/__config` - 設定マクロ
- E-04: `libcxx/include/__algorithm/` - アルゴリズム実装ディレクトリ
- E-05: `libcxx/include/__chrono/` - 時間ライブラリディレクトリ
- E-06: `libcxx/include/__filesystem/` - ファイルシステムディレクトリ
- E-07: `libcxx/include/__format/` - フォーマットディレクトリ
- E-08: `libcxx/src/` ディレクトリ構造 - 実装ソースファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libc++はC++標準ライブラリ実装である | E-01 | ○ |
| C-02 | LIBCXX_ENABLE_SHAREDオプションが存在 | E-01 | ○ |
| C-03 | LIBCXX_ENABLE_STATICオプションが存在 | E-01 | ○ |
| C-04 | LIBCXX_ENABLE_EXCEPTIONSオプションが存在 | E-01 | ○ |
| C-05 | LIBCXX_ENABLE_RTTIオプションが存在 | E-01 | ○ |
| C-06 | LIBCXX_ENABLE_FILESYSTEMオプションが存在 | E-01 | ○ |
| C-07 | ハードニングモード（none/fast/extensive/debug）がサポートされる | E-01 | ○ |
| C-08 | vectorヘッダーが存在 | E-02 | ○ |
| C-09 | algorithmヘッダーが存在 | E-02 | ○ |
| C-10 | __algorithmディレクトリが存在 | E-04 | ○ |
| C-11 | __chronoディレクトリが存在 | E-05 | ○ |
| C-12 | __filesystemディレクトリが存在 | E-06 | ○ |
| C-13 | __formatディレクトリが存在 | E-07 | ○ |
| C-14 | __configファイルが存在 | E-03 | ○ |
| C-15 | srcディレクトリに実装コードが存在 | E-08 | ○ |
| C-16 | ヘッダーがモジュール化されている | E-02 | ○ |
| C-17 | __memoryディレクトリが存在 | E-02 | ○ |
| C-18 | __iteratorディレクトリが存在 | E-02 | ○ |
| C-19 | __threadディレクトリが存在 | E-02 | ○ |
| C-20 | __functionalディレクトリが存在 | E-02 | ○ |
| C-21 | __compareディレクトリが存在 | E-02 | ○ |
| C-22 | __conceptsディレクトリが存在 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がディレクトリ構造またはCMakeLists.txtで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CMakeLists.txtのオプション一覧と設計書の記述が一致しているか確認
- [ ] includeディレクトリの構造と設計書のヘッダー一覧が整合しているか確認
- [ ] ハードニングモードの説明が正確か確認
- [ ] C++標準バージョン対応状況が最新か確認
