---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-libc++abi

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `libcxxabi/CMakeLists.txt` - ビルドオプション、設定
- E-02: `libcxxabi/src/` ディレクトリ構造 - ソースファイルの存在確認
- E-03: `libcxxabi/src/cxa_exception.cpp` - 例外処理実装の存在
- E-04: `libcxxabi/src/cxa_personality.cpp` - パーソナリティルーチンの存在
- E-05: `libcxxabi/src/cxa_guard.cpp` - ガード実装の存在
- E-06: `libcxxabi/src/stdlib_new_delete.cpp` - new/delete実装の存在
- E-07: `libcxxabi/src/private_typeinfo.cpp` - RTTI実装の存在
- E-08: `libcxxabi/src/cxa_demangle.cpp` - デマングラーの存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libc++abiはC++ ABIを実装 | E-01 | ○ |
| C-02 | LIBCXXABI_ENABLE_EXCEPTIONSオプションが存在 | E-01 | ○ |
| C-03 | LIBCXXABI_USE_LLVM_UNWINDERオプションが存在 | E-01 | ○ |
| C-04 | MSVCターゲットでは使用不可 | E-01 | ○ |
| C-05 | cxa_exception.cppが存在 | E-02, E-03 | ○ |
| C-06 | cxa_personality.cppが存在 | E-02, E-04 | ○ |
| C-07 | cxa_guard.cppが存在 | E-02, E-05 | ○ |
| C-08 | stdlib_new_delete.cppが存在 | E-02, E-06 | ○ |
| C-09 | private_typeinfo.cppが存在 | E-02, E-07 | ○ |
| C-10 | cxa_demangle.cppが存在 | E-02, E-08 | ○ |
| C-11 | cxa_exception.hが存在 | E-02 | ○ |
| C-12 | cxa_guard_impl.hが存在 | E-02 | ○ |
| C-13 | private_typeinfo.hが存在 | E-02 | ○ |
| C-14 | fallback_malloc.cppが存在 | E-02 | ○ |
| C-15 | cxa_thread_atexit.cppが存在 | E-02 | ○ |
| C-16 | cxa_vector.cppが存在 | E-02 | ○ |
| C-17 | abort_message.cppが存在 | E-02 | ○ |
| C-18 | demangleディレクトリが存在 | E-02 | ○ |
| C-19 | stdlib_exception.cppが存在 | E-02 | ○ |
| C-20 | stdlib_typeinfo.cppが存在 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースファイルまたはCMakeLists.txtで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CMakeLists.txtのオプション一覧と設計書の記述が一致しているか確認
- [ ] src/ディレクトリの構造と設計書のファイル一覧が整合しているか確認
- [ ] 例外処理の流れが正しく記述されているか確認
- [ ] libunwindとの連携が正しく説明されているか確認
