---
generated_at: 2026-02-01 22:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-libunwind

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `libunwind/docs/index.rst` - プロジェクトドキュメント
- E-02: `libunwind/CMakeLists.txt` - ビルドオプション
- E-03: `libunwind/include/` - ヘッダーファイルの存在
- E-04: `libunwind/src/` - ソースファイルの存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libunwindはHP libunwind互換の実装 | E-01 | ○ |
| C-02 | _Unwind_* APIを提供 | E-01, E-03 | ○ |
| C-03 | unw_* APIを提供 | E-01, E-03 | ○ |
| C-04 | Appleが貢献 | E-01 | ○ |
| C-05 | DWARF CFIをサポート | E-01 | ○ |
| C-06 | ARM EHABIをサポート | E-01 | ○ |
| C-07 | SjLjをサポート | E-01 | ○ |
| C-08 | x86/x86_64/ARM/ARM64等をサポート | E-01 | ○ |
| C-09 | Linux/FreeBSD/macOS/Windows等をサポート | E-01 | ○ |
| C-10 | Clang 3.5以降を推奨 | E-01 | ○ |
| C-11 | GCC 4.7以降を推奨 | E-01 | ○ |
| C-12 | リモートアンワインドは未実装 | E-01 | ○ |
| C-13 | srcディレクトリが存在 | E-04 | ○ |
| C-14 | includeディレクトリが存在 | E-03 | ○ |
| C-15 | 静的/動的ライブラリをビルド可能 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がドキュメントまたはディレクトリ構造で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] docs/index.rstの記述と設計書の記述が一致しているか確認
- [ ] プラットフォームサポート状況が最新か確認
- [ ] アンワインド処理の流れが正しく説明されているか確認
