---
generated_at: 2026-02-01 22:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-OpenMP

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `openmp/runtime/README.txt` - ランタイムドキュメント
- E-02: `openmp/CMakeLists.txt` - ビルド構成
- E-03: `openmp/runtime/src/` - ソースファイルの存在
- E-04: `openmp/` ディレクトリ構造 - サブディレクトリの存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenMPランタイムを提供 | E-01 | ○ |
| C-02 | 複数アーキテクチャをサポート | E-01 | ○ |
| C-03 | runtime/ディレクトリが存在 | E-04 | ○ |
| C-04 | runtime/src/ディレクトリが存在 | E-03 | ○ |
| C-05 | libompdが存在 | E-04 | ○ |
| C-06 | tools/が存在 | E-04 | ○ |
| C-07 | icc/icl/gcc/clangをサポート | E-01 | ○ |
| C-08 | Linux/FreeBSD/macOS/Windowsをサポート | E-01 | ○ |
| C-09 | IA-32/Intel 64/ARM/AArch64等をサポート | E-01 | ○ |
| C-10 | Intel OpenMPをベースに開発 | E-01 | ○ |
| C-11 | フォーク・ジョインモデルを使用 | E-01 | ○ |
| C-12 | スレッドプールを使用 | E-01 | ○ |
| C-13 | docs/が存在 | E-04 | ○ |
| C-14 | device/が存在 | E-04 | ○ |
| C-15 | module/が存在 | E-04 | ○ |
| C-16 | CMakeでビルド可能 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がドキュメントまたはディレクトリ構造で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] runtime/README.txtの記述と設計書の記述が一致しているか確認
- [ ] サポートするOpenMPバージョンが最新か確認
- [ ] プラットフォームサポート状況が正確か確認
