---
generated_at: 2026-02-01 22:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-Offload

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張に根拠あり
- 注意事項
  1. 開発中のプロジェクトのためAPIは変更される可能性あり

## 2) 参照した情報（Evidence一覧）

- E-01: `offload/README.md` - プロジェクトドキュメント
- E-02: `offload/CMakeLists.txt` - ビルド構成
- E-03: `offload/` ディレクトリ構造 - サブディレクトリの存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Offloadはアクセラレータ向けランタイムを提供 | E-01 | ○ |
| C-02 | OpenMPオフロードをサポート | E-01 | ○ |
| C-03 | CPU/GPU/FPGA等をサポート | E-01 | ○ |
| C-04 | libomptarget/ディレクトリが存在 | E-03 | ○ |
| C-05 | liboffload/ディレクトリが存在 | E-03 | ○ |
| C-06 | plugins-nextgen/ディレクトリが存在 | E-03 | ○ |
| C-07 | include/ディレクトリが存在 | E-03 | ○ |
| C-08 | tools/ディレクトリが存在 | E-03 | ○ |
| C-09 | test/ディレクトリが存在 | E-03 | ○ |
| C-10 | OpenMP meetingと交互に開催 | E-01 | ○ |
| C-11 | 開発ボードがGitHubに存在 | E-01 | ○ |
| C-12 | Discourseでの議論 | E-01 | ○ |
| C-13 | CMakeでビルド可能 | E-02 | ○ |
| C-14 | docs/ディレクトリが存在 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がドキュメントまたはディレクトリ構造で確認済み
- 注意: 開発中プロジェクトのためAPIは変更される可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] README.mdの記述と設計書の記述が一致しているか確認
- [ ] サポートするターゲットが最新か確認
- [ ] liboffload APIの状況を確認
