---
generated_at: 2026-02-01 23:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-libclc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `libclc/README.md` - プロジェクトREADME（1-68行目）
- E-02: `libclc/CMakeLists.txt` - ビルド構成（1-477行目）
- E-03: `libclc/clc/lib/generic/SOURCES` - CLCビルトイン一覧
- E-04: `libclc/opencl/lib/generic/SOURCES` - OpenCLビルトイン一覧
- E-05: `libclc/` ディレクトリ構造 - サブディレクトリの存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libclcはOpenCL C言語仕様のビルトイン関数を実装 | E-01 | ○ |
| C-02 | OpenCL 1.1仕様に基づく | E-01 | ○ |
| C-03 | PTXターゲットをサポート | E-01, E-02 | ○ |
| C-04 | AMDGPUターゲットをサポート | E-01, E-02 | ○ |
| C-05 | SPIR-Vターゲットをサポート | E-01, E-02 | ○ |
| C-06 | CLSPVターゲットをサポート | E-01, E-02 | ○ |
| C-07 | Clangと連携して使用 | E-01, E-02 | ○ |
| C-08 | ポータブルかつ拡張可能な設計 | E-01 | ○ |
| C-09 | 6.11ビルトイン関数をカバー | E-01 | ○ |
| C-10 | 9.3倍精度浮動小数点をカバー | E-01 | ○ |
| C-11 | 9.4 64ビットアトミックをカバー | E-01 | ○ |
| C-12 | clc/lib/generic/が存在 | E-03, E-05 | ○ |
| C-13 | opencl/lib/generic/が存在 | E-04, E-05 | ○ |
| C-14 | 数学関数を実装 | E-03 | ○ |
| C-15 | 整数関数を実装 | E-03 | ○ |
| C-16 | アトミック関数を実装 | E-03 | ○ |
| C-17 | 幾何関数を実装 | E-03 | ○ |
| C-18 | LLVM 3.9以上が必要 | E-02 | ○ |
| C-19 | CMakeでビルド可能 | E-02 | ○ |
| C-20 | test/ディレクトリが存在 | E-05 | ○ |
| C-21 | clc/include/が存在 | E-05 | ○ |
| C-22 | OpenCL 3.0スタンダードでビルド | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がドキュメントまたはディレクトリ構造で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] README.mdの記述と設計書の記述が一致しているか確認
- [ ] サポートターゲット一覧が最新か確認
- [ ] OpenCL仕様カバレッジが正確か確認
- [ ] ビルトイン関数の分類が適切か確認
