---
generated_at: 2026-02-01 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-llvm-libgcc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm-libgcc/CMakeLists.txt` - メインビルドスクリプト
- E-02: `llvm-libgcc/docs/LLVMLibgcc.rst` - 公式ドキュメント
- E-03: `llvm-libgcc/gcc_s.ver.in` - バージョンスクリプトテンプレート
- E-04: `llvm-libgcc/generate_version_script.py` - スクリプト生成ツール
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-libgccはGCCランタイムライブラリとの互換性レイヤーである | E-02, E-05 | ○ |
| C-02 | glibcは直接libgcc_sをdlopenする | E-02 (15-25行目) | ○ |
| C-03 | libunwindとlibgccは同じABIを持つ | E-02 (31-32行目) | ○ |
| C-04 | LLVM_LIBGCC_EXPLICIT_OPT_INが必須パラメータ | E-01 (38-46行目) | ○ |
| C-05 | compiler-rtとの同時ビルドは禁止 | E-01 (48-52行目) | ○ |
| C-06 | libunwindとの同時ビルドは禁止 | E-01 (54-58行目) | ○ |
| C-07 | COMPILER_RT_BUILTINS_HIDE_SYMBOLS=OFFで設定 | E-01 (92行目) | ○ |
| C-08 | シンボリックリンクでlibgccファミリーを作成 | E-01 (136-143行目) | ○ |
| C-09 | バージョンスクリプトはCプリプロセッサで処理 | E-01 (102-107行目) | ○ |
| C-10 | x86_64/i386/aarch64/arm-gnueabihfをサポート | E-03 (7-13行目) | ○ |
| C-11 | GLOBAL_X86マクロでx86シンボルを選択 | E-03 (15-17行目) | ○ |
| C-12 | GLOBAL_32BIT/64BITマクロで精度別シンボル選択 | E-03 (19-23行目) | ○ |
| C-13 | GCC_3.0バージョンのベースシンボル定義 | E-03 (25-37行目) | ○ |
| C-14 | generate_version_script.pyでシンボル共通部分抽出 | E-04 (43-61行目) | ○ |
| C-15 | llvm-readelfでシンボル一覧取得 | E-04 (69行目) | ○ |
| C-16 | libmをリンク | E-01 (119行目) | ○ |
| C-17 | ディストリビューション管理者向け機能 | E-02 (57-61行目) | ○ |
| C-18 | ビルド時間はcompiler-rt/libunwindに依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件に関する具体的な数値やベンチマーク情報
  - 候補：LLVMプロジェクトのパフォーマンステスト結果 / CI/CDログ / ビルド時間計測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の説明は公式ドキュメントとソースコードに基づいている
- 0: 低リスク - ビルドフローはCMakeLists.txtで明確に定義されている
- 1: 中リスク - サポートアーキテクチャは将来変更される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] llvm-libgccの目的と設計背景が正確に記述されているか確認
- [ ] CMakeLists.txtの処理フローが正確に反映されているか確認
- [ ] バージョンスクリプトのアーキテクチャ分岐が正確か確認
- [ ] シンボリックリンクの構造が実際のビルド出力と一致するか確認
