---
generated_at: 2026-02-01 22:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：22-ORC-RT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項の詳細**：ControllerAccess実装の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `orc-rt/docs/Design.md` - 設計ドキュメント
- E-02: `orc-rt/include/orc-rt/Session.h` - Sessionクラス定義
- E-03: `orc-rt/CMakeLists.txt` - ビルド設定
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ORC-RTはORC JITコンパイラ用ランタイムライブラリ | E-01, E-04 | ○ |
| C-02 | エグゼキュータプロセス側のAPIを提供 | E-01 (3-6行目) | ○ |
| C-03 | SessionはJITプログラムのルートオブジェクト | E-01 (22-24行目) | ○ |
| C-04 | SessionはResourceManagerを所有 | E-02 (194行目) | ○ |
| C-05 | ControllerAccessで双方向RPC通信 | E-01 (35-47行目) | ○ |
| C-06 | タグベースの呼び出し制御 | E-01 (44-47行目) | ○ |
| C-07 | TaskDispatcherでタスクディスパッチ | E-01 (66-71行目) | ○ |
| C-08 | ResourceManagerはdetachとshutdown操作を提供 | E-01 (57-62行目) | ○ |
| C-09 | WrapperFunctionは固定シグネチャの関数 | E-01 (74-80行目) | ○ |
| C-10 | SimplePackedSerializationでシリアライズ | E-01 (104-107行目) | ○ |
| C-11 | C++17を要求 | E-03 (37行目) | ○ |
| C-12 | RTTIと例外処理はオプション | E-03 (33-34行目) | ○ |
| C-13 | Sessionコンストラクタの引数 | E-02 (118-121行目) | ○ |
| C-14 | dispatch()メソッドでタスク実行 | E-02 (132行目) | ○ |
| C-15 | shutdown()で逆順終了 | E-02 (140行目), E-01 (57行目) | ○ |
| C-16 | プロセス間通信のセキュリティ詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ControllerAccess実装の具体的なセキュリティメカニズム
  - 候補：具体的なControllerAccess実装クラス / セキュリティ関連テストケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計ドキュメントが存在し、主要な概念が明確
- 0: 低リスク - Sessionクラスの構造はヘッダファイルで確認可能
- 1: 中リスク - 一部のAPIは「TODO」として文書化未完了

## 6) レビュアーチェックリスト（最小）
- [ ] SessionとControllerAccessの関係が正確に記述されているか確認
- [ ] TaskDispatcherの動作が正確に反映されているか確認
- [ ] WrapperFunctionのシグネチャがDesign.mdと一致するか確認
- [ ] ResourceManagerのライフサイクルが正確か確認
