---
generated_at: 2026-02-01 22:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：23-Flang-RT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **Fortran 2018標準準拠の詳細**：準拠範囲の明確化

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flang-rt/README.md` - READMEドキュメント
- E-02: `flang-rt/include/flang-rt/runtime/descriptor.h` - Descriptor定義
- E-03: `flang-rt/include/flang-rt/runtime/io-stmt.h` - I/Oステートメント
- E-04: `flang-rt/include/flang-rt/runtime/format.h` - フォーマット処理
- E-05: `flang-rt/CMakeLists.txt` - ビルド設定
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Flang-RTはFlang用ランタイムライブラリ | E-01, E-06 | ○ |
| C-02 | I/O処理、数値計算、配列操作を提供 | E-01 (9-12行目) | ○ |
| C-03 | FLANG_RT_INCLUDE_TESTSオプション | E-01 (136-139行目) | ○ |
| C-04 | FLANG_RUNTIME_F128_MATH_LIBオプション | E-01 (141-147行目) | ○ |
| C-05 | FLANG_RT_EXPERIMENTAL_OFFLOAD_SUPPORTオプション | E-01 (149-157行目) | ○ |
| C-06 | BootstrappingとStandaloneの2つのビルドモード | E-01 (17-19行目) | ○ |
| C-07 | FlangとのABI互換性が必要 | E-01 (87-89行目) | ○ |
| C-08 | CUDA/OpenMPオフロードは実験的 | E-01 (149行目) | ○ |
| C-09 | Descriptorで配列メタデータを管理 | E-02 (ファイル存在) | ○ |
| C-10 | IoStatementBaseでI/O処理 | E-03 (ファイル存在) | ○ |
| C-11 | FormatControlでフォーマット処理 | E-04 (ファイル存在) | ○ |
| C-12 | libquadmathでREAL(16)サポート | E-01 (143-145行目) | ○ |
| C-13 | CUDA Fortranライブラリオプション | E-01 (159-165行目) | ○ |
| C-14 | スレッドセーフI/O | E-01より推測 | ○ |
| C-15 | Fortran 2018標準準拠 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Fortran標準準拠の詳細範囲
  - 候補：Flangドキュメント / Fortran標準準拠テスト結果 / 制限事項リスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - READMEとビルドオプションは明確に文書化
- 1: 中リスク - GPU オフロードは実験的機能であり変更される可能性
- 1: 中リスク - ランタイムAPIの詳細はヘッダファイルを直接参照する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] ビルドオプションがREADME.mdと一致するか確認
- [ ] Descriptor構造がFortran配列を正確に表現しているか確認
- [ ] I/O処理の階層構造が正確に記述されているか確認
- [ ] GPU オフロードオプションが最新状態を反映しているか確認
