---
generated_at: 2026-02-01 22:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-llvm-as

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-as/llvm-as.cpp` - メインソースファイル
- E-02: `llvm/tools/llvm-as/CMakeLists.txt` - ビルド設定
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-asは.llから.bcへの変換ツール | E-01 (9-14行目コメント), E-03 | ○ |
| C-02 | 入力はstdinまたは.llファイル | E-01 (35-36行目) | ○ |
| C-03 | -oオプションで出力ファイル指定 | E-01 (38-41行目) | ○ |
| C-04 | -fオプションでターミナル出力許可 | E-01 (43-44行目) | ○ |
| C-05 | -disable-outputで出力無効化 | E-01 (46-47行目) | ○ |
| C-06 | -module-hashでハッシュ出力 | E-01 (49-50行目) | ○ |
| C-07 | -dでパース結果表示 | E-01 (52-53行目) | ○ |
| C-08 | -disable-verifyで検証スキップ | E-01 (55-58行目) | ○ |
| C-09 | -data-layoutでレイアウト指定 | E-01 (60-63行目) | ○ |
| C-10 | 出力ファイル名は.llから.bcに推論 | E-01 (67-75行目) | ○ |
| C-11 | parseAssemblyFileWithIndexでパース | E-01 (128-129行目) | ○ |
| C-12 | verifyModuleで検証 | E-01 (144行目) | ○ |
| C-13 | WriteBitcodeToFileで出力 | E-01 (98行目) | ○ |
| C-14 | エラー時は終了コード1 | E-01 (134, 149行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - ツールの動作は単純で明確

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションがソースコードと一致するか確認
- [ ] 処理フローがmain関数の実装と一致するか確認
- [ ] 出力ファイル名推論ロジックが正確か確認
