---
generated_at: 2026-02-01 22:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-llvm-dis

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-dis/llvm-dis.cpp` - メインソースファイル
- E-02: `llvm/tools/llvm-dis/CMakeLists.txt` - ビルド設定
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-disは.bcから.llへの変換ツール | E-01 (9-10行目コメント), E-03 | ○ |
| C-02 | 複数入力ファイル対応 | E-01 (57-59行目) | ○ |
| C-03 | -oオプションで出力ファイル指定 | E-01 (61-64行目) | ○ |
| C-04 | -fオプションでターミナル出力許可 | E-01 (66-67行目) | ○ |
| C-05 | --show-annotationsでコメント追加 | E-01 (78-81行目) | ○ |
| C-06 | --materialize-metadataでメタデータのみ | E-01 (83-87行目) | ○ |
| C-07 | --disable-outputで出力無効化 | E-01 (69-71行目) | ○ |
| C-08 | --print-thinlto-index-onlyでインデックスのみ | E-01 (89-92行目) | ○ |
| C-09 | 複数入力時は-o使用不可 | E-01 (183-187行目) | ○ |
| C-10 | 出力ファイル名は.bcから.llに推論 | E-01 (236-245行目) | ○ |
| C-11 | マルチモジュールは連番サフィックス | E-01 (242-244, 247-248行目) | ○ |
| C-12 | CommentWriterでアノテーション出力 | E-01 (102-145行目) | ○ |
| C-13 | getBitcodeFileContentsでビットコード読み込み | E-01 (204行目) | ○ |
| C-14 | Module::printでIR出力 | E-01 (267行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - ツールの動作は単純で明確

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションがソースコードと一致するか確認
- [ ] 処理フローがmain関数の実装と一致するか確認
- [ ] マルチモジュール出力のロジックが正確か確認
