---
generated_at: 2026-02-01 22:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-llvm-mc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-mc/llvm-mc.cpp` - メインソースファイル
- E-02: `llvm/tools/llvm-mc/Disassembler.h` - 逆アセンブラヘッダ
- E-03: `llvm/tools/llvm-mc/Disassembler.cpp` - 逆アセンブラ実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-mcはマシンコードのアセンブル/逆アセンブルツール | E-01 (9-12行目コメント), E-04 | ○ |
| C-02 | --tripleでターゲットトリプル指定 | E-01 (150-154行目) | ○ |
| C-03 | --archでアーキテクチャ指定 | E-01 (144-148行目) | ○ |
| C-04 | --filetypeで出力形式指定 | E-01 (128-137行目) | ○ |
| C-05 | --assembleがデフォルトアクション | E-01 (233行目) | ○ |
| C-06 | --disassembleで逆アセンブルモード | E-01 (238-239行目) | ○ |
| C-07 | --as-lexでレキシングモード | E-01 (235行目) | ○ |
| C-08 | --show-encodingでエンコーディング表示 | E-01 (71-73行目) | ○ |
| C-09 | --show-instで内部命令表現表示 | E-01 (84-86行目) | ○ |
| C-10 | -gでデバッグ情報生成 | E-01 (182-185行目) | ○ |
| C-11 | --hexでヘキサバイト入力 | E-01 (103-107行目) | ○ |
| C-12 | GetTargetでターゲット取得 | E-01 (263-281行目) | ○ |
| C-13 | AsLexInputでレキシング実行 | E-01 (313-328行目) | ○ |
| C-14 | AssembleInputでアセンブル実行 | E-01 (351-378行目) | ○ |
| C-15 | Disassembler::disassembleで逆アセンブル | E-01 (670-671行目), E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - ツールの構造は明確

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションがソースコードと一致するか確認
- [ ] 3つのアクション（assemble/disassemble/as-lex）が正確に記述されているか確認
- [ ] ターゲット初期化の順序が正確か確認
