---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：27-llvm-objdump

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **main関数の詳細実装**：ファイルサイズ大のため部分読み込み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-objdump/llvm-objdump.cpp` - メインソースファイル（部分読み込み）
- E-02: `llvm/tools/llvm-objdump/llvm-objdump.h` - ヘッダファイル
- E-03: `llvm/tools/llvm-objdump/ELFDump.cpp` - ELF処理
- E-04: `llvm/tools/llvm-objdump/MachODump.cpp` - MachO処理
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-objdumpはオブジェクトファイル内容を表示するツール | E-01 (9-15行目コメント), E-05 | ○ |
| C-02 | GNU objdump互換の機能を提供 | E-01 (13-14行目コメント) | ○ |
| C-03 | ELF/COFF/MachO/Wasm対応 | E-01 (19-27行目include), E-03, E-04 | ○ |
| C-04 | -dで逆アセンブル | E-01 (299行目 Disassemble変数) | ○ |
| C-05 | -hでセクションヘッダ表示 | E-01より推測 | ○ |
| C-06 | -tでシンボルテーブル表示 | E-01より推測 | ○ |
| C-07 | --demangleでシンボル名デマングル | E-01 (298行目 Demangle変数) | ○ |
| C-08 | BBAddrMapInfo機能 | E-01 (176-288行目) | ○ |
| C-09 | ObjdumpOptTableでオプション管理 | E-01 (136-143行目) | ○ |
| C-10 | OtoolOptTableでotool互換モード | E-01 (168-174行目) | ○ |
| C-11 | SourcePrinterでソース表示 | E-01 (24行目include) | ○ |
| C-12 | アーカイブファイル対応 | E-01より推測 | ○ |
| C-13 | ユニバーサルバイナリ対応 | E-01 (58行目include) | ○ |
| C-14 | debuginfod連携 | E-01 (35-37行目include) | ○ |
| C-15 | main関数の詳細フロー | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- llvm-objdump.cppのmain関数詳細（ファイルが大きいため部分読み込み）
  - 候補：ファイル全体の詳細解析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能はソースコードで確認可能
- 1: 中リスク - ファイルサイズが大きく詳細な検証が困難

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションがObjdumpOpts.tdと一致するか確認
- [ ] フォーマット別処理（ELF/COFF/MachO等）が正確に記述されているか確認
- [ ] SourcePrinterの動作が正確か確認
