---
generated_at: 2026-02-01 22:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-llvm-readobj

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-readobj/llvm-readobj.cpp` - メインソースファイル
- E-02: `llvm/tools/llvm-readobj/ObjDumper.h` - ダンパー基底クラス
- E-03: `llvm/tools/llvm-readobj/ELFDumper.cpp` - ELFダンパー
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-readobjはオブジェクトファイルの詳細情報を読み取るツール | E-01 (9-11行目コメント), E-04 | ○ |
| C-02 | readelfに類似した機能 | E-01 (9行目コメント) | ○ |
| C-03 | FileCheck向けの詳細出力 | E-01 (10-11行目コメント) | ○ |
| C-04 | LLVM/GNU/JSON出力形式 | E-01 (84行目 OutputStyleTy) | ○ |
| C-05 | --allで全情報表示 | E-01 (97行目 All) | ○ |
| C-06 | --file-headerでファイルヘッダ表示 | E-01 (109行目 FileHeaders) | ○ |
| C-07 | --section-headersでセクション表示 | E-01 (118行目 SectionHeaders) | ○ |
| C-08 | --symbolsでシンボル表示 | E-01 (123行目 Symbols) | ○ |
| C-09 | --relocsでリロケーション表示 | E-01 (115行目 Relocations) | ○ |
| C-10 | --demangleでシンボルデマングル | E-01 (104行目 Demangle) | ○ |
| C-11 | --hex-dumpでセクション16進ダンプ | E-01 (111行目 HexDump) | ○ |
| C-12 | --string-dumpで文字列ダンプ | E-01 (121行目 StringDump) | ○ |
| C-13 | reportError/reportWarning関数 | E-01 (190-211行目) | ○ |
| C-14 | ObjDumper基底クラス | E-02 | ○ |
| C-15 | フォーマット別ダンパー（ELF/COFF/MachO等） | E-03, E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - ツールの構造は明確

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションがOpts.tdと一致するか確認
- [ ] 3つの出力形式（LLVM/GNU/JSON）が正確に記述されているか確認
- [ ] フォーマット別ダンパーの構成が正確か確認
