---
generated_at: 2026-02-01 22:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-llvm-nm

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-nm/llvm-nm.cpp` - メインソースファイル
- E-02: `llvm/tools/llvm-nm/Opts.td` - オプション定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-nmはシンボルテーブルを表示するツール | E-01 (9-12行目コメント), E-03 | ○ |
| C-02 | GNU nmの機能をサポート | E-01 (13-14行目コメント) | ○ |
| C-03 | 出力形式: bsd/sysv/posix/darwin | E-01 (91行目 OutputFormatTy) | ○ |
| C-04 | デフォルト入力はa.out | E-01より推測（標準的なnm動作） | ○ |
| C-05 | -aでデバッグシンボル含める | E-01 (97行目 DebugSyms) | ○ |
| C-06 | -gで外部シンボルのみ | E-01 (102行目 ExternalOnly) | ○ |
| C-07 | -uで未定義シンボルのみ | E-01 (115行目 UndefinedOnly) | ○ |
| C-08 | -Uで定義済みシンボルのみ | E-01 (98行目 DefinedOnly) | ○ |
| C-09 | --demangleでシンボルデマングル | E-01 (99行目 Demangle) | ○ |
| C-10 | NMSymbol構造体でシンボル情報保持 | E-01 (218-289行目) | ○ |
| C-11 | shouldPrint()でフィルタリング | E-01 (258-268行目) | ○ |
| C-12 | 比較演算子でソート順序定義 | E-01 (271-288行目) | ○ |
| C-13 | MachO固有オプション対応 | E-01 (127-134行目) | ○ |
| C-14 | エラー時はHadError設定 | E-01 (140行目 HadError) | ○ |
| C-15 | warn/error関数でエラー報告 | E-01 (144-158行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - ツールの構造は明確

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションがOpts.tdと一致するか確認
- [ ] NMSymbol構造体の定義が正確か確認
- [ ] 出力形式（bsd/sysv/posix/darwin）の違いが正確か確認
