---
generated_at: 2026-02-01 22:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-lli.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/lli/lli.cpp` - lliメインドライバ（1312行）
- E-02: `機能一覧.csv` - 機能定義
- E-03: lli.cppのコマンドラインオプション定義（94-280行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lliはLLVM IRを直接実行するJIT/インタプリタ | E-01 (8-12行目), E-02 | ○ |
| C-02 | main関数でネイティブターゲット初期化 | E-01 (427-429行目) | ○ |
| C-03 | -jit-kindでJIT種別選択（mcjit/orc/orc-lazy） | E-01 (110-116行目) | ○ |
| C-04 | デフォルトJITはORC | E-01 (112行目) | ○ |
| C-05 | -force-interpreterでインタプリタモード | E-01 (105-108行目) | ○ |
| C-06 | -entry-functionでエントリーポイント指定（デフォルトmain） | E-01 (184-188行目) | ○ |
| C-07 | runOrcJIT関数でORC JIT処理 | E-01 (918-1184行目) | ○ |
| C-08 | parseIRFileでIR読み込み | E-01 (456行目) | ○ |
| C-09 | EngineBuilder::createでExecutionEngine生成 | E-01 (520行目) | ○ |
| C-10 | runFunctionAsMainで関数実行 | E-01 (681行目) | ○ |
| C-11 | LLIObjectCacheでコンパイル結果キャッシュ | E-01 (299-364行目) | ○ |
| C-12 | -extra-moduleで追加モジュール指定 | E-01 (190-192行目) | ○ |
| C-13 | -dlopenで動的ライブラリロード | E-01 (152-153行目) | ○ |
| C-14 | -enable-cache-managerでキャッシュ有効化 | E-01 (202-204行目) | ○ |
| C-15 | LLLazyJITBuilderでORC JIT構築 | E-01 (936行目) | ○ |
| C-16 | J->addLazyIRModuleで遅延モジュール追加 | E-01 (1106行目) | ○ |
| C-17 | runAsMainでORC JIT実行 | E-01 (1174行目) | ○ |
| C-18 | インタプリタモードではリモート実行不可 | E-01 (505-509行目) | ○ |
| C-19 | -per-module-lazyでモジュール単位遅延コンパイル | E-01 (141-145行目) | ○ |
| C-20 | notifyObjectCompiledでコンパイル結果保存 | E-01 (309-323行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: すべての主張が根拠に基づいており、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] lli.cpp の行番号参照が最新のコードと一致するか確認
- [ ] ORC JITとMCJITの分岐条件が正確か確認
- [ ] オブジェクトキャッシュの動作が説明と一致するか確認
