---
generated_at: 2026-02-01 22:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-llvm-size

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-size/llvm-size.cpp` - メインソースファイル（966行）
- E-02: `llvm/tools/llvm-size/Opts.td` - オプション定義（36行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-sizeはセクションサイズを表示するツール | E-01 (9-12行目コメント), E-03 | ○ |
| C-02 | Unix sizeと互換性のある機能 | E-01 (9行目 "traditional Unix size") | ○ |
| C-03 | 出力形式: berkeley/sysv/darwin | E-01 (70行目 OutputFormatTy) | ○ |
| C-04 | デフォルト入力はa.out | E-01 (954-955行目) | ○ |
| C-05 | --formatで出力形式指定 | E-02 (13行目), E-01 (918-926行目) | ○ |
| C-06 | --radixで基数指定（8/10/16） | E-02 (15行目), E-01 (927-935行目) | ○ |
| C-07 | --totalsで合計表示（berkeley形式のみ） | E-02 (16行目), E-01 (959-960行目) | ○ |
| C-08 | --commonでELFコモンシンボル表示 | E-02 (12行目), E-01 (445-453行目, 483-490行目) | ○ |
| C-09 | MachO固有オプション（--arch, -l, --exclude-pagezero） | E-02 (19-26行目), E-01 (74-82行目) | ○ |
| C-10 | SizeOptTableでオプション管理 | E-01 (62-68行目) | ○ |
| C-11 | printObjectSectionSizes()がコア処理 | E-01 (368-523行目) | ○ |
| C-12 | printDarwinSectionSizes()でdarwin形式出力 | E-01 (206-279行目) | ○ |
| C-13 | printDarwinSegmentSizes()でMachO berkeley形式 | E-01 (281-363行目) | ○ |
| C-14 | considerForSize()でELFセクションフィルタ | E-01 (176-190行目) | ○ |
| C-15 | getCommonSize()でコモンシンボルサイズ取得 | E-01 (192-204行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - ツールの構造は明確でシンプル

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションがOpts.tdと一致するか確認
- [ ] 3つの出力形式（berkeley/sysv/darwin）の動作が正確か確認
- [ ] MachO固有のセグメント分類（__TEXT/__DATA/__OBJC/others）が正確か確認
- [ ] ELFコモンシンボル（--common）の処理が正確か確認
